/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.monitor.web;

import com.jxdinfo.hussar.monitor.web.ContentEntry;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceManager {
    protected String file;
    protected String home;
    protected long lastModified;
    protected Map<String, ContentEntry> cache;
    protected String compress = "^js$|^css$|^xml$|^txt$|^text$|^htm$|^html$";
    private static final Logger logger = LoggerFactory.getLogger(ResourceManager.class);

    public ResourceManager(String file, String home) {
        this.file = file;
        this.home = home;
    }

    public ContentEntry get(String path) {
        if (path == null) {
            return null;
        }
        if (path.matches("[\\.\\/a-zA-Z]+\\?v\\=[0-9\\.]+")) {
            path = path.replaceFirst("\\?v\\=[0-9\\.]+", "");
        }
        return this.cache.get(path);
    }

    public ContentEntry put(String name, boolean memory, long lastModified, byte[] bytes) throws IOException {
        if (name == null) {
            throw new NullPointerException("name must be not null.");
        }
        if (bytes == null) {
            throw new NullPointerException("bytes must be not null.");
        }
        String extension = ResourceManager.getExtension(name);
        Pattern pattern = Pattern.compile(this.compress);
        ContentEntry contentEntry = null;
        logger.info("cache: {}", (Object)name);
        contentEntry = pattern.matcher(extension).matches() ? new ContentEntry(name, 1, memory, lastModified, ResourceManager.gzip(bytes)) : new ContentEntry(name, 0, memory, lastModified, bytes);
        this.cache.put(name, contentEntry);
        return contentEntry;
    }

    public ContentEntry remove(String name) {
        return this.cache.remove(name);
    }

    public static String getString(ContentEntry contentEntry, String charset) throws IOException {
        if (contentEntry == null) {
            return null;
        }
        byte[] bytes = contentEntry.getBytes();
        bytes = contentEntry.getType() == 1 ? ResourceManager.ungzip(contentEntry.getBytes()) : contentEntry.getBytes();
        if (charset != null) {
            return new String(bytes, charset);
        }
        return new String(bytes, "utf-8");
    }

    public static String getExtension(String path) {
        int i;
        if (path == null || path.length() < 1) {
            return "";
        }
        int c = 48;
        for (i = path.length() - 1; i > -1 && (c = (int)path.charAt(i)) != 46 && c != 47 && c != 92 && c != 58; --i) {
        }
        if (c == 46) {
            return path.substring(i + 1);
        }
        return "";
    }

    public static byte[] gzip(byte[] bytes) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        GZIPOutputStream gzipOutputStream = new GZIPOutputStream(outputStream);
        gzipOutputStream.write(bytes, 0, bytes.length);
        gzipOutputStream.finish();
        gzipOutputStream.flush();
        return outputStream.toByteArray();
    }

    public static byte[] ungzip(byte[] bytes) throws IOException {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        GZIPInputStream gzipInputStream = new GZIPInputStream((InputStream)inputStream, bytes.length);
        ResourceManager.copy(gzipInputStream, outputStream);
        return outputStream.toByteArray();
    }

    public static void copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        int length = 0;
        int bufferSize = 2048;
        byte[] buffer = new byte[bufferSize];
        while ((length = inputStream.read(buffer, 0, bufferSize)) > -1) {
            outputStream.write(buffer, 0, length);
        }
        outputStream.flush();
    }
}

