/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.monitor.web;

import javax.servlet.http.HttpServletRequest;

public class Range {
    public long start;
    public long end;
    public long length;

    public Range(long start, long end, long length) {
        this.start = start;
        this.end = end;
        this.length = length;
    }

    public long getSize() {
        return this.end - this.start + 1L;
    }

    public static Range parse(HttpServletRequest request, long length) {
        return Range.parse(request.getHeader("Range"), length);
    }

    public static Range parse(String header, long length) {
        String range = header;
        if (range != null) {
            long start = -1L;
            long end = -1L;
            if (range.startsWith("bytes=")) {
                range = range.substring(6).trim();
            }
            if (range.endsWith("-")) {
                try {
                    start = Long.parseLong(range.substring(0, range.length() - 1), 10);
                    end = length - 1L;
                }
                catch (NumberFormatException numberFormatException) {}
            } else if (range.startsWith("-")) {
                try {
                    start = length - Long.parseLong(range.substring(1), 10);
                    end = length - 1L;
                }
                catch (NumberFormatException numberFormatException) {}
            } else {
                String[] a = range.split("-");
                if (a.length > 1) {
                    try {
                        start = Long.parseLong(a[0], 10);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    try {
                        end = Long.parseLong(a[1], 10);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    if (start == -1L) {
                        start = length - end;
                        end = length - 1L;
                    }
                    if (end == -1L) {
                        end = length - 1L;
                    }
                }
            }
            if (start == -1L || end == -1L || start > end || end > length) {
                return null;
            }
            return new Range(start, end, length);
        }
        return null;
    }

    public String toString() {
        return "bytes=" + this.start + "-" + this.end;
    }

    public String getContentRange() {
        return "bytes " + this.start + "-" + this.end + "/" + this.length;
    }
}

