/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.monitor.web;

import com.jxdinfo.hussar.monitor.util.IO;
import com.jxdinfo.hussar.monitor.web.ContentEntry;
import com.jxdinfo.hussar.monitor.web.ResourceManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JarResourceManager
extends ResourceManager {
    private static final Logger logger = LoggerFactory.getLogger(JarResourceManager.class);

    public JarResourceManager(String file, String home) {
        super(file, home);
        this.reload();
    }

    public void reload() {
        Map temp = this.cache;
        if (this.file.contains("!")) {
            this.cache = this.loadResourceFromBootJar(this.file, this.home);
        } else {
            File file = new File(this.file);
            this.cache = this.load(file, this.home);
            this.lastModified = file.lastModified();
        }
        if (temp != null) {
            temp.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, ContentEntry> load(File file, String home) {
        FileInputStream inputStream = null;
        JarInputStream jarInputStream = null;
        JarFile jarFile = null;
        HashMap<String, ContentEntry> map = new HashMap<String, ContentEntry>(512);
        try {
            JarEntry entry = null;
            jarFile = new JarFile(file);
            inputStream = new FileInputStream(file);
            jarInputStream = new JarInputStream(inputStream);
            Pattern pattern = Pattern.compile(this.compress);
            while ((entry = jarInputStream.getNextJarEntry()) != null) {
                if (entry.isDirectory()) continue;
                String name = entry.getName();
                if (!name.startsWith("/")) {
                    name = "/" + name;
                }
                if (name.endsWith(".class") || !name.startsWith(home)) continue;
                if (home.length() > 1) {
                    name = name.substring(home.length());
                }
                String extension = JarResourceManager.getExtension(name);
                byte[] bytes = IO.read(jarFile.getInputStream(entry), 4096);
                long lastModified = entry.getTime();
                logger.info("cache: {}", (Object)name);
                if (pattern.matcher(extension).matches()) {
                    map.put(name, new ContentEntry(name, 1, true, lastModified, JarResourceManager.gzip(bytes)));
                    continue;
                }
                map.put(name, new ContentEntry(name, 0, true, lastModified, bytes));
            }
        }
        catch (IOException e) {
            try {
                logger.error(e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                IO.close(jarInputStream);
                IO.close(inputStream);
                if (jarFile != null) {
                    try {
                        jarFile.close();
                    }
                    catch (IOException e2) {
                        e2.getMessage();
                    }
                }
                throw throwable;
            }
            IO.close(jarInputStream);
            IO.close(inputStream);
            if (jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (IOException e3) {
                    e3.getMessage();
                }
            }
        }
        IO.close(jarInputStream);
        IO.close(inputStream);
        if (jarFile != null) {
            try {
                jarFile.close();
            }
            catch (IOException e) {
                e.getMessage();
            }
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, ContentEntry> loadResourceFromBootJar(String jarUrl, String home) {
        if (!jarUrl.endsWith(".jar")) {
            return null;
        }
        URL url = null;
        if (jarUrl.startsWith("http://")) {
            try {
                url = new URL("jar:" + jarUrl + "!/");
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
                return null;
            }
        }
        try {
            url = new URL("jar:file:/" + jarUrl + "!/");
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
        HashMap<String, ContentEntry> map = new HashMap<String, ContentEntry>(512);
        JarFile jarFile = null;
        try {
            JarURLConnection jarURLConnection = (JarURLConnection)url.openConnection();
            jarFile = jarURLConnection.getJarFile();
            Enumeration<JarEntry> entries = jarFile.entries();
            Pattern pattern = Pattern.compile(this.compress);
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                if (entry.isDirectory()) continue;
                String name = entry.getName();
                if (!name.startsWith("/")) {
                    name = "/" + name;
                }
                if (name.endsWith(".class") || !name.startsWith(home)) continue;
                if (home.length() > 1) {
                    name = name.substring(home.length());
                }
                String extension = JarResourceManager.getExtension(name);
                byte[] bytes = IO.read(jarFile.getInputStream(entry), 4096);
                long lastModified = entry.getTime();
                logger.info("cache: {}", (Object)name);
                if (pattern.matcher(extension).matches()) {
                    map.put(name, new ContentEntry(name, 1, true, lastModified, JarResourceManager.gzip(bytes)));
                    continue;
                }
                map.put(name, new ContentEntry(name, 0, true, lastModified, bytes));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            Map<String, ContentEntry> map2 = null;
            return map2;
        }
        finally {
            if (jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (IOException e) {
                    e.getMessage();
                }
            }
        }
        return map;
    }
}

