/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.monitor.web;

import com.jxdinfo.hussar.monitor.util.IO;
import com.jxdinfo.hussar.monitor.web.ContentEntry;
import com.jxdinfo.hussar.monitor.web.ResourceManager;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileResourceManager
extends ResourceManager {
    private static final Logger logger = LoggerFactory.getLogger(FileResourceManager.class);

    public FileResourceManager(String file, String home) {
        super(file, home);
        this.cache = new ConcurrentHashMap(1024);
    }

    @Override
    public ContentEntry get(String path) {
        if (path == null) {
            return null;
        }
        if (path.matches("[\\.\\/a-zA-Z]+\\?v\\=[0-9\\.]+")) {
            path = path.replaceFirst("\\?v\\=[0-9\\.]+", "");
        }
        File parent = new File(this.file, this.home);
        File file = new File(parent, path);
        ContentEntry contentEntry = (ContentEntry)this.cache.get(path);
        if (contentEntry != null) {
            if (contentEntry.getMemory()) {
                return contentEntry;
            }
            if (!file.exists() || !file.isFile()) {
                this.remove(path);
                return null;
            }
            if (file.lastModified() == contentEntry.getLastModified()) {
                return contentEntry;
            }
        }
        try {
            String parentRealPath = parent.getCanonicalPath();
            String realPath = file.getCanonicalPath();
            if (!realPath.startsWith(parentRealPath)) {
                return null;
            }
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        if (!file.exists() || !file.isFile()) {
            return null;
        }
        try {
            byte[] bytes = IO.read(file);
            return this.put(path, false, file.lastModified(), bytes);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

