/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.monitor.web;

import com.jxdinfo.hussar.monitor.util.StringUtil;
import java.io.IOException;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class Ajax {
    public static void success(HttpServletRequest request, HttpServletResponse response, String value) throws IOException {
        StringBuilder buffer = new StringBuilder();
        buffer.append("{\"status\":");
        buffer.append(200);
        buffer.append(",\"message\":\"success\"");
        if (value != null && value.length() > 0) {
            buffer.append(",\"value\":");
            buffer.append(value);
        }
        buffer.append("}");
        Ajax.callback(request, response, request.getParameter("callback"), buffer.toString());
    }

    public static void layJson(HttpServletRequest request, HttpServletResponse response, String value, int size) throws IOException {
        StringBuilder buffer = new StringBuilder();
        buffer.append("{\"code\":");
        buffer.append(0);
        buffer.append(",\"msg\":\"success\"");
        buffer.append(",\"count\":");
        buffer.append(size);
        if (value != null && value.length() > 0) {
            buffer.append(",\"data\":");
            buffer.append(value);
        }
        buffer.append("}");
        Ajax.callback(request, response, request.getParameter("callback"), buffer.toString());
    }

    public static void json(HttpServletRequest request, HttpServletResponse response, String value) throws IOException {
        if (value != null) {
            Ajax.write(request, response, "application/json; charset=utf-8", value);
        } else {
            Ajax.write(request, response, "application/json; charset=utf-8", "void(0)");
        }
    }

    public static void error(HttpServletRequest request, HttpServletResponse response, String message) throws IOException {
        Ajax.message(request, response, 500, message);
    }

    public static void error(HttpServletRequest request, HttpServletResponse response, int status, String message) throws IOException {
        Ajax.message(request, response, status, message);
    }

    public static void denied(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Ajax.message(request, response, 403, "Access Denied.");
    }

    private static void message(HttpServletRequest request, HttpServletResponse response, int status, String message) throws IOException {
        StringBuilder buffer = new StringBuilder();
        buffer.append("{\"status\":");
        buffer.append(status);
        buffer.append(",\"message\":\"");
        buffer.append(StringUtil.escape(message));
        buffer.append("\"}");
        Ajax.callback(request, response, request.getParameter("callback"), buffer.toString());
    }

    protected static void callback(HttpServletRequest request, HttpServletResponse response, String value) throws IOException {
        Ajax.callback(request, response, request.getParameter("callback"), value);
    }

    protected static void callback(HttpServletRequest request, HttpServletResponse response, String callback, String value) throws IOException {
        if (callback != null) {
            StringBuilder buffer = new StringBuilder();
            buffer.append(callback);
            buffer.append("(");
            if (value != null) {
                buffer.append(value);
            } else {
                buffer.append("null");
            }
            buffer.append(");");
            Ajax.write(request, response, "text/javascript; charset=utf-8", buffer.toString());
        } else if (value != null) {
            Ajax.write(request, response, "application/json; charset=utf-8", value);
        } else {
            Ajax.write(request, response, "application/json; charset=utf-8", "void(0)");
        }
    }

    private static void write(HttpServletRequest request, HttpServletResponse response, String contentType, String content) throws IOException {
        if (contentType != null) {
            response.setContentType(contentType);
        }
        byte[] buffer = content.getBytes("utf-8");
        response.setContentLength(buffer.length);
        ServletOutputStream outputStream = response.getOutputStream();
        outputStream.write(buffer, 0, buffer.length);
        outputStream.flush();
    }

    public static String stringify(List<String> list) {
        if (list == null) {
            return "null";
        }
        if (list.isEmpty()) {
            return "[]";
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append("[");
        for (String content : list) {
            buffer.append("\"");
            buffer.append(StringUtil.escape(content));
            buffer.append("\",");
        }
        buffer.deleteCharAt(buffer.length() - 1);
        buffer.append("]");
        return buffer.toString();
    }
}

