/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.monitor.web;

import com.jxdinfo.hussar.monitor.web.ActionContext;
import com.jxdinfo.hussar.monitor.web.Namespace;
import com.jxdinfo.hussar.monitor.web.Startup;
import com.jxdinfo.hussar.monitor.web.UrlPattern;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.zip.ZipInputStream;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActionDispatcher {
    private String[] packages = null;
    private ClassLoader classLoader = null;
    private ServletContext servletContext = null;
    private ActionContext actionContext;
    private static final String SERVLETCONTEXT = "servletContext";
    private static final Class<HttpServlet> SERVLET = HttpServlet.class;
    private static final Logger logger = LoggerFactory.getLogger(ActionDispatcher.class);

    public void init(ServletContext servletContext) throws ServletException {
        this.servletContext = servletContext;
        this.actionContext = new ActionContext(servletContext);
        this.scan();
        this.logo();
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        boolean b;
        String requestURI = request.getRequestURI();
        String action = this.getAction(request);
        request.setAttribute(SERVLETCONTEXT, (Object)this.getServletContext());
        request.setAttribute("requestURI", (Object)requestURI);
        request.setAttribute("contextPath", (Object)this.getContextPath(request));
        if (action == null) {
            action = "monitor";
        }
        if (!(b = this.dispatch(request, response, action))) {
            response.sendError(404);
        }
    }

    public boolean dispatch(HttpServletRequest request, HttpServletResponse response, String action) throws ServletException, IOException {
        String requestURI = this.getStrictPath(request.getRequestURI());
        request.setAttribute("ActionDispatcher$requestURI", (Object)requestURI);
        request.setAttribute(SERVLETCONTEXT, (Object)this.servletContext);
        Method method = this.actionContext.getMethod(action);
        logger.debug("{}: {}", (Object)action, (Object)method);
        if (method == null) {
            logger.debug("404 - action: {}, requestURI: {}", (Object)action, (Object)requestURI);
            return false;
        }
        Throwable throwable = null;
        try {
            HttpServlet servlet = this.actionContext.getServlet(method);
            method.invoke((Object)servlet, request, response);
        }
        catch (Throwable t) {
            throwable = t;
            logger.error(t.getMessage(), t);
        }
        if (throwable != null) {
            t = throwable.getCause();
            if (t != null) {
                throwable = t;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof ServletException) {
                throw (ServletException)throwable;
            }
            throw new ServletException(throwable);
        }
        return true;
    }

    public String getContextPath(HttpServletRequest request) {
        String contextPath = request.getContextPath();
        if (contextPath == null || contextPath.length() <= 1) {
            return "";
        }
        return contextPath;
    }

    private String getAction(HttpServletRequest request) {
        String queryString = request.getQueryString();
        if (queryString == null) {
            return null;
        }
        int i = queryString.indexOf("action=");
        if (i < 0) {
            return null;
        }
        int j = queryString.indexOf(38, i += "action=".length());
        if (j < 0) {
            return queryString.substring(i);
        }
        return queryString.substring(i, j);
    }

    public void setPackages(String[] packages) {
        this.packages = packages;
    }

    public String[] getPackages() {
        return this.packages;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader != null ? this.classLoader : Thread.currentThread().getContextClassLoader();
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void scan() throws ServletException {
        if (this.packages != null) {
            for (int i = 0; i < this.packages.length; ++i) {
                this.load(this.packages[i]);
            }
        }
    }

    private void load(String packageName) throws ServletException {
        String path = packageName.replace('.', '/');
        Enumeration<URL> urls = null;
        try {
            urls = Thread.currentThread().getContextClassLoader().getResources(path);
        }
        catch (IOException e) {
            return;
        }
        while (urls.hasMoreElements()) {
            File file;
            String urlPath = urls.nextElement().getFile();
            try {
                urlPath = URLDecoder.decode(urlPath, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new ServletException((Throwable)e);
            }
            if (urlPath.startsWith("file:")) {
                urlPath = urlPath.substring(5);
            }
            String tmp = urlPath;
            if (urlPath.indexOf(33) > 0) {
                tmp = urlPath.substring(0, urlPath.indexOf(33));
            }
            if ((file = new File(tmp)).isDirectory()) {
                this.loadFromDirectory(path, file);
                continue;
            }
            if (urlPath.split("!").length > 2) {
                urlPath = urlPath.substring(0, urlPath.lastIndexOf(33));
                this.loadResourceFromBootJar(urlPath, path);
                continue;
            }
            this.loadFromJar(path, file);
        }
    }

    private void loadFromDirectory(String parent, File location) throws ServletException {
        for (File file : location.listFiles()) {
            String packageOrClass;
            StringBuilder buffer = new StringBuilder(100);
            buffer.append(parent).append("/").append(file.getName());
            String string = packageOrClass = parent != null ? buffer.toString() : file.getName();
            if (file.isDirectory()) {
                this.loadFromDirectory(packageOrClass, file);
                continue;
            }
            if (!file.getName().endsWith(".class")) continue;
            this.add(packageOrClass);
        }
    }

    private void loadFromJar(String parent, File jarfile) throws ServletException {
        FileInputStream inputStream = null;
        ZipInputStream jarInputStream = null;
        try {
            JarEntry entry = null;
            inputStream = new FileInputStream(jarfile);
            jarInputStream = new JarInputStream(new FileInputStream(jarfile));
            while ((entry = ((JarInputStream)jarInputStream).getNextJarEntry()) != null) {
                String name = entry.getName();
                if (entry.isDirectory() || !name.startsWith(parent) || !name.endsWith(".class")) continue;
                this.add(name);
            }
        }
        catch (IOException e) {
            throw new ServletException((Throwable)e);
        }
        finally {
            if (jarInputStream != null) {
                try {
                    jarInputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (inputStream != null) {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadResourceFromBootJar(String jarUrl, String resPath) {
        if (!jarUrl.endsWith(".jar")) {
            return;
        }
        URL url = null;
        if (jarUrl.startsWith("http://")) {
            try {
                url = new URL("jar:" + jarUrl + "!/");
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        } else {
            try {
                url = new URL("jar:file:/" + jarUrl + "!/");
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
        JarFile jarFile = null;
        try {
            JarURLConnection jarURLConnection = (JarURLConnection)url.openConnection();
            jarFile = jarURLConnection.getJarFile();
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                String name = entry.getName();
                if (entry.isDirectory() || !name.startsWith(resPath) || !name.endsWith(".class")) continue;
                this.add(name);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ServletException e) {
            e.printStackTrace();
        }
        finally {
            if (jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (IOException e) {
                    e.getMessage();
                }
            }
        }
    }

    private void add(String fqn) throws ServletException {
        Method[] methods;
        String path = null;
        Class<?> type = null;
        String className = fqn.substring(0, fqn.indexOf(46)).replace('/', '.');
        try {
            type = this.getClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new ServletException((Throwable)e);
        }
        if (Modifier.isAbstract(type.getModifiers())) {
            return;
        }
        if (Modifier.isInterface(type.getModifiers())) {
            return;
        }
        if (!SERVLET.isAssignableFrom(type)) {
            return;
        }
        Startup startup = type.getAnnotation(Startup.class);
        Namespace namespace = type.getAnnotation(Namespace.class);
        if (startup != null && startup.value() >= 0) {
            this.actionContext.getServlet(className);
        }
        if (namespace != null) {
            path = namespace.value();
        }
        if (path == null) {
            path = "";
        }
        for (Method method : methods = type.getMethods()) {
            String[] values;
            UrlPattern urlPattern;
            if (!Modifier.isPublic(method.getModifiers()) || (urlPattern = method.getAnnotation(UrlPattern.class)) == null || (values = urlPattern.value()) == null || values.length < 1) continue;
            for (String url : values) {
                Method old = this.actionContext.getMethod(url);
                if (old != null) {
                    Class<?> clazz = old.getDeclaringClass();
                    if (className.equals(clazz.getName())) continue;
                    throw new ServletException("class: " + clazz.getName() + " - " + url + " already exists: " + type.getName());
                }
                this.actionContext.setAction(url, method);
                logger.info("[{}]: {}.{}", new Object[]{url, type.getName(), method.getName()});
            }
        }
    }

    public String getStrictPath(String path) {
        StringBuilder buffer = new StringBuilder();
        int length = path.length();
        for (int i = 0; i < length; ++i) {
            char c = path.charAt(i);
            if (c == '\\' || c == '/') {
                if (buffer.length() >= 1 && buffer.charAt(buffer.length() - 1) == '/') continue;
                buffer.append("/");
                continue;
            }
            buffer.append(c);
        }
        return buffer.toString();
    }

    public void destroy() {
        this.packages = null;
        this.actionContext.destroy();
        this.actionContext = null;
    }

    private void logo() {
        System.err.println("______________ ________________ ");
        System.err.println("__  ___/_  __ `__ \\  __ \\_  __ \\");
        System.err.println("_(__  )_  / / / / / /_/ /  / / /");
        System.err.println("/____/ /_/ /_/ /_/\\____//_/ /_/ ");
        System.err.println(">  \u7cfb\u7edf\u76d1\u63a7\u7ec4\u4ef6\u5df2\u7ecf\u542f\u52a8 ");
    }
}

