/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.monitor.web;

import com.jxdinfo.hussar.monitor.web.ActionDispatcher;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServlet;

public class ActionContext {
    private ServletContext servletContext;
    private Map<String, Method> actionMap;
    private ConcurrentHashMap<String, HttpServlet> servletMap;

    public ActionContext(ServletContext servletContext) {
        this.servletContext = servletContext;
        this.actionMap = new HashMap<String, Method>();
        this.servletMap = new ConcurrentHashMap();
    }

    public void setAction(String url, Method method) {
        this.actionMap.put(url, method);
    }

    public Method getMethod(String url) {
        return this.actionMap.get(url);
    }

    public HttpServlet getServlet(Method method) {
        return this.getServlet(method.getDeclaringClass().getName());
    }

    public HttpServlet getServlet(String className) {
        HttpServlet servlet = this.servletMap.get(className);
        if (servlet != null) {
            return servlet;
        }
        try {
            servlet = this.create(className);
            HttpServlet old = this.servletMap.putIfAbsent(className, servlet);
            if (old != null) {
                return old;
            }
            return servlet;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private HttpServlet create(String className) throws Exception {
        Class<?> type = this.getClass(className);
        HttpServlet servlet = (HttpServlet)type.newInstance();
        try {
            Method method = type.getMethod("setServletContext", ServletContext.class);
            method.invoke((Object)servlet, this.servletContext);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return servlet;
    }

    private Class<?> getClass(String className) throws ClassNotFoundException {
        try {
            return Thread.currentThread().getContextClassLoader().loadClass(className);
        }
        catch (Exception exception) {
            try {
                return ActionDispatcher.class.getClassLoader().loadClass(className);
            }
            catch (ClassNotFoundException classNotFoundException) {
                return Class.forName(className);
            }
        }
    }

    public void destroy() {
        ConcurrentHashMap<String, HttpServlet> map = this.servletMap;
        if (map != null && map.size() > 0) {
            for (Map.Entry entry : map.entrySet()) {
                HttpServlet httpServlet = (HttpServlet)entry.getValue();
                if (httpServlet == null) continue;
                httpServlet.destroy();
            }
        }
        this.actionMap.clear();
        this.servletMap.clear();
        this.actionMap = null;
        this.servletMap = null;
    }
}

