/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.monitor.util;

import com.jxdinfo.hussar.monitor.util.ClassUtil;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class URLParameter {
    private Map<String, String[]> map = new HashMap<String, String[]>();
    private static final Logger logger = LoggerFactory.getLogger(URLParameter.class);

    public URLParameter() {
    }

    public URLParameter(Map<String, String[]> map) {
        this.map.putAll(map);
    }

    public static URLParameter parse(String query) {
        return URLParameter.parse(query, "UTF-8");
    }

    public static URLParameter parse(String url, String encode) {
        Object values;
        char c;
        int i;
        URLParameter parameters = new URLParameter();
        if (url == null || url.length() < 1) {
            return parameters;
        }
        HashMap<String, String[]> params = new HashMap<String, String[]>();
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        String key = null;
        String query = url;
        StringBuilder name = new StringBuilder();
        StringBuilder value = new StringBuilder();
        int length = query.length();
        for (i = 0; i < length; ++i) {
            c = query.charAt(i);
            if (c != '?') continue;
            if (i + 1 < length) {
                query = query.substring(i + 1);
                break;
            }
            query = "";
            break;
        }
        length = query.length();
        block3: for (i = 0; i < length; ++i) {
            c = query.charAt(i);
            if (c == '?' || c == '&') continue;
            if (c == '#') {
                ++i;
                while (i < length) {
                    c = query.charAt(i);
                    if (c == '?' || c == '&' || c == '#') {
                        --i;
                        continue block3;
                    }
                    ++i;
                }
                continue;
            }
            if (c == '=') {
                ++i;
                while (i < length) {
                    c = query.charAt(i);
                    if (c == '?' || c == '&' || c == '#') {
                        if (c != '#') break;
                        --i;
                        break;
                    }
                    value.append(c);
                    ++i;
                }
                if (name.length() > 0) {
                    key = name.toString();
                    values = (List)map.get(key);
                    if (values == null) {
                        values = new ArrayList();
                        map.put(key, (String[])values);
                    }
                    try {
                        values.add(URLDecoder.decode(value.toString(), encode));
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        // empty catch block
                    }
                }
                name.setLength(0);
                value.setLength(0);
                continue;
            }
            name.append(c);
        }
        for (Map.Entry entry : map.entrySet()) {
            key = (String)entry.getKey();
            List list = (List)entry.getValue();
            values = new String[list.size()];
            list.toArray((T[])values);
            params.put(key, (String[])values);
        }
        parameters.addParameter(params);
        return parameters;
    }

    public static String remove(String queryString, String name) {
        StringBuilder buffer;
        block5: {
            if (queryString == null) {
                return null;
            }
            int i = 0;
            int j = 0;
            String searchment = name + "=";
            buffer = new StringBuilder();
            while ((j = queryString.indexOf(searchment, i)) > -1) {
                if (j > i) {
                    if (queryString.charAt(j - 1) == '&') {
                        buffer.append(queryString.substring(i, j - 1));
                    } else {
                        buffer.append(queryString.substring(i, j));
                    }
                }
                if ((i = queryString.indexOf(38, j + searchment.length())) >= 0) continue;
                break block5;
            }
            buffer.append(queryString.substring(i));
        }
        return buffer.toString();
    }

    public static String build(String name, String value, String encoding) throws UnsupportedEncodingException {
        return URLParameter.append(new StringBuilder(), name, value, encoding).toString();
    }

    public static String build(Map<String, ?> params, String encoding) throws UnsupportedEncodingException {
        StringBuilder buffer = new StringBuilder();
        for (Map.Entry<String, ?> entry : params.entrySet()) {
            String name = entry.getKey();
            Object value = entry.getValue();
            if (name == null || value == null) continue;
            if (value instanceof String) {
                buffer.append(name);
                buffer.append("=");
                buffer.append(URLEncoder.encode(value.toString(), encoding));
            } else if (value instanceof String[]) {
                URLParameter.append(buffer, name, (String[])value, encoding);
            } else if (value instanceof List) {
                URLParameter.append(buffer, name, (List)value, encoding);
            }
            buffer.append("&");
        }
        if (buffer.length() > 0) {
            buffer.deleteCharAt(buffer.length() - 1);
        }
        return buffer.toString();
    }

    public static StringBuilder append(StringBuilder buffer, String name, String value, String encoding) throws UnsupportedEncodingException {
        buffer.append(name);
        buffer.append("=");
        buffer.append(URLEncoder.encode(value.toString(), encoding));
        return buffer;
    }

    public static StringBuilder append(StringBuilder buffer, String name, String[] values, String encoding) throws UnsupportedEncodingException {
        for (String value : values) {
            if (value == null) continue;
            buffer.append(name);
            buffer.append("=");
            buffer.append(URLEncoder.encode(value, encoding));
        }
        return buffer;
    }

    public static StringBuilder append(StringBuilder buffer, String name, List<?> values, String encoding) throws UnsupportedEncodingException {
        for (Object value : values) {
            if (value == null) continue;
            buffer.append(name);
            buffer.append("=");
            buffer.append(URLEncoder.encode(value.toString(), encoding));
        }
        return buffer;
    }

    public void addParameter(String name, String value) {
        this.addParameter(name, new String[]{value});
    }

    public void addParameter(String name, String[] values) {
        String[] oldValues = this.map.get(name);
        if (oldValues == null) {
            this.map.put(name, values);
            return;
        }
        String[] newValues = new String[oldValues.length + values.length];
        System.arraycopy(oldValues, 0, newValues, 0, oldValues.length);
        System.arraycopy(values, 0, newValues, oldValues.length, values.length);
    }

    public void addParameter(Map<String, String[]> map) {
        this.map.putAll(map);
    }

    public void removeParameter(String name) {
        this.map.remove(name);
    }

    public String getParameter(String name) {
        String[] values = this.map.get(name);
        if (values != null && values.length > 0) {
            return values[0];
        }
        return null;
    }

    public String getParameter(String name, String defaultValue) {
        String value = this.getParameter(name);
        return value != null ? value : defaultValue;
    }

    public String[] getParameterValues(String name) {
        String[] values = this.map.get(name);
        return values != null ? values : new String[]{};
    }

    public String getString(String name) {
        String[] values = this.map.get(name);
        if (values != null && values.length > 0) {
            return values[0];
        }
        return null;
    }

    public String getString(String name, String defaultValue) {
        String value = this.getString(name);
        return value != null ? value : defaultValue;
    }

    public String getTrimString(String name) {
        String value = this.getString(name);
        return value != null ? value.trim() : "";
    }

    public Byte getByte(String name) {
        String value = this.getParameter(name);
        if (value != null) {
            try {
                return Byte.parseByte(value.trim());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    public Byte getByte(String name, byte defaultValue) {
        String value = this.getParameter(name);
        if (value != null) {
            try {
                return Byte.parseByte(value.trim());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public Short getShort(String name) {
        String value = this.getParameter(name);
        if (value != null) {
            try {
                return Short.parseShort(value.trim());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    public Short getShort(String name, short defaultValue) {
        String value = this.getParameter(name);
        if (value != null) {
            try {
                return Short.parseShort(value.trim());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public Boolean getBoolean(String name) {
        String value = this.getParameter(name);
        if (value != null) {
            boolean b = "1".equalsIgnoreCase(value = value.trim()) || "y".equalsIgnoreCase(value) || "on".equalsIgnoreCase(value) || "yes".equalsIgnoreCase(value) || "true".equalsIgnoreCase(value);
            return b;
        }
        return Boolean.FALSE;
    }

    public Boolean getBoolean(String name, boolean defaultValue) {
        String value = this.getParameter(name);
        if (value != null) {
            boolean b = "1".equalsIgnoreCase(value = value.trim()) || "y".equalsIgnoreCase(value) || "on".equalsIgnoreCase(value) || "yes".equalsIgnoreCase(value) || "true".equalsIgnoreCase(value);
            return b;
        }
        return defaultValue;
    }

    public Character getCharacter(String name) {
        String value = this.getParameter(name);
        if (value != null && value.trim().length() > 0) {
            return Character.valueOf(value.trim().charAt(0));
        }
        return null;
    }

    public Character getCharacter(String name, char defaultValue) {
        String value = this.getParameter(name);
        if (value != null && value.trim().length() > 0) {
            return Character.valueOf(value.trim().charAt(0));
        }
        return Character.valueOf(defaultValue);
    }

    public Integer getInteger(String name) {
        String value = this.getParameter(name);
        if (value != null) {
            try {
                return Integer.parseInt(value.trim());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    public Integer getInteger(String name, int defaultValue) {
        String value = this.getParameter(name);
        if (value != null) {
            try {
                return Integer.parseInt(value.trim());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public Float getFloat(String name) {
        String value = this.getParameter(name);
        if (value != null) {
            try {
                return Float.valueOf(Float.parseFloat(value.trim()));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    public Float getFloat(String name, float defaultValue) {
        String value = this.getParameter(name);
        if (value != null) {
            try {
                return Float.valueOf(Float.parseFloat(value.trim()));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return Float.valueOf(defaultValue);
    }

    public Double getDouble(String name) {
        String value = this.getParameter(name);
        if (value != null) {
            try {
                return Double.parseDouble(value.trim());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    public Double getDouble(String name, double defaultValue) {
        String value = this.getParameter(name);
        if (value != null) {
            try {
                return Double.parseDouble(value.trim());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public Long getLong(String name) {
        String value = this.getParameter(name);
        if (value != null) {
            try {
                return Long.parseLong(value.trim());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    public Long getLong(String name, long defaultValue) {
        String value = this.getParameter(name);
        if (value != null) {
            try {
                return Long.parseLong(value.trim());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public long[] getLongValues(String name) {
        String[] values = this.getParameterValues(name);
        if (values != null && values.length > 0) {
            int index = 0;
            long[] result = new long[values.length];
            for (String value : values) {
                try {
                    result[index] = Long.parseLong(value.trim());
                    ++index;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (index >= result.length) {
                return result;
            }
            long[] temp = new long[index];
            System.arraycopy(result, 0, temp, 0, index);
            return temp;
        }
        return new long[0];
    }

    public Date getDate(String name, String pattern) {
        String date = this.getParameter(name);
        if (date != null) {
            SimpleDateFormat dateFormat = new SimpleDateFormat(pattern);
            try {
                return dateFormat.parse(date.trim());
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return null;
    }

    public Timestamp getTimestamp(String name, String pattern) {
        Date date = this.getDate(name, pattern);
        if (date != null) {
            return new Timestamp(date.getTime());
        }
        return null;
    }

    public <T> T parse(T bean) {
        String name = null;
        String value = null;
        Method[] methods = bean.getClass().getMethods();
        for (int i = 0; i < methods.length; ++i) {
            name = methods[i].getName();
            if (name.length() <= 3 || !name.startsWith("set")) continue;
            try {
                Object object;
                Class<?>[] types;
                name = Character.toLowerCase(name.charAt(3)) + name.substring(4);
                value = this.getParameter(name);
                if (value == null || (types = methods[i].getParameterTypes()) == null || types.length != 1 || (object = ClassUtil.cast(value, types[0])) == null) continue;
                methods[i].invoke(bean, object);
                continue;
            }
            catch (Exception e) {
                logger.warn(e.getMessage());
            }
        }
        return bean;
    }
}

