/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.monitor.util;

import java.util.ArrayList;
import java.util.Map;

public class StringUtil {
    public static final String EMPTY = "";

    private StringUtil() {
    }

    public static boolean isBlank(String text) {
        if (text == null) {
            return true;
        }
        int length = text.length();
        if (length == 0) {
            return true;
        }
        for (int i = 0; i < length; ++i) {
            if (Character.isWhitespace(text.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean notBlank(String text) {
        return !StringUtil.isBlank(text);
    }

    public static boolean equals(String s1, String s2) {
        if (s1 != null) {
            return s1.equals(s2);
        }
        if (s2 != null) {
            return s2.equals(s1);
        }
        return true;
    }

    public static boolean contains(String content, String value) {
        if (content == null) {
            return false;
        }
        if (content.trim().equals("*")) {
            return true;
        }
        return StringUtil.contains(content.split(","), value);
    }

    public static boolean contains(String[] array, String value) {
        if (array == null) {
            return false;
        }
        for (int i = 0; i < array.length; ++i) {
            String temp;
            if (array[i] == null || !(temp = array[i].trim()).equals(value)) continue;
            return true;
        }
        return false;
    }

    public static String[] split(String source, String limit, boolean trim, boolean ignoreWhitespace) {
        int i = 0;
        int j = 0;
        String s = null;
        ArrayList<String> list = new ArrayList<String>();
        while ((j = source.indexOf(limit, i)) > -1) {
            if (j > i) {
                s = source.substring(i, j);
                if (trim) {
                    s = s.trim();
                }
                if (!ignoreWhitespace || s.length() > 0) {
                    list.add(s);
                }
            }
            i = j + limit.length();
        }
        if (i < source.length()) {
            s = source.substring(i);
            if (trim) {
                s = s.trim();
            }
            if (!ignoreWhitespace || s.length() > 0) {
                list.add(s);
            }
        }
        String[] result = new String[list.size()];
        return list.toArray(result);
    }

    public static String ltrim(String source) {
        if (source == null) {
            return EMPTY;
        }
        for (int i = 0; i < source.length(); ++i) {
            if (Character.isWhitespace(source.charAt(i))) continue;
            return source.substring(i);
        }
        return source;
    }

    public static String rtrim(String source) {
        if (source == null) {
            return EMPTY;
        }
        for (int i = source.length() - 1; i > -1; --i) {
            if (Character.isWhitespace(source.charAt(i))) continue;
            return source.substring(0, i + 1);
        }
        return source;
    }

    public static String replace(String source, String search, String replacement) {
        if (source == null) {
            return EMPTY;
        }
        if (search == null) {
            return source;
        }
        int s = 0;
        int e = 0;
        int d = search.length();
        StringBuilder buffer = new StringBuilder();
        while (true) {
            if ((e = source.indexOf(search, s)) == -1) break;
            buffer.append(source.substring(s, e));
            buffer.append(replacement);
            s = e + d;
        }
        buffer.append(source.substring(s));
        return buffer.toString();
    }

    public static String replace(String source, Map<String, String> context) {
        return StringUtil.replace(source, context, '$');
    }

    public static String replace(String source, Map<String, String> context, char prefix) {
        int length = source.length();
        StringBuilder result = new StringBuilder(4096);
        String name = null;
        String value = null;
        int j = 0;
        for (int i = 0; i < length; ++i) {
            char c = source.charAt(i);
            if (c == prefix && i < length - 1 && source.charAt(i + 1) == '{') {
                j = source.indexOf(125, i += 2);
                if (j > -1) {
                    name = source.substring(i, j).trim();
                    value = context.get(name);
                    if (value != null) {
                        result.append(value);
                    }
                    i = j;
                    continue;
                }
                i = length;
                continue;
            }
            result.append(c);
        }
        return result.toString();
    }

    public static String remove(String source, char c) {
        int length = source.length();
        StringBuilder buffer = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            char ch = source.charAt(i);
            if (ch == c) continue;
            buffer.append(ch);
        }
        return buffer.toString();
    }

    public static String hide(String text) {
        if (text == null) {
            return null;
        }
        return StringUtil.hide(text, (text.length() - 4) / 2, 4, '*');
    }

    public static String hide(String text, int offset, int length, char c) {
        if (text == null) {
            return null;
        }
        int i = offset;
        int j = offset + length;
        char[] chars = text.toCharArray();
        if (i < 0 || i >= chars.length) {
            i = 0;
        }
        if (j < 0 || j >= chars.length) {
            j = chars.length;
        }
        while (i < j) {
            chars[i] = c;
            ++i;
        }
        return new String(chars);
    }

    public static String escape(String source) {
        if (source == null) {
            return EMPTY;
        }
        StringBuilder buffer = null;
        int length = source.length();
        block9: for (int i = 0; i < length; ++i) {
            char c = source.charAt(i);
            switch (c) {
                case '\"': {
                    if (buffer == null) {
                        buffer = StringUtil.getBuffer(source, 0, i);
                    }
                    buffer.append("\\\"");
                    continue block9;
                }
                case '\r': {
                    if (buffer == null) {
                        buffer = StringUtil.getBuffer(source, 0, i);
                    }
                    buffer.append("\\r");
                    continue block9;
                }
                case '\n': {
                    if (buffer == null) {
                        buffer = StringUtil.getBuffer(source, 0, i);
                    }
                    buffer.append("\\n");
                    continue block9;
                }
                case '\t': {
                    if (buffer == null) {
                        buffer = StringUtil.getBuffer(source, 0, i);
                    }
                    buffer.append("\\t");
                    continue block9;
                }
                case '\b': {
                    if (buffer == null) {
                        buffer = StringUtil.getBuffer(source, 0, i);
                    }
                    buffer.append("\\b");
                    continue block9;
                }
                case '\f': {
                    if (buffer == null) {
                        buffer = StringUtil.getBuffer(source, 0, i);
                    }
                    buffer.append("\\f");
                    continue block9;
                }
                case '\\': {
                    if (buffer == null) {
                        buffer = StringUtil.getBuffer(source, 0, i);
                    }
                    buffer.append("\\\\");
                    continue block9;
                }
                default: {
                    if (buffer == null) continue block9;
                    buffer.append(c);
                }
            }
        }
        return buffer != null ? buffer.toString() : source;
    }

    public static StringBuilder getBuffer(String source, int offset, int length) {
        StringBuilder buffer = new StringBuilder();
        if (length > 0) {
            char[] cbuf = new char[length];
            buffer = new StringBuilder((int)((double)source.length() * 1.2));
            source.getChars(offset, length, cbuf, 0);
            buffer.append(cbuf, 0, length);
        }
        return buffer;
    }
}

