/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.monitor.util;

public enum SizeConverter {
    Arbitrary{

        @Override
        public String convert(float size) {
            while (size > 1024.0f) {
                size /= 1024.0f;
            }
            return String.format(SizeConverter.FORMAT_F, Float.valueOf(size));
        }
    }
    ,
    B{

        @Override
        public String convert(float B) {
            return SizeConverter.converter(0, B);
        }
    }
    ,
    KB{

        @Override
        public String convert(float KB) {
            return SizeConverter.converter(1, KB);
        }
    }
    ,
    MB{

        @Override
        public String convert(float MB) {
            return SizeConverter.converter(2, MB);
        }
    }
    ,
    GB{

        @Override
        public String convert(float GB) {
            return SizeConverter.converter(3, GB);
        }
    }
    ,
    TB{

        @Override
        public String convert(float TB) {
            return SizeConverter.converter(4, TB);
        }
    }
    ,
    ArbitraryTrim{

        @Override
        public String convert(float size) {
            boolean isfloat;
            while (size > 1024.0f) {
                size /= 1024.0f;
            }
            int sizeInt = (int)size;
            boolean bl = isfloat = size - (float)sizeInt > 0.0f;
            if (isfloat) {
                return String.format(SizeConverter.FORMAT_F, Float.valueOf(size));
            }
            return String.format(SizeConverter.FORMAT_D, sizeInt);
        }
    }
    ,
    BTrim{

        @Override
        public String convert(float B) {
            return SizeConverter.trimConverter(0, B);
        }
    }
    ,
    KBTrim{

        @Override
        public String convert(float KB) {
            return SizeConverter.trimConverter(1, KB);
        }
    }
    ,
    MBTrim{

        @Override
        public String convert(float MB) {
            return SizeConverter.trimConverter(2, MB);
        }
    }
    ,
    GBTrim{

        @Override
        public String convert(float GB) {
            return SizeConverter.trimConverter(3, GB);
        }
    }
    ,
    TBTrim{

        @Override
        public String convert(float TB) {
            return SizeConverter.trimConverter(4, TB);
        }
    };

    private static final String[] UNITS;
    private static final int LAST_IDX;
    private static final String FORMAT_F = "%1$-1.2f";
    private static final String FORMAT_F_UNIT = "%1$-1.2f%2$s";
    private static final String FORMAT_D = "%1$-1d";
    private static final String FORMAT_D_UNIT = "%1$-1d%2$s";

    public abstract String convert(float var1);

    private static String converter(int unit, float size) {
        int unitIdx = unit;
        while (size > 1024.0f) {
            ++unitIdx;
            size /= 1024.0f;
        }
        int idx = unitIdx < LAST_IDX ? unitIdx : LAST_IDX;
        return String.format(FORMAT_F_UNIT, Float.valueOf(size), UNITS[idx]);
    }

    private static String trimConverter(int unit, float size) {
        int idx;
        int unitIdx = unit;
        while (size > 1024.0f) {
            ++unitIdx;
            size /= 1024.0f;
        }
        int sizeInt = (int)size;
        boolean isfloat = size - (float)sizeInt > 0.0f;
        int n = idx = unitIdx < LAST_IDX ? unitIdx : LAST_IDX;
        if (isfloat) {
            return String.format(FORMAT_F_UNIT, Float.valueOf(size), UNITS[idx]);
        }
        return String.format(FORMAT_D_UNIT, sizeInt, UNITS[idx]);
    }

    public static String convertBytes(float B, boolean trim) {
        return trim ? SizeConverter.trimConvert(0, B, true) : SizeConverter.convert(0, B, true);
    }

    public static String convertKB(float KB, boolean trim) {
        return trim ? SizeConverter.trimConvert(1, KB, true) : SizeConverter.convert(1, KB, true);
    }

    public static String convertMB(float MB, boolean trim) {
        return trim ? SizeConverter.trimConvert(2, MB, true) : SizeConverter.convert(2, MB, true);
    }

    private static String convert(int unit, float size, boolean withUnit) {
        int unitIdx = unit;
        while (size > 1024.0f) {
            ++unitIdx;
            size /= 1024.0f;
        }
        if (withUnit) {
            int idx = unitIdx < LAST_IDX ? unitIdx : LAST_IDX;
            return String.format(FORMAT_F_UNIT, Float.valueOf(size), UNITS[idx]);
        }
        return String.format(FORMAT_F, Float.valueOf(size));
    }

    private static String trimConvert(int unit, float size, boolean withUnit) {
        boolean isfloat;
        int unitIdx = unit;
        while (size > 1024.0f) {
            ++unitIdx;
            size /= 1024.0f;
        }
        int sizeInt = (int)size;
        boolean bl = isfloat = size - (float)sizeInt > 0.0f;
        if (withUnit) {
            int idx;
            int n = idx = unitIdx < LAST_IDX ? unitIdx : LAST_IDX;
            if (isfloat) {
                return String.format(FORMAT_F_UNIT, Float.valueOf(size), UNITS[idx]);
            }
            return String.format(FORMAT_D_UNIT, sizeInt, UNITS[idx]);
        }
        if (isfloat) {
            return String.format(FORMAT_F, Float.valueOf(size));
        }
        return String.format(FORMAT_D, sizeInt);
    }

    static {
        UNITS = new String[]{"B", "KB", "MB", "GB", "TB", "PB", "**"};
        LAST_IDX = UNITS.length - 1;
    }
}

