/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.monitor.util;

import com.jxdinfo.hussar.monitor.entity.MonitorEntity;
import com.jxdinfo.hussar.monitor.sigar.SigarFactory;
import com.jxdinfo.hussar.monitor.util.ComputerInfo;
import com.jxdinfo.hussar.monitor.util.SizeConverter;
import java.math.BigDecimal;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.hyperic.sigar.CpuInfo;
import org.hyperic.sigar.CpuPerc;
import org.hyperic.sigar.FileSystem;
import org.hyperic.sigar.FileSystemUsage;
import org.hyperic.sigar.Mem;
import org.hyperic.sigar.OperatingSystem;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.Swap;

public class SigarUtils {
    private static final String SIGAR_PATH = "org.hyperic.sigar.path";
    private static Sigar sigar;

    private static Sigar getInstance() {
        if (null == sigar) {
            sigar = SigarFactory.getInstance();
        }
        return sigar;
    }

    public static synchronized MonitorEntity getJvmMemoryUsageRate() {
        MonitorEntity entity = new MonitorEntity();
        Runtime run = Runtime.getRuntime();
        long totalMemory = run.totalMemory();
        long freeMemory = run.freeMemory();
        String memoryUsageRate = SigarUtils.format((double)(totalMemory - freeMemory) / (double)totalMemory);
        entity = new MonitorEntity("jvmMemoryUsageRate", memoryUsageRate, "JVM\u5185\u5b58\n\u4f7f\u7528\u7387");
        return entity;
    }

    public static synchronized List<MonitorEntity> getJvmInfos() throws UnknownHostException {
        ArrayList<MonitorEntity> jvmInfoList = new ArrayList<MonitorEntity>();
        Runtime r = Runtime.getRuntime();
        Properties sysProps = System.getProperties();
        InetAddress addr = InetAddress.getLocalHost();
        String mac = ComputerInfo.getMacAddress();
        Map<String, String> envInfoMap = System.getenv();
        String userName = envInfoMap.get("USERNAME");
        String computerName = envInfoMap.get("COMPUTERNAME");
        String userDomain = envInfoMap.get("USERDOMAIN");
        jvmInfoList.add(new MonitorEntity("userName", userName, "\u83b7\u53d6\u7528\u6237\u540d"));
        jvmInfoList.add(new MonitorEntity("computerName", computerName, "\u83b7\u53d6\u8ba1\u7b97\u673a\u540d"));
        jvmInfoList.add(new MonitorEntity("userDomain", userDomain, "\u83b7\u53d6\u8ba1\u7b97\u673a\u57df\u540d"));
        jvmInfoList.add(new MonitorEntity("hostAddress", addr.getHostAddress(), "\u83b7\u53d6Ip"));
        jvmInfoList.add(new MonitorEntity("hostName", addr.getHostName(), "\u83b7\u53d6\u4e3b\u673a\u540d\u79f0"));
        jvmInfoList.add(new MonitorEntity("hostMac", mac, "\u83b7\u53d6\u4e3b\u673aMac"));
        jvmInfoList.add(new MonitorEntity("JvmTotleMemory", String.valueOf(r.totalMemory()), "JVM\u603b\u5185\u5b58"));
        jvmInfoList.add(new MonitorEntity("JvmFreeMemory", String.valueOf(r.freeMemory()), "JVM\u5269\u4f59\u5185\u5b58"));
        jvmInfoList.add(new MonitorEntity("JvmProcessors", String.valueOf(r.availableProcessors()), "JVM\u5904\u7406\u5668\u4e2a\u6570"));
        jvmInfoList.add(new MonitorEntity("JavaVersion", sysProps.getProperty("java.version"), "Java\u7684\u8fd0\u884c\u73af\u5883\u7248\u672c"));
        jvmInfoList.add(new MonitorEntity("JavaVendor", sysProps.getProperty("java.vendor"), "Java\u7684\u8fd0\u884c\u73af\u5883\u4f9b\u5e94\u5546"));
        jvmInfoList.add(new MonitorEntity("JavaVendorURL", sysProps.getProperty("java.vendor.url"), "Java\u4f9b\u5e94\u5546\u7684URL"));
        jvmInfoList.add(new MonitorEntity("JavaHome", sysProps.getProperty("java.home"), "Java\u7684\u5b89\u88c5\u8def\u5f84"));
        jvmInfoList.add(new MonitorEntity("JavaSpecificationVersion", sysProps.getProperty("java.vm.specification.version"), "Java\u7684\u865a\u62df\u673a\u89c4\u8303\u7248\u672c"));
        jvmInfoList.add(new MonitorEntity("JavaSpecificationVendor", sysProps.getProperty("java.vm.specification.vendor"), "Java\u7684\u865a\u62df\u673a\u89c4\u8303\u4f9b\u5e94\u5546"));
        jvmInfoList.add(new MonitorEntity("JavaSpecificationName", sysProps.getProperty("java.vm.specification.name"), "Java\u7684\u865a\u62df\u673a\u89c4\u8303\u540d\u79f0"));
        jvmInfoList.add(new MonitorEntity("JavaVMVersion", sysProps.getProperty("java.vm.version"), "Java\u7684\u865a\u62df\u673a\u5b9e\u73b0\u7248\u672c"));
        jvmInfoList.add(new MonitorEntity("JavaVMVendor", sysProps.getProperty("java.vm.vendor"), "Java\u7684\u865a\u62df\u673a\u5b9e\u73b0\u4f9b\u5e94\u5546"));
        jvmInfoList.add(new MonitorEntity("JavaVMName", sysProps.getProperty("java.vm.name"), "Java\u7684\u865a\u62df\u673a\u5b9e\u73b0\u540d\u79f0"));
        jvmInfoList.add(new MonitorEntity("JavaRunTimeVersion", sysProps.getProperty("java.specification.version"), "Java\u8fd0\u884c\u65f6\u73af\u5883\u89c4\u8303\u7248\u672c"));
        jvmInfoList.add(new MonitorEntity("JavaRunTimeVendor", sysProps.getProperty("java.specification.vendor"), "Java\u8fd0\u884c\u65f6\u73af\u5883\u89c4\u8303\u4f9b\u5e94\u5546"));
        jvmInfoList.add(new MonitorEntity("JavaRunTimeName", sysProps.getProperty("java.specification.name"), "Java\u7684\u865a\u62df\u673a\u89c4\u8303\u540d\u79f0"));
        jvmInfoList.add(new MonitorEntity("JavaClassVersion", sysProps.getProperty("java.class.version"), "Java\u7684\u7c7b\u683c\u5f0f\u7248\u672c\u53f7"));
        jvmInfoList.add(new MonitorEntity("JavaClassPath", sysProps.getProperty("java.class.path"), "Java\u7684\u7c7b\u8def\u5f84"));
        jvmInfoList.add(new MonitorEntity("JavaLibraryPath", sysProps.getProperty("java.library.path"), "\u52a0\u8f7d\u5e93\u65f6\u641c\u7d22\u7684\u8def\u5f84\u5217\u8868"));
        jvmInfoList.add(new MonitorEntity("JavaLibraryTmpPath", sysProps.getProperty("java.io.tmpdir"), "\u9ed8\u8ba4\u7684\u4e34\u65f6\u6587\u4ef6\u8def\u5f84"));
        jvmInfoList.add(new MonitorEntity("JavaLibraryExtPath", sysProps.getProperty("java.ext.dirs"), "\u4e00\u4e2a\u6216\u591a\u4e2a\u6269\u5c55\u76ee\u5f55\u7684\u8def\u5f84"));
        jvmInfoList.add(new MonitorEntity("OsName", sysProps.getProperty("os.name"), "\u64cd\u4f5c\u7cfb\u7edf\u7684\u540d\u79f0"));
        jvmInfoList.add(new MonitorEntity("OsArch", sysProps.getProperty("os.arch"), "\u64cd\u4f5c\u7cfb\u7edf\u7684\u6784\u67b6"));
        jvmInfoList.add(new MonitorEntity("OsVersion", sysProps.getProperty("os.version"), "\u64cd\u4f5c\u7cfb\u7edf\u7684\u7248\u672c"));
        jvmInfoList.add(new MonitorEntity("FileSeparator", sysProps.getProperty("file.separator"), "\u6587\u4ef6\u5206\u9694\u7b26"));
        jvmInfoList.add(new MonitorEntity("PathSeparator", sysProps.getProperty("path.separator"), "\u8def\u5f84\u5206\u9694\u7b26"));
        jvmInfoList.add(new MonitorEntity("LineSeparator", sysProps.getProperty("line.separator"), "\u884c\u5206\u9694\u7b26"));
        jvmInfoList.add(new MonitorEntity("UserName", sysProps.getProperty("user.name"), "\u7528\u6237\u7684\u8d26\u6237\u540d\u79f0"));
        jvmInfoList.add(new MonitorEntity("UserHome", sysProps.getProperty("user.home"), "\u7528\u6237\u7684\u4e3b\u76ee\u5f55"));
        jvmInfoList.add(new MonitorEntity("UserCurrentDir", sysProps.getProperty("user.dir"), "\u7528\u6237\u7684\u5f53\u524d\u5de5\u4f5c\u76ee\u5f55"));
        return jvmInfoList;
    }

    public static synchronized MonitorEntity getCpuInfo() {
        MonitorEntity entity = new MonitorEntity();
        try {
            CpuPerc cpu = SigarUtils.getInstance().getCpuPerc();
            double combin = cpu.getCombined();
            while (Double.isNaN(combin)) {
                cpu = SigarUtils.getInstance().getCpuPerc();
                combin = cpu.getCombined();
            }
            String combined = CpuPerc.format((double)combin);
            entity = new MonitorEntity("combined", combined, "CPU\n\u4f7f\u7528\u7387");
        }
        catch (SigarException e) {
            e.printStackTrace();
        }
        return entity;
    }

    public static synchronized MonitorEntity getCpuInfos() {
        MonitorEntity entity = null;
        try {
            CpuInfo[] cpuInfos = SigarUtils.getInstance().getCpuInfoList();
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < cpuInfos.length; ++i) {
                CpuInfo cpuInfo = cpuInfos[i];
                sb.append("\u4f9b\u5e94\u5546\uff1a").append(cpuInfo.getVendor()).append(" \uff0c ");
                sb.append("\u7c7b\u522b\uff1a").append(cpuInfo.getModel()).append(" \uff0c ");
                sb.append("\u9891\u7387\uff1a").append(cpuInfo.getMhz()).append(";");
            }
            entity = new MonitorEntity("CPU", sb.toString(), "\u5904\u7406\u5668");
        }
        catch (SigarException e) {
            e.printStackTrace();
        }
        return entity;
    }

    public static synchronized MonitorEntity getMemoryUsageRate() {
        MonitorEntity entity = new MonitorEntity();
        try {
            Mem mem = SigarUtils.getInstance().getMem();
            long memUsed = mem.getUsed();
            long memTotal = mem.getTotal();
            String memoryUsageRate = SigarUtils.format((double)memUsed / (double)memTotal);
            entity = new MonitorEntity("memoryUsageRate", memoryUsageRate, "\u5185\u5b58\n\u4f7f\u7528\u7387");
        }
        catch (SigarException e) {
            e.printStackTrace();
        }
        return entity;
    }

    public static synchronized MonitorEntity getJvmMemoryInfos() {
        MonitorEntity entity = new MonitorEntity();
        Runtime run = Runtime.getRuntime();
        long totalMemory = run.totalMemory();
        long freeMemory = run.freeMemory();
        long max = run.maxMemory();
        StringBuilder sb = new StringBuilder();
        sb.append("\u6700\u5927\uff1a").append(SizeConverter.convertBytes(max, false)).append(" \uff0c ");
        sb.append("\u5206\u914d\uff1a").append(SizeConverter.convertBytes(totalMemory, false));
        sb.append("(\u7a7a\u95f2\uff1a").append(SizeConverter.convertBytes(freeMemory, false)).append(" \uff0c ");
        sb.append("\u5df2\u7528\uff1a").append(SizeConverter.convertBytes(totalMemory - freeMemory, false)).append(") \uff0c ");
        sb.append("\u53ef\u7528").append(SizeConverter.convertBytes(freeMemory, false)).append(";");
        entity = new MonitorEntity("JVM Memory", sb.toString(), "JVM\u5185\u5b58 ");
        return entity;
    }

    public static synchronized MonitorEntity getMemoryInfos() {
        MonitorEntity memoryInfo = new MonitorEntity();
        try {
            Mem mem = SigarUtils.getInstance().getMem();
            StringBuilder sb = new StringBuilder();
            sb.append("\u603b\u91cf\uff1a").append(SizeConverter.convertBytes(mem.getTotal(), false)).append(" \uff0c ");
            sb.append("\u7a7a\u95f2\uff1a").append(SizeConverter.convertBytes(mem.getFree(), false)).append(" \uff0c ");
            sb.append("\u5df2\u7528\uff1a").append(SizeConverter.convertBytes(mem.getUsed(), false)).append(";");
            Swap swap = SigarUtils.getInstance().getSwap();
            sb.append("\u4ea4\u6362\u533a\u603b\u91cf\uff1a").append(SizeConverter.convertBytes(swap.getTotal(), false)).append(" \uff0c");
            sb.append("\u4ea4\u6362\u533a\u5df2\u7528\uff1a").append(SizeConverter.convertBytes(swap.getUsed(), false)).append(" \uff0c");
            sb.append("\u4ea4\u6362\u533a\u5269\u4f59 \uff1a").append(SizeConverter.convertBytes(swap.getFree(), false)).append(";");
            memoryInfo = new MonitorEntity("Memory", sb.toString(), "\u7269\u7406\u5185\u5b58 ");
        }
        catch (SigarException e) {
            e.printStackTrace();
        }
        return memoryInfo;
    }

    public static synchronized MonitorEntity getDiskInfos() {
        MonitorEntity diskInfo = new MonitorEntity();
        StringBuilder sb = new StringBuilder();
        try {
            FileSystem[] fslist = SigarUtils.getInstance().getFileSystemList();
            block10: for (int i = 0; i < fslist.length; ++i) {
                FileSystem fs = fslist[i];
                FileSystemUsage usage = null;
                switch (fs.getType()) {
                    case 0: {
                        continue block10;
                    }
                    case 1: {
                        continue block10;
                    }
                    case 2: {
                        usage = SigarUtils.getInstance().getFileSystemUsage(fs.getDirName());
                        sb.append("\u5206\u533a\uff1a").append(fs.getDirName()).append(" (\u7cfb\u7edf\u683c\u5f0f\uff1a").append(fs.getSysTypeName()).append(") \uff0c (\u5bb9\u91cf");
                        sb.append(SizeConverter.convertKB(usage.getTotal(), false)).append(" \uff0c  \u5df2\u7528\uff1a");
                        sb.append(SizeConverter.convertKB(usage.getUsed(), false)).append(" \uff0c  \u53ef\u7528\uff1a");
                        sb.append(SizeConverter.convertKB(usage.getAvail(), false)).append(" \uff0c \u5df2\u7528(%)\uff1a");
                        sb.append(new BigDecimal(usage.getUsePercent() * 100.0).setScale(2, 4).doubleValue() + "%").append(");");
                        continue block10;
                    }
                    case 3: {
                        continue block10;
                    }
                    case 4: {
                        continue block10;
                    }
                    case 5: {
                        continue block10;
                    }
                }
            }
        }
        catch (SigarException e) {
            e.printStackTrace();
        }
        diskInfo = new MonitorEntity("Disk", sb.toString(), "\u78c1\u76d8\u7a7a\u95f4");
        return diskInfo;
    }

    public static synchronized MonitorEntity getSystemInfo() {
        MonitorEntity entity = null;
        if (System.getProperty(SIGAR_PATH) == null) {
            SigarUtils.getInstance();
        }
        OperatingSystem os = OperatingSystem.getInstance();
        StringBuilder sb = new StringBuilder();
        sb.append("\u540d\u79f0\uff1a").append(os.getVendorName()).append(" \uff0c ");
        sb.append("\u67b6\u6784\uff1a").append(os.getArch()).append(" \uff0c ");
        sb.append("\u7248\u672c\uff1a").append(os.getVersion()).append(";");
        sb.append("Mac\uff1a").append(ComputerInfo.getMacAddress()).append(" \uff0c ");
        sb.append("IP\uff1a").append(ComputerInfo.getIpAddr()).append(";");
        entity = new MonitorEntity("OS", sb.toString(), "\u64cd\u4f5c\u7cfb\u7edf ");
        return entity;
    }

    public static synchronized MonitorEntity getDiskUsageRate() {
        long total = 0L;
        long used = 0L;
        String diskUsageRate = null;
        try {
            FileSystem[] fslist = SigarUtils.getInstance().getFileSystemList();
            block10: for (int i = 0; i < fslist.length; ++i) {
                FileSystem fs = fslist[i];
                FileSystemUsage usage = null;
                switch (fs.getType()) {
                    case 0: {
                        continue block10;
                    }
                    case 1: {
                        continue block10;
                    }
                    case 2: {
                        usage = SigarUtils.getInstance().getFileSystemUsage(fs.getDirName());
                        total += usage.getTotal();
                        used += usage.getUsed();
                        continue block10;
                    }
                    case 3: {
                        continue block10;
                    }
                    case 4: {
                        continue block10;
                    }
                    case 5: {
                        continue block10;
                    }
                }
            }
        }
        catch (SigarException e) {
            e.printStackTrace();
        }
        if (total != 0L) {
            diskUsageRate = SigarUtils.format((double)used / (double)total);
        }
        MonitorEntity entity = new MonitorEntity("diskUsageRate", diskUsageRate, "\u78c1\u76d8\n\u4f7f\u7528\u7387");
        return entity;
    }

    public static String format(double val) {
        String p = String.valueOf(val * 100.0);
        int ix = p.indexOf(".") + 1;
        String percent = p.substring(0, ix) + p.substring(ix, ix + 1);
        return percent + "%";
    }
}

