/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.monitor.util;

import java.util.ArrayList;
import java.util.List;

public class Path {
    public static String getExtension(String path) {
        if (path != null && path.length() > 0) {
            int i;
            int c = 48;
            for (i = path.length() - 1; i > -1 && (c = (int)path.charAt(i)) != 46 && c != 47 && c != 92 && c != 58; --i) {
            }
            if (c == 46) {
                return path.substring(i + 1);
            }
        }
        return "";
    }

    public static boolean contains(String parent, String child) {
        String full = Path.join(parent, child);
        String temp = Path.join(parent, "");
        return full.startsWith(temp);
    }

    public static String join(String parent, String child) {
        List<String> parts = Path.split(parent + "/" + child);
        return Path.join(parts);
    }

    public static String getParent(String path) {
        List<String> parts = Path.split(path);
        if (parts.size() > 0) {
            if (parts.size() == 1) {
                String root = parts.get(0);
                if (root.equals("/") || root.endsWith(":")) {
                    return root;
                }
                return "";
            }
            parts.remove(parts.size() - 1);
            return Path.join(parts);
        }
        return "";
    }

    public static String getStrictPath(String path) {
        StringBuilder buffer = new StringBuilder();
        int length = path.length();
        for (int i = 0; i < length; ++i) {
            char c = path.charAt(i);
            if (c == '\\' || c == '/') {
                if (buffer.length() >= 1 && buffer.charAt(buffer.length() - 1) == '/') continue;
                buffer.append("/");
                continue;
            }
            buffer.append(c);
        }
        return buffer.toString().trim();
    }

    public static String getRelativePath(String parent, String child) {
        String temp;
        String full = Path.join(child, "");
        if (full.startsWith(temp = Path.join(parent, ""))) {
            return full.substring(temp.length());
        }
        return null;
    }

    public static List<String> split(String path) {
        String root = null;
        StringBuilder buffer = new StringBuilder();
        ArrayList<String> stack = new ArrayList<String>();
        int length = path.length();
        for (int i = 0; i < length; ++i) {
            char c = path.charAt(i);
            if (c == '\\' || c == '/') {
                if (root == null) {
                    root = buffer.toString();
                }
                Path.push(stack, buffer.toString());
                buffer.setLength(0);
                continue;
            }
            buffer.append(c);
        }
        Path.push(stack, buffer.toString());
        if (root != null && !root.endsWith(":") && root.length() < 1) {
            stack.add(0, "/");
        }
        return stack;
    }

    public static String join(List<String> paths) {
        StringBuilder buffer = new StringBuilder();
        if (paths.size() > 0) {
            for (String part : paths) {
                buffer.append(part);
                if (part.equals("/")) continue;
                buffer.append("/");
            }
        }
        if (buffer.length() > 1) {
            buffer.deleteCharAt(buffer.length() - 1);
        }
        return buffer.toString();
    }

    private static void push(List<String> stack, String name) {
        if (name.length() < 1 || name.equals(".")) {
            return;
        }
        if (name.equals("..")) {
            String parent;
            if (stack.size() > 0 && !(parent = stack.get(stack.size() - 1)).endsWith(":")) {
                stack.remove(stack.size() - 1);
            }
        } else {
            stack.add(name);
        }
    }
}

