/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.monitor.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.jxdinfo.hussar.monitor.cache.Cache;
import com.jxdinfo.hussar.monitor.cache.CacheFactory;
import com.jxdinfo.hussar.monitor.entity.MonitorEntity;
import com.jxdinfo.hussar.monitor.util.SigarUtils;
import java.util.ArrayList;

public class MonitorUtil {
    private static MonitorUtil monitor = null;

    public static MonitorUtil getInstance() {
        if (monitor == null) {
            monitor = new MonitorUtil();
        }
        return monitor;
    }

    public JSONArray getChartList() {
        Cache cache = CacheFactory.getInstance();
        JSONArray chartListJsonArray = (JSONArray)cache.get("chartList");
        if (chartListJsonArray == null) {
            ArrayList<MonitorEntity> sigarInfo = new ArrayList<MonitorEntity>();
            MonitorEntity CpuCombined = SigarUtils.getCpuInfo();
            MonitorEntity memoryUsageRate = SigarUtils.getMemoryUsageRate();
            MonitorEntity jvmMemoryUsageRate = SigarUtils.getJvmMemoryUsageRate();
            MonitorEntity diskUsageRate = SigarUtils.getDiskUsageRate();
            sigarInfo.add(CpuCombined);
            sigarInfo.add(memoryUsageRate);
            sigarInfo.add(jvmMemoryUsageRate);
            sigarInfo.add(diskUsageRate);
            chartListJsonArray = JSON.parseArray((String)JSON.toJSONString(sigarInfo).replaceAll("%", ""));
            cache.put("chartList", 5, chartListJsonArray);
        }
        return chartListJsonArray;
    }

    public JSONArray getDetectorInfo() {
        Cache cache = CacheFactory.getInstance();
        JSONArray detectorInfo = (JSONArray)cache.get("detectorInfo");
        if (detectorInfo == null) {
            ArrayList<MonitorEntity> sigarInfo = new ArrayList<MonitorEntity>();
            new ArrayList();
            MonitorEntity systemInfo = SigarUtils.getSystemInfo();
            MonitorEntity cpuInfo = SigarUtils.getCpuInfos();
            MonitorEntity memory = SigarUtils.getMemoryInfos();
            MonitorEntity jvmMemory = SigarUtils.getJvmMemoryInfos();
            MonitorEntity disk = SigarUtils.getDiskInfos();
            sigarInfo.add(systemInfo);
            sigarInfo.add(cpuInfo);
            sigarInfo.add(memory);
            sigarInfo.add(jvmMemory);
            sigarInfo.add(disk);
            detectorInfo = JSON.parseArray((String)JSON.toJSONString(sigarInfo));
            cache.put("detectorInfo", 27, detectorInfo);
        }
        return detectorInfo;
    }

    public JSONArray getServerList() {
        Cache cache = CacheFactory.getInstance();
        JSONArray serverJsonArray = (JSONArray)cache.get("serverList");
        if (serverJsonArray == null) {
            ArrayList<MonitorEntity> serverList = new ArrayList<MonitorEntity>();
            String[] hosts = (String[])CacheFactory.getInstance().get("hosts");
            String local = (String)CacheFactory.getInstance().get("local");
            for (int i = 0; i < hosts.length; ++i) {
                String host = hosts[i];
                if (host.contains(":")) {
                    String[] sp = host.split(":");
                    if (sp.length != 2) continue;
                    if (local.equals(host)) {
                        serverList.add(new MonitorEntity(host, sp[0] + "/" + sp[1], "true"));
                        continue;
                    }
                    serverList.add(new MonitorEntity(host, sp[0] + "/" + sp[1], "false"));
                    continue;
                }
                if (local.equals(host)) {
                    serverList.add(new MonitorEntity(host, host, "true"));
                    continue;
                }
                serverList.add(new MonitorEntity(host, host, "false"));
            }
            serverJsonArray = JSON.parseArray((String)JSON.toJSONString(serverList));
            cache.put("serverList", -1, serverJsonArray);
        }
        return serverJsonArray;
    }
}

