/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.monitor.util;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;

public class IO {
    private IO() {
    }

    public static File getFile(URL url) throws IOException {
        if (url != null && "file".equals(url.getProtocol())) {
            String path = URLDecoder.decode(url.getFile(), "utf-8");
            return new File(path);
        }
        return null;
    }

    public static byte[] read(File file) throws IOException {
        byte[] byArray;
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(file);
            byArray = IO.read(inputStream, 8192);
        }
        catch (Throwable throwable) {
            IO.close(inputStream);
            throw throwable;
        }
        IO.close(inputStream);
        return byArray;
    }

    public static byte[] read(InputStream inputStream, int bufferSize) throws IOException {
        int length = 0;
        byte[] buffer = new byte[bufferSize];
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        while ((length = inputStream.read(buffer, 0, 2048)) > 0) {
            bos.write(buffer, 0, length);
        }
        return bos.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> list(File file, String charset) throws IOException {
        List<String> list;
        FileInputStream inputStream = null;
        InputStreamReader inputStreamReader = null;
        try {
            inputStream = new FileInputStream(file);
            inputStreamReader = charset == null || charset.length() < 1 ? new InputStreamReader(inputStream) : new InputStreamReader((InputStream)inputStream, charset);
            list = IO.list(inputStreamReader);
        }
        catch (Throwable throwable) {
            IO.close(inputStreamReader);
            IO.close(inputStream);
            throw throwable;
        }
        IO.close(inputStreamReader);
        IO.close(inputStream);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> list(Reader reader) throws IOException {
        BufferedReader buffer = null;
        ArrayList<String> list = new ArrayList<String>();
        buffer = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
        try {
            String line = null;
            while ((line = buffer.readLine()) != null) {
                list.add(line);
            }
            ArrayList<String> arrayList = list;
            return arrayList;
        }
        finally {
            if (reader == null) {
                buffer.close();
            }
        }
    }

    public static byte[] getBytes(InputStream inputStream) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        IO.copy(inputStream, bos, 4096);
        return bos.toByteArray();
    }

    public static void touch(File file) throws IOException {
        FileOutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(file);
        }
        catch (Throwable throwable) {
            IO.close(outputStream);
            throw throwable;
        }
        IO.close(outputStream);
    }

    public static void write(File file, byte[] buffer) throws IOException {
        FileOutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(file);
            if (buffer != null && buffer.length > 0) {
                ((OutputStream)outputStream).write(buffer);
                outputStream.flush();
            }
        }
        catch (Throwable throwable) {
            IO.close(outputStream);
            throw throwable;
        }
        IO.close(outputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(File source, File target, long offset, long lastModified) throws IOException {
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(source);
            IO.write(inputStream, target, offset);
            if (lastModified > 0L) {
                target.setLastModified(lastModified);
            }
        }
        finally {
            if (inputStream != null) {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(InputStream inputStream, File file, long offset) throws IOException {
        RandomAccessFile raf = null;
        try {
            raf = new RandomAccessFile(file, "rw");
            raf.setLength(offset);
            if (offset > 0L) {
                raf.seek(offset);
            }
            IO.copy(inputStream, raf, 8192);
        }
        finally {
            if (raf != null) {
                try {
                    raf.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static void copy(InputStream inputStream, RandomAccessFile raf, int bufferSize) throws IOException {
        int length = 0;
        byte[] buffer = new byte[bufferSize];
        while ((length = inputStream.read(buffer, 0, bufferSize)) > 0) {
            raf.write(buffer, 0, length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(File source, File target, boolean lastModified) throws IOException {
        block5: {
            File[] files;
            block4: {
                if (!source.isFile()) break block4;
                FileInputStream inputStream = null;
                FileOutputStream outputStream = null;
                try {
                    int bufferSize = 0;
                    long length = source.length();
                    bufferSize = length < 4096L ? 2048 : 8192;
                    inputStream = new FileInputStream(source);
                    outputStream = new FileOutputStream(target);
                    IO.copy((InputStream)inputStream, outputStream, bufferSize);
                }
                catch (Throwable throwable) {
                    IO.close(inputStream);
                    IO.close(outputStream);
                    throw throwable;
                }
                IO.close(inputStream);
                IO.close(outputStream);
                if (!lastModified) break block5;
                target.setLastModified(source.lastModified());
                break block5;
            }
            if (!target.exists()) {
                target.mkdirs();
            }
            for (File file : files = source.listFiles()) {
                IO.copy(file, new File(target, file.getName()), lastModified);
            }
        }
    }

    public static void copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        IO.copy(inputStream, outputStream, 4096);
    }

    public static void copy(InputStream inputStream, OutputStream outputStream, int bufferSize) throws IOException {
        int length = 0;
        byte[] buffer = new byte[bufferSize];
        while ((length = inputStream.read(buffer, 0, bufferSize)) > -1) {
            outputStream.write(buffer, 0, length);
        }
        outputStream.flush();
    }

    public static void copy(InputStream inputStream, OutputStream outputStream, int bufferSize, long size) throws IOException {
        if (size > 0L) {
            int readBytes = 0;
            int length = Math.min(bufferSize, (int)size);
            byte[] buffer = new byte[length];
            for (long count = size; count > 0L && (readBytes = count > (long)length ? inputStream.read(buffer, 0, length) : inputStream.read(buffer, 0, (int)count)) > 0; count -= (long)readBytes) {
                outputStream.write(buffer, 0, readBytes);
            }
            outputStream.flush();
        }
    }

    public static void copy(Reader reader, Writer writer) throws IOException {
        IO.copy(reader, writer, 2048);
    }

    public static void copy(Reader reader, Writer writer, int bufferSize) throws IOException {
        int length = 0;
        char[] buffer = new char[bufferSize];
        while ((length = reader.read(buffer, 0, bufferSize)) > -1) {
            writer.write(buffer, 0, length);
        }
        writer.flush();
    }

    public static void delete(File file) {
        if (file.isDirectory()) {
            File[] files;
            for (File f : files = file.listFiles()) {
                if (f.isDirectory()) {
                    IO.delete(f);
                    continue;
                }
                f.delete();
            }
        }
        file.delete();
    }

    public static void toucn(File file) throws IOException {
        FileOutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(file);
        }
        catch (Throwable throwable) {
            IO.close(outputStream);
            throw throwable;
        }
        IO.close(outputStream);
    }

    public static String getFileName(String path) {
        if (path != null && path.length() > 0) {
            char c;
            int i;
            for (i = path.length() - 1; i > -1 && (c = path.charAt(i)) != '/' && c != '\\' && c != ':'; --i) {
            }
            return path.substring(i + 1);
        }
        return "";
    }

    public static String getExtension(String path) {
        int i = path.lastIndexOf(".");
        if (i > -1) {
            return path.substring(i);
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(File file, String charset) throws IOException {
        byte[] buffer;
        FileInputStream inputStream;
        block3: {
            String string;
            inputStream = null;
            try {
                inputStream = new FileInputStream(file);
                int length = (int)file.length();
                buffer = new byte[length];
                ((InputStream)inputStream).read(buffer, 0, length);
                if (charset == null) break block3;
                string = new String(buffer, 0, buffer.length, charset);
            }
            catch (Throwable throwable) {
                IO.close(inputStream);
                throw throwable;
            }
            IO.close(inputStream);
            return string;
        }
        String string = new String(buffer, 0, buffer.length);
        IO.close(inputStream);
        return string;
    }

    public static String toString(InputStream inputStream) throws IOException {
        return IO.toString(new InputStreamReader(inputStream));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(InputStream inputStream, String charset) throws IOException {
        String string;
        InputStreamReader reader = null;
        try {
            reader = new InputStreamReader(inputStream, charset);
            string = IO.toString(reader);
        }
        catch (Throwable throwable) {
            IO.close(reader);
            throw throwable;
        }
        IO.close(reader);
        return string;
    }

    public static String toString(Reader reader) throws IOException {
        return IO.toString(reader, 2048);
    }

    public static String toString(Reader reader, int bufferSize) throws IOException {
        int length = 0;
        char[] buffer = new char[Math.max(bufferSize, 2048)];
        StringWriter out = new StringWriter();
        while ((length = reader.read(buffer)) > -1) {
            out.write(buffer, 0, length);
        }
        return out.toString();
    }

    public static void close(Closeable resource) {
        if (resource != null) {
            try {
                resource.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

