/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.monitor.util;

public class HtmlUtil {
    public static String encode(String source) {
        if (source == null || source.length() < 1) {
            return "";
        }
        int length = source.length();
        StringBuilder buffer = null;
        block7: for (int i = 0; i < length; ++i) {
            char c = source.charAt(i);
            switch (c) {
                case '\"': {
                    if (buffer == null) {
                        buffer = HtmlUtil.getBuffer(source, 0, i);
                    }
                    buffer.append("&quot;");
                    continue block7;
                }
                case '<': {
                    if (buffer == null) {
                        buffer = HtmlUtil.getBuffer(source, 0, i);
                    }
                    buffer.append("&lt;");
                    continue block7;
                }
                case '>': {
                    if (buffer == null) {
                        buffer = HtmlUtil.getBuffer(source, 0, i);
                    }
                    buffer.append("&gt;");
                    continue block7;
                }
                case '&': {
                    if (buffer == null) {
                        buffer = HtmlUtil.getBuffer(source, 0, i);
                    }
                    buffer.append("&amp;");
                    continue block7;
                }
                case '\'': {
                    if (buffer == null) {
                        buffer = HtmlUtil.getBuffer(source, 0, i);
                    }
                    buffer.append("&#39;");
                    continue block7;
                }
                default: {
                    if (buffer == null) continue block7;
                    buffer.append(c);
                }
            }
        }
        return buffer != null ? buffer.toString() : source;
    }

    public static StringBuilder getBuffer(String source, int offset, int length) {
        StringBuilder buffer = new StringBuilder();
        if (length > 0) {
            buffer.append(source, offset, offset + length);
        }
        return buffer;
    }

    public static String decode(String source) {
        if (source == null) {
            return "";
        }
        int length = source.length();
        char[] c = source.toCharArray();
        StringBuilder buffer = new StringBuilder(length);
        block4: for (int i = 0; i < length; ++i) {
            if (c[i] == '&') {
                if (i + 3 < length && c[i + 1] == 'l' && c[i + 2] == 't' && c[i + 3] == ';') {
                    buffer.append('<');
                    i += 3;
                    continue;
                }
                if (i + 3 < length && c[i + 1] == 'g' && c[i + 2] == 't' && c[i + 3] == ';') {
                    buffer.append('>');
                    i += 3;
                    continue;
                }
                if (i + 4 < length && c[i + 1] == 'a' && c[i + 2] == 'm' && c[i + 3] == 'p' && c[i + 4] == ';') {
                    buffer.append('&');
                    i += 4;
                    continue;
                }
                if (i + 5 < length && c[i + 1] == 'q' && c[i + 2] == 'u' && c[i + 3] == 'o' && c[i + 4] == 't' && c[i + 5] == ';') {
                    buffer.append('\"');
                    i += 5;
                    continue;
                }
                if (i + 7 < length && c[i + 1] == '#' && Character.toLowerCase(c[i + 2]) == 'x' && c[i + 7] == ';') {
                    try {
                        int charCode = Integer.parseInt(new String(c, i + 3, 4), 16);
                        buffer.append((char)charCode);
                    }
                    catch (NumberFormatException e) {
                        buffer.append(c, i, 8);
                    }
                    i += 7;
                    continue;
                }
                if (i + 3 < length && c[i + 1] == '#' && Character.isDigit(c[i + 2])) {
                    for (int j = i + 2; j < length; ++j) {
                        if (Character.isDigit(c[j])) continue;
                        if (c[j] != ';') {
                            buffer.append('&');
                            continue block4;
                        }
                        try {
                            int charCode = Integer.parseInt(new String(c, i + 2, j - i - 2));
                            buffer.append((char)charCode);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        i = j;
                        continue block4;
                    }
                    continue;
                }
                buffer.append('&');
                continue;
            }
            buffer.append(c[i]);
        }
        return buffer.toString();
    }

    public static String remove(String source) {
        if (source == null) {
            return "";
        }
        int i = 0;
        int length = source.length();
        String nodeName = null;
        StringBuilder temp = new StringBuilder();
        StringBuilder buffer = new StringBuilder();
        while (i < length) {
            char c = source.charAt(i);
            if (c == '<') {
                if (i + 3 < length && source.charAt(i + 1) == '!' && source.charAt(i + 2) == '-' && source.charAt(i + 3) == '-') {
                    i = HtmlUtil.skipComment(source, i + 4);
                    continue;
                }
                i = HtmlUtil.readNodeName(source, temp, i + 1);
                if ((i = source.indexOf(62, i)) < 0) break;
                nodeName = temp.toString();
                temp.setLength(0);
                ++i;
                if (!nodeName.equals("script") && !nodeName.equals("style")) continue;
                i = HtmlUtil.skipContent(source, i);
                continue;
            }
            buffer.append(c);
            ++i;
        }
        return buffer.toString();
    }

    private static int skipComment(String source, int offset) {
        int i;
        int length = source.length();
        for (i = offset; i < length; ++i) {
            char c = source.charAt(i);
            if (c != '-' || i + 2 >= length || source.charAt(i + 1) != '-' || source.charAt(i + 2) != '>') continue;
            i += 3;
            break;
        }
        return i;
    }

    private static int skipContent(String source, int offset) {
        char c;
        int i = offset;
        int length = source.length();
        String nodeName = null;
        StringBuilder buffer = new StringBuilder();
        while (i < length) {
            c = source.charAt(i);
            if (c == '<' && i + 1 < length && source.charAt(i + 1) == '/') {
                i = HtmlUtil.readNodeName(source, buffer, i + 2);
                nodeName = buffer.toString().trim();
                buffer.setLength(0);
                if (!nodeName.equals("script") && !nodeName.equals("style")) continue;
                break;
            }
            ++i;
        }
        while (i < length && (c = source.charAt(i++)) != '>') {
        }
        return i;
    }

    private static int readNodeName(String source, StringBuilder buffer, int offset) {
        char c;
        int i;
        for (i = offset; i < source.length() && !Character.isWhitespace(c = source.charAt(i)) && !Character.isISOControl(c) && c != '/' && c != '>'; ++i) {
            buffer.append(Character.toLowerCase(c));
        }
        return i;
    }

    protected static String right(String text, int offset, int length) {
        if (text == null) {
            return "";
        }
        if (text.length() - offset > length) {
            return text.substring(offset, text.length() - length);
        }
        return text.substring(offset);
    }
}

