/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.monitor.util;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class GMTUtil {
    private static String EMPTY = "";
    private static String DATE_FORMAT_GMT = "EEE, dd MMM yyyy HH:mm:ss z";
    private static Locale local = Locale.ENGLISH;
    private static TimeZone timeZone = TimeZone.getTimeZone("GMT");

    public static Date parse(String source) {
        Date date = null;
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT_GMT, local);
            dateFormat.setTimeZone(timeZone);
            date = dateFormat.parse(source);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return date;
    }

    public static String format(long timeMillis) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT_GMT, local);
        dateFormat.setTimeZone(timeZone);
        return dateFormat.format(new Date(timeMillis));
    }

    public static String format(Date date) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT_GMT, local);
        dateFormat.setTimeZone(timeZone);
        return date != null ? dateFormat.format(date) : EMPTY;
    }

    public static String toString(Date date) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT_GMT, local);
        dateFormat.setTimeZone(timeZone);
        return date != null ? dateFormat.format(date) : EMPTY;
    }
}

