/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.monitor.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class DateUtil {
    public static Date getToday(String pattern, String target) {
        return DateUtil.getDate(new Date(), pattern, target);
    }

    public static Date getTomrrow(String pattern, String target) {
        Date date = new Date(System.currentTimeMillis() + 86400000L);
        return DateUtil.getDate(date, pattern, target);
    }

    public static Date getDate(Date date, String pattern, String target) {
        String dateTime = DateUtil.format(date, pattern);
        return DateUtil.parse(dateTime, target);
    }

    public static Date parse(String date) {
        return DateUtil.parse(date, "yyyy-MM-dd HH:mm:ss");
    }

    public static Date parse(String date, String pattern) {
        if (date == null) {
            return null;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(pattern);
        try {
            return dateFormat.parse(date);
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public static String format(long timeMillis, String pattern) {
        if (timeMillis > 0L) {
            SimpleDateFormat dateFormat = new SimpleDateFormat(pattern);
            return dateFormat.format(new Date(timeMillis));
        }
        return "";
    }

    public static String format(Date date, String pattern) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(pattern);
        return dateFormat.format(date);
    }

    public static int year(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(1);
    }

    public static int month(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(2);
    }

    public static int day(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(5);
    }

    public static Date addDay(Date date, int value) {
        return DateUtil.add(date, 5, value);
    }

    public static Date add(Date date, int field, int value) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int current = calendar.get(field);
        calendar.set(field, current + value);
        return calendar.getTime();
    }
}

