/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.monitor.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ComputerInfo {
    private static String macAddressStr = null;
    private static String computerName = System.getenv().get("COMPUTERNAME");
    private static final String[] windowsCommand = new String[]{"ipconfig", "/all"};
    private static final String[] linuxCommand = new String[]{"/sbin/ifconfig", "-a"};
    private static final Pattern macPattern = Pattern.compile(".*((:?[0-9a-f]{2}[-:]){5}[0-9a-f]{2}).*", 2);

    private static final List<String> getMacAddressList() throws IOException {
        String[] command;
        ArrayList<String> macAddressList = new ArrayList<String>();
        String os = System.getProperty("os.name");
        if (os.startsWith("Windows")) {
            command = windowsCommand;
        } else if (os.startsWith("Linux") | os.startsWith("Mac")) {
            command = linuxCommand;
        } else {
            throw new IOException("Unknow operating system:" + os);
        }
        Process process = Runtime.getRuntime().exec(command);
        BufferedReader bufReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        String line = null;
        while ((line = bufReader.readLine()) != null) {
            Matcher matcher = macPattern.matcher(line);
            if (!matcher.matches()) continue;
            macAddressList.add(matcher.group(1).replaceAll("[-:]", ""));
        }
        process.destroy();
        bufReader.close();
        return macAddressList;
    }

    public static String getMacAddress() {
        if (macAddressStr == null || macAddressStr.equals("")) {
            StringBuffer sb = new StringBuffer();
            try {
                List<String> macList = ComputerInfo.getMacAddressList();
                for (String amac : macList) {
                    if (amac.equals("0000000000E0")) continue;
                    sb.append(amac);
                    break;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            macAddressStr = sb.toString().toUpperCase();
        }
        return macAddressStr;
    }

    public static String getComputerName() {
        if (computerName == null || computerName.equals("")) {
            computerName = System.getenv().get("COMPUTERNAME");
        }
        return computerName;
    }

    public static String getIpAddrAndName() throws IOException {
        return InetAddress.getLocalHost().toString();
    }

    public static String getIpAddr() {
        try {
            return InetAddress.getLocalHost().getHostAddress().toString();
        }
        catch (UnknownHostException e) {
            return "127.0.0.1";
        }
    }

    private ComputerInfo() {
    }
}

