/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.monitor.util;

import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLDecoder;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassUtil {
    private static final Logger logger = LoggerFactory.getLogger(ClassUtil.class);
    private static final boolean DEBUG = logger.isDebugEnabled();

    public static Class<?> getClass(String className) throws ClassNotFoundException {
        Class<?> clazz = null;
        try {
            clazz = Thread.currentThread().getContextClassLoader().loadClass(className);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (clazz != null) {
            return clazz;
        }
        try {
            clazz = ClassUtil.class.getClassLoader().loadClass(className);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (clazz != null) {
            return clazz;
        }
        return Class.forName(className);
    }

    public static Object getInstance(String className) throws Exception {
        Class<?> clazz = ClassUtil.getClass(className);
        return clazz.newInstance();
    }

    public static Object getInstance(String className, Class<?> parent) throws Exception {
        Class<?> clazz = ClassUtil.getClass(className);
        if (parent != null && !parent.isAssignableFrom(clazz)) {
            throw new ClassCastException(className + " class must be implement the " + parent.getName() + " interface.");
        }
        return clazz.newInstance();
    }

    public static Method getMethod(String methodName, Class<?> type, Object[] args) {
        Method method = null;
        Method[] methods = type.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Class<?>[] parameterTypes;
            method = methods[i];
            if (!method.getName().equals(methodName) || (parameterTypes = method.getParameterTypes()) == null || parameterTypes.length != args.length) continue;
            boolean flag = true;
            for (int j = 0; j < parameterTypes.length; ++j) {
                if (args[j] == null || parameterTypes[j] == args[j].getClass()) continue;
                flag = false;
                break;
            }
            if (!flag) continue;
            return method;
        }
        return null;
    }

    public static Object cast(Object value, Class<?> type) {
        if (value == null || type == null) {
            return null;
        }
        Class<?> clazz = value.getClass();
        if (type.isAssignableFrom(clazz)) {
            return value;
        }
        return ClassUtil.cast(value.toString(), type);
    }

    public static Object cast(String value, Class<?> type) {
        Object result;
        block55: {
            if (value == null || type == null) {
                return null;
            }
            result = null;
            if (type == Character.TYPE || type == Character.class) {
                result = value.length() > 0 ? Character.valueOf(value.charAt(0)) : null;
            } else if (type == Boolean.TYPE || type == Boolean.class) {
                boolean b = "1".equalsIgnoreCase(value) || "y".equalsIgnoreCase(value) || "on".equalsIgnoreCase(value) || "yes".equalsIgnoreCase(value) || "true".equalsIgnoreCase(value);
                result = b;
            } else if (type == Byte.TYPE || type == Byte.class) {
                try {
                    result = Byte.parseByte(value);
                }
                catch (NumberFormatException b) {}
            } else if (type == Short.TYPE || type == Short.class) {
                try {
                    result = Short.parseShort(value);
                }
                catch (NumberFormatException b) {}
            } else if (type == Integer.TYPE || type == Integer.class) {
                try {
                    result = Integer.parseInt(value);
                }
                catch (NumberFormatException b) {}
            } else if (type == Float.TYPE || type == Float.class) {
                try {
                    result = Float.valueOf(Float.parseFloat(value));
                }
                catch (NumberFormatException b) {}
            } else if (type == Double.TYPE || type == Double.class) {
                try {
                    result = Double.parseDouble(value);
                }
                catch (NumberFormatException b) {}
            } else if (type == Long.TYPE || type == Long.class) {
                try {
                    result = Long.parseLong(value);
                }
                catch (NumberFormatException b) {}
            } else if (type == String.class) {
                result = value;
            } else if (type == StringBuilder.class) {
                result = new StringBuilder(value);
            } else if (type == StringBuffer.class) {
                result = new StringBuffer(value);
            } else if (type == Reader.class) {
                result = new StringReader(value);
            } else if (type == Date.class) {
                if (value.length() > 0) {
                    try {
                        String format = ClassUtil.getFormat(value);
                        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
                        java.util.Date date = dateFormat.parse(value);
                        result = new Date(date.getTime());
                    }
                    catch (ParseException format) {}
                }
            } else if (type == Time.class) {
                if (value.length() > 0) {
                    try {
                        String format = ClassUtil.getFormat(value);
                        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
                        java.util.Date date = dateFormat.parse(value);
                        result = new Time(date.getTime());
                    }
                    catch (ParseException format) {}
                }
            } else if (type == Timestamp.class) {
                if (value.length() > 0) {
                    try {
                        String format = ClassUtil.getFormat(value);
                        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
                        java.util.Date date = dateFormat.parse(value);
                        result = new Timestamp(date.getTime());
                    }
                    catch (ParseException format) {}
                }
            } else if (type == java.util.Date.class && value.length() > 0) {
                try {
                    String format = ClassUtil.getFormat(value);
                    SimpleDateFormat dateFormat = new SimpleDateFormat(format);
                    result = dateFormat.parse(value);
                }
                catch (ParseException e) {
                    if (!DEBUG) break block55;
                    logger.debug("Exception: " + e.getMessage());
                }
            }
        }
        return result;
    }

    protected static String getFormat(String date) {
        int length = date.length();
        String f1 = "HH:mm:ss";
        String f2 = "yyyy-MM-dd";
        String f3 = "HH:mm:ss SSS";
        String f4 = "yyyy-MM-dd HH:mm:ss";
        String f5 = "yyyy-MM-dd HH:mm:ss SSS";
        if (length <= f1.length()) {
            return f1;
        }
        if (length <= f2.length()) {
            return f2;
        }
        if (length <= f3.length()) {
            return f3;
        }
        if (length <= f4.length()) {
            return f4;
        }
        if (length <= f5.length()) {
            return f5;
        }
        return f3;
    }

    public static String getJarFilePath(Class<?> type) {
        URL url = type.getResource(type.getSimpleName() + ".class");
        String path = url.toExternalForm();
        int k = path.lastIndexOf("!/");
        if (k > -1) {
            path = path.substring(0, k);
        }
        if (!path.startsWith("jar:")) {
            return null;
        }
        if ((path = path.substring(4)).startsWith("file:")) {
            path = path.substring(5);
        }
        try {
            path = URLDecoder.decode(path, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            e.getMessage();
        }
        return path;
    }
}

