/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.monitor.sigar;

import com.jxdinfo.hussar.monitor.sigar.SigarFactory;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.hyperic.jni.ArchNotSupportedException;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SigarPreLoader {
    private static final String SIGAR_PATH = "org.hyperic.sigar.path";
    private static final Logger logger = LoggerFactory.getLogger(SigarFactory.class);

    public void setLibraryPath() {
        try {
            SigarLoader loader = new SigarLoader(Sigar.class);
            String libName = loader.getLibraryName();
            String sysTemp = System.getProperty("java.io.tmpdir");
            File tempFile = new File(sysTemp + File.separator + libName);
            InputStream inputStream = this.getClass().getResourceAsStream("/sigar/" + libName);
            FileOutputStream outputStream = new FileOutputStream(tempFile);
            byte[] array = new byte[8192];
            int i = inputStream.read(array);
            while (i != -1) {
                outputStream.write(array, 0, i);
                i = inputStream.read(array);
            }
            outputStream.close();
            tempFile.deleteOnExit();
            System.setProperty(SIGAR_PATH, sysTemp);
        }
        catch (IOException e) {
            logger.error("Can't set sigar library path!", (Throwable)e);
        }
        catch (ArchNotSupportedException e) {
            logger.error("Can't set sigar library path!", (Throwable)e);
        }
    }
}

