/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.monitor.servlet;

import com.jxdinfo.hussar.monitor.util.ClassUtil;
import com.jxdinfo.hussar.monitor.util.IO;
import com.jxdinfo.hussar.monitor.web.ContentEntry;
import com.jxdinfo.hussar.monitor.web.FileResourceManager;
import com.jxdinfo.hussar.monitor.web.JarResourceManager;
import com.jxdinfo.hussar.monitor.web.MimeType;
import com.jxdinfo.hussar.monitor.web.ResourceManager;
import com.jxdinfo.hussar.monitor.web.UrlPattern;
import com.jxdinfo.hussar.monitor.web.servlet.BaseServlet;
import com.jxdinfo.hussar.monitor.web.servlet.FileServlet;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceServlet
extends BaseServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(ResourceServlet.class);
    private static final int MAX_AGE = 1800;
    private static final ResourceManager resourceManager = ResourceServlet.getResourceManager("/resource");

    @UrlPattern(value={"res"})
    public void execute(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String path = request.getParameter("path");
        ContentEntry contentEntry = resourceManager.get(path);
        if (contentEntry == null) {
            response.setHeader("NotFound", path);
            response.sendError(404);
            return;
        }
        long timeMillis = System.currentTimeMillis();
        long lastModified = contentEntry.getLastModified();
        String contentType = MimeType.getMimeType(contentEntry.getName());
        String eTag = "W/\"f-" + lastModified + "\"";
        if (!FileServlet.checkIfHeaders(request, response, eTag, lastModified)) {
            return;
        }
        response.addHeader("Cache-Control", "max-age=1800");
        response.addHeader("Cache-Control", "public");
        response.setDateHeader("Expires", timeMillis + 1800000L);
        response.setDateHeader("Last-Modified", lastModified);
        response.setDateHeader("Date", lastModified);
        response.setHeader("ETag", eTag);
        response.setContentType(contentType);
        int type = contentEntry.getType();
        byte[] bytes = contentEntry.getBytes();
        ServletOutputStream outputStream = response.getOutputStream();
        String acceptEncoding = request.getHeader("Accept-Encoding");
        if (type == 1) {
            if (acceptEncoding != null && acceptEncoding.indexOf("gzip") > -1) {
                response.setContentLength(bytes.length);
                response.setHeader("Content-Encoding", "gzip");
                outputStream.write(bytes, 0, bytes.length);
            } else {
                byte[] buffer = ResourceManager.ungzip(bytes);
                response.setContentLength(buffer.length);
                outputStream.write(buffer, 0, buffer.length);
            }
        } else {
            response.setContentLength(bytes.length);
            outputStream.write(bytes, 0, bytes.length);
        }
        outputStream.flush();
    }

    protected String format(long timeMillis) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.ENGLISH);
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        return dateFormat.format(new Date(timeMillis));
    }

    public static ResourceManager getResourceManager(String home) {
        ResourceManager manager = null;
        Class<ResourceServlet> type = ResourceServlet.class;
        String jarFile = ClassUtil.getJarFilePath(type);
        try {
            if (jarFile != null) {
                manager = new JarResourceManager(jarFile, home);
            } else {
                URL url = type.getClassLoader().getResource("");
                File file = IO.getFile(url);
                if (file == null) {
                    logger.warn("load resource failed!");
                    return null;
                }
                logger.info("load resource from: {}", (Object)file.getAbsolutePath());
                manager = new FileResourceManager(file.getAbsolutePath(), home);
            }
            return manager;
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

