/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.monitor.servlet;

import com.alibaba.fastjson.JSONArray;
import com.jxdinfo.hussar.monitor.cache.CacheFactory;
import com.jxdinfo.hussar.monitor.cluster.Agent;
import com.jxdinfo.hussar.monitor.servlet.template.IndexTemplate;
import com.jxdinfo.hussar.monitor.util.MonitorUtil;
import com.jxdinfo.hussar.monitor.util.StringUtil;
import com.jxdinfo.hussar.monitor.web.Ajax;
import com.jxdinfo.hussar.monitor.web.UrlPattern;
import com.jxdinfo.hussar.monitor.web.servlet.BaseServlet;
import java.io.File;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class MonitorServlet
extends BaseServlet {
    private static final long serialVersionUID = 877786924390905584L;

    @Override
    @UrlPattern(value={"monitor"})
    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String htmlPath = (String)CacheFactory.getInstance().get("htmlPath");
        String realPath = request.getSession().getServletContext().getRealPath(htmlPath);
        File file = new File(realPath);
        if (file.exists()) {
            this.forward(request, response, htmlPath);
        } else {
            IndexTemplate.execute(request, response);
        }
    }

    @UrlPattern(value={"serverList.json"})
    public void serverList(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        JSONArray serverList = MonitorUtil.getInstance().getServerList();
        Ajax.json(request, response, serverList.toJSONString());
    }

    @UrlPattern(value={"chartList.json"})
    public void chartList(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        JSONArray chartList = new JSONArray();
        String local = (String)CacheFactory.getInstance().get("local");
        String host = request.getParameter("host");
        if (StringUtil.notBlank(host)) {
            if (host.contains("/")) {
                host = host.replace("/", ":");
            }
            if (!StringUtil.equals(local, host)) {
                Agent.dispatch(request, response);
            }
        } else {
            chartList = MonitorUtil.getInstance().getChartList();
        }
        Ajax.json(request, response, chartList.toJSONString());
    }

    @UrlPattern(value={"detectorInfo.json"})
    public void detectorInfo(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        JSONArray detectorInfo = new JSONArray();
        String local = (String)CacheFactory.getInstance().get("local");
        String host = request.getParameter("host");
        if (StringUtil.notBlank(host)) {
            if (host.contains("/")) {
                host = host.replace("/", ":");
            }
            if (!StringUtil.equals(local, host)) {
                Agent.dispatch(request, response);
            }
        } else {
            detectorInfo = MonitorUtil.getInstance().getDetectorInfo();
        }
        Ajax.layJson(request, response, detectorInfo.toJSONString(), detectorInfo.size());
    }
}

