/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.monitor.http;

import com.jxdinfo.hussar.monitor.util.IO;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ProxyDispatcher {
    private static final Logger logger = LoggerFactory.getLogger(ProxyDispatcher.class);

    private ProxyDispatcher() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dispatch(HttpServletRequest request, HttpServletResponse response, String address) throws IOException {
        HttpURLConnection connection = null;
        ServletOutputStream outputStream = response.getOutputStream();
        String method = request.getMethod();
        String queryString = request.getQueryString();
        String requestURL = address;
        logger.debug("address: {}", (Object)address);
        logger.debug("queryString: {}", (Object)queryString);
        logger.debug("requestURL: {}", (Object)requestURL);
        try {
            URL url = new URL(requestURL);
            int port = url.getPort();
            connection = (HttpURLConnection)url.openConnection();
            connection.setConnectTimeout(60000);
            connection.setReadTimeout(60000);
            connection.setDoInput(true);
            connection.setDoOutput(true);
            connection.setUseCaches(false);
            connection.setRequestMethod(method);
            logger.debug("request.method: {}", (Object)method);
            ProxyDispatcher.setRequestHeaders(request, connection);
            if (port > 0 && port != 80) {
                response.setHeader("Host-Name", url.getHost() + ":" + url.getPort());
                connection.setRequestProperty("Host", url.getHost() + ":" + port);
            } else {
                response.setHeader("Host-Name", url.getHost());
                connection.setRequestProperty("Host", url.getHost());
            }
            connection.setRequestProperty("Connection", "Close");
            if ("post".equalsIgnoreCase(method)) {
                ProxyDispatcher.pipe(request, connection);
            }
            int status = connection.getResponseCode();
            int contentLength = connection.getContentLength();
            int bufferSize = ProxyDispatcher.getBufferSize(connection.getContentLength(), 8192);
            logger.debug("response.status: {}", (Object)status);
            response.setStatus(status);
            ProxyDispatcher.setResponseHeaders(connection, response);
            try {
                if (contentLength < 0) {
                    IO.copy(connection.getInputStream(), (OutputStream)outputStream, bufferSize);
                } else if (contentLength > 0) {
                    IO.copy(connection.getInputStream(), (OutputStream)outputStream, bufferSize, contentLength);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    private static void setRequestHeaders(HttpServletRequest request, HttpURLConnection connection) {
        Enumeration enums = request.getHeaderNames();
        while (enums.hasMoreElements()) {
            Enumeration values;
            String name = enums.nextElement().toString();
            if (name == null || name.equalsIgnoreCase("Host") || name.equalsIgnoreCase("Transfer-Encoding") || (values = request.getHeaders(name)) == null) continue;
            ProxyDispatcher.setRequestHeaders(connection, name, values);
        }
    }

    private static void setRequestHeaders(HttpURLConnection connection, String name, Enumeration<?> values) {
        while (values.hasMoreElements()) {
            String value = values.nextElement().toString();
            connection.addRequestProperty(name, value);
            if (!logger.isDebugEnabled()) continue;
            if (name.equalsIgnoreCase("cookie")) {
                logger.debug("request - {}: ******", (Object)name);
                continue;
            }
            logger.debug("request - {}: {}", (Object)name, (Object)value);
        }
    }

    private static void setResponseHeaders(HttpURLConnection connection, HttpServletResponse response) {
        Map<String, List<String>> map = connection.getHeaderFields();
        for (Map.Entry<String, List<String>> entry : map.entrySet()) {
            List<String> values;
            String name = entry.getKey();
            if (name == null || name.equalsIgnoreCase("Transfer-Encoding") || (values = entry.getValue()) == null || values.size() <= 0) continue;
            for (String value : values) {
                logger.debug("response - {}: {}", (Object)name, (Object)value);
                response.addHeader(name, value);
            }
        }
    }

    protected static void pipe(HttpServletRequest request, HttpURLConnection connection) throws IOException {
        int contentLength = request.getContentLength();
        if (contentLength == 0) {
            return;
        }
        logger.debug("copy request.body");
        String contentType = request.getContentType();
        int bufferSize = ProxyDispatcher.getBufferSize(request.getContentLength(), 8192);
        if (contentType == null || !contentType.startsWith("application/x-www-form-urlencoded")) {
            IO.copy((InputStream)request.getInputStream(), connection.getOutputStream(), bufferSize);
            return;
        }
        ServletInputStream inputStream = request.getInputStream();
        OutputStream outputStream = connection.getOutputStream();
        logger.debug("contentLength: {}, bufferSize: {}", (Object)contentLength, (Object)bufferSize);
        long count = ProxyDispatcher.copy((InputStream)inputStream, outputStream, bufferSize);
        if (count == 0L) {
            String body = ProxyDispatcher.getPostBody(request);
            logger.debug("request.body: {}", (Object)body);
            if (body != null && body.length() > 0) {
                String encoding = request.getCharacterEncoding();
                if (encoding == null) {
                    encoding = "utf-8";
                }
                byte[] pack = body.getBytes(encoding);
                logger.error("request.contentLength: {}, pack.length: {}", (Object)contentLength, (Object)pack.length);
                if (pack.length != contentLength) {
                    logger.error("contentLength != pack.length, [{}, {}]", (Object)contentLength, (Object)pack.length);
                }
                outputStream.write(pack, 0, pack.length);
                outputStream.flush();
            }
        }
    }

    public static long copy(InputStream inputStream, OutputStream outputStream, int bufferSize) throws IOException {
        int length = 0;
        long count = 0L;
        byte[] buffer = new byte[bufferSize];
        while ((length = inputStream.read(buffer, 0, bufferSize)) > -1) {
            outputStream.write(buffer, 0, length);
            count += (long)length;
        }
        outputStream.flush();
        return count;
    }

    private static int getBufferSize(int contentLength, int maxSize) {
        if (contentLength < 0 || contentLength >= 8192) {
            return maxSize;
        }
        return ProxyDispatcher.getBufferSize(contentLength);
    }

    private static int getBufferSize(int length) {
        int capacity = length;
        capacity |= capacity >>> 1;
        capacity |= capacity >>> 2;
        capacity |= capacity >>> 4;
        capacity |= capacity >>> 8;
        capacity |= capacity >>> 16;
        return ++capacity;
    }

    protected static String getPostBody(HttpServletRequest request) {
        Enumeration enums = request.getParameterNames();
        if (enums == null) {
            return null;
        }
        StringBuilder buffer = new StringBuilder();
        Map<String, String> names = ProxyDispatcher.parseNames(request.getQueryString());
        String encoding = request.getCharacterEncoding();
        if (encoding == null) {
            encoding = "utf-8";
        }
        while (enums.hasMoreElements()) {
            String[] values;
            String name = enums.nextElement().toString();
            if (names.get(name) != null || (values = request.getParameterValues(name)) == null || values.length <= 0) continue;
            try {
                for (String value : values) {
                    if (value == null) continue;
                    buffer.append(name);
                    buffer.append("=");
                    buffer.append(URLEncoder.encode(value, encoding));
                    buffer.append("&");
                }
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        if (buffer.length() > 0) {
            buffer.setLength(buffer.length() - 1);
        }
        return buffer.toString();
    }

    protected static Map<String, String> parseNames(String queryString) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (queryString == null || queryString.length() < 1) {
            return map;
        }
        int i = 0;
        int j = queryString.lastIndexOf(35);
        char c = queryString.charAt(0);
        if (c == '?' || c == '#') {
            ++i;
        }
        if (j < i) {
            j = queryString.length();
        }
        int k = 0;
        String name = null;
        while (i < j) {
            k = queryString.indexOf(61, i);
            if (k > -1) {
                name = queryString.substring(i, k);
                map.put(name, name);
                i = queryString.indexOf(38, k + 1);
                if (i < 0) break;
                ++i;
                continue;
            }
            name = queryString.substring(i, k);
            map.put(name, name);
            break;
        }
        return map;
    }
}

