/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.monitor.cluster;

import com.jxdinfo.hussar.monitor.cache.CacheFactory;
import com.jxdinfo.hussar.monitor.http.ProxyDispatcher;
import com.jxdinfo.hussar.monitor.util.StringUtil;
import com.jxdinfo.hussar.monitor.util.URLParameter;
import com.jxdinfo.hussar.monitor.web.Ajax;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Agent {
    private static final Logger logger = LoggerFactory.getLogger(Agent.class);

    private Agent() {
    }

    public static boolean dispatch(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String queryString = request.getQueryString();
        URLParameter params = URLParameter.parse(queryString);
        return Agent.dispatch(request, response, params.getString("host"), true);
    }

    public static boolean dispatch(HttpServletRequest request, HttpServletResponse response, boolean ajax) throws IOException, ServletException {
        String queryString = request.getQueryString();
        URLParameter params = URLParameter.parse(queryString);
        return Agent.dispatch(request, response, params.getString("host"), ajax);
    }

    public static boolean dispatch(HttpServletRequest request, HttpServletResponse response, String hostName, boolean ajax) throws IOException, ServletException {
        if (StringUtil.isBlank(hostName)) {
            return false;
        }
        String self = (String)CacheFactory.getInstance().get("local");
        if (hostName.contains("/")) {
            hostName = hostName.replace("/", ":");
        }
        if (hostName.equals(self)) {
            return false;
        }
        String scheme = request.getScheme();
        String url = scheme + "://" + hostName;
        String queryString = URLParameter.remove(request.getQueryString(), "host");
        String uri = request.getRequestURI();
        if (StringUtil.notBlank(queryString)) {
            url = url + uri + "?" + queryString;
        }
        logger.debug("agent: {}, {}", (Object)hostName, (Object)url);
        try {
            ProxyDispatcher.dispatch(request, response, url);
        }
        catch (IOException e) {
            Ajax.error(request, response, "'" + hostName + "' is unavailable.");
        }
        return true;
    }
}

