/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.monitor.cache;

import com.jxdinfo.hussar.monitor.cache.Cache;
import com.jxdinfo.hussar.monitor.cache.CacheEntry;
import com.jxdinfo.hussar.monitor.cache.LRULinkedHashMap;
import java.util.concurrent.locks.ReentrantLock;

public class LRUCache
implements Cache {
    private static final int MILLISECONDS = 1000;
    private LRULinkedHashMap<String, CacheEntry> context;
    private ReentrantLock lock;

    public LRUCache(int maxSize) {
        this.context = new LRULinkedHashMap(maxSize);
        this.lock = new ReentrantLock(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(String key, int expires, Object object) {
        this.lock.lock();
        try {
            CacheEntry cacheEntry = new CacheEntry(object);
            if (expires < 0) {
                cacheEntry.setExpires(0L);
            } else {
                cacheEntry.setExpires(System.currentTimeMillis() + (long)(expires * 1000));
            }
            this.context.put(key, cacheEntry);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(String key, int expires, long version, Object object) {
        this.lock.lock();
        try {
            CacheEntry cacheEntry = new CacheEntry(object);
            if (expires < 0) {
                cacheEntry.setExpires(0L);
            } else {
                cacheEntry.setExpires(System.currentTimeMillis() + (long)(expires * 1000));
            }
            cacheEntry.setVersion(version);
            this.context.put(key, cacheEntry);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object get(String key) {
        this.lock.lock();
        try {
            CacheEntry cacheEntry = (CacheEntry)this.context.get(key);
            if (cacheEntry != null) {
                if (cacheEntry.getExpires() == 0L || System.currentTimeMillis() < cacheEntry.getExpires()) {
                    int hits = cacheEntry.getHits();
                    cacheEntry.setHits(hits + 1);
                    Object object = cacheEntry.getValue();
                    return object;
                }
                this.context.remove(key);
            }
            Object var3_4 = null;
            return var3_4;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object get(String key, long version) {
        this.lock.lock();
        try {
            CacheEntry cacheEntry = (CacheEntry)this.context.get(key);
            if (cacheEntry != null && (cacheEntry.getExpires() == 0L || cacheEntry.getExpires() > System.currentTimeMillis() && cacheEntry.getVersion() == version)) {
                int hits = cacheEntry.getHits();
                cacheEntry.setHits(hits + 1);
                Object object = cacheEntry.getValue();
                return object;
            }
            this.context.remove(key);
            Object var5_5 = null;
            return var5_5;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object remove(String key) {
        this.lock.lock();
        try {
            CacheEntry cacheEntry = (CacheEntry)this.context.remove(key);
            if (cacheEntry != null) {
                Object object = cacheEntry.getValue();
                return object;
            }
            Object var3_4 = null;
            return var3_4;
        }
        finally {
            this.lock.unlock();
        }
    }
}

