/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.modcodeapp.model;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;

public class CodeGenerator {
    private String templateName;
    private Map<String, Object> templateParam;
    private String templatepath;
    private String filepath;
    private String fileName;

    public CodeGenerator(String templateName, Map<String, Object> templateParam, String templatepath, String filepath, String fileName) {
        this.templateName = templateName;
        this.templateParam = templateParam;
        this.templatepath = templatepath;
        this.filepath = filepath;
        this.fileName = fileName;
    }

    public void gen() {
        try {
            Configuration cfg = new Configuration(Configuration.VERSION_2_3_22);
            cfg.setDirectoryForTemplateLoading(new File(this.templatepath));
            cfg.setDefaultEncoding("UTF-8");
            cfg.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
            Template temp = cfg.getTemplate(this.templateName);
            HashMap<String, Object> root = new HashMap<String, Object>();
            for (Map.Entry<String, Object> entry : this.templateParam.entrySet()) {
                root.put(entry.getKey().toString(), entry.getValue());
            }
            File dir = new File(this.filepath);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            FileOutputStream fos = new FileOutputStream(new File(dir, this.fileName));
            OutputStreamWriter out = new OutputStreamWriter(fos);
            temp.process(root, (Writer)out);
            fos.flush();
            ((OutputStream)fos).close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (TemplateException e) {
            e.printStackTrace();
        }
        System.out.println("gen code success!");
    }
}

