/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.mobile.push.publish.service.impl;

import com.alibaba.fastjson.JSON;
import com.eatthepath.pushy.apns.ApnsClient;
import com.eatthepath.pushy.apns.ApnsClientBuilder;
import com.eatthepath.pushy.apns.ApnsPushNotification;
import com.eatthepath.pushy.apns.util.ApnsPayloadBuilder;
import com.eatthepath.pushy.apns.util.SimpleApnsPayloadBuilder;
import com.eatthepath.pushy.apns.util.SimpleApnsPushNotification;
import com.eatthepath.pushy.apns.util.TokenUtil;
import com.jxdinfo.hussar.mobile.push.annotation.MethodHandler;
import com.jxdinfo.hussar.mobile.push.annotation.ProType;
import com.jxdinfo.hussar.mobile.push.app.dto.ProducerConfiguration;
import com.jxdinfo.hussar.mobile.push.message.ApnsMessage;
import com.jxdinfo.hussar.mobile.push.message.Message;
import com.jxdinfo.hussar.mobile.push.publish.enums.ProTypeEnum;
import com.jxdinfo.hussar.mobile.push.publish.service.PushMessage;
import com.jxdinfo.hussar.mobile.push.publish.vo.PushResult;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.oss.core.support.service.AttachmentManagerService;
import com.jxdinfo.hussar.support.oss.core.support.vo.AttachmentManagerModelVo;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@MethodHandler
public class ApnsServiceImpl
implements PushMessage {
    private static final Logger log = LoggerFactory.getLogger(ApnsServiceImpl.class);
    @Resource
    private AttachmentManagerService attachmentManagerService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ProType(value={ProTypeEnum.APNS})
    public PushResult pushMessage(ProducerConfiguration configuration) {
        PushResult result = new PushResult();
        ApnsClientBuilder apnsClientBuilder = new ApnsClientBuilder();
        try (ApnsClient apnsClient = null;){
            InputStream in;
            String payload = this.BuildMessage(configuration.getMessage(), configuration.getPushId());
            if (configuration.getEnvironment() == null || configuration.getEnvironment() == 0) {
                in = this.getP12InputStream(configuration.getProduceP12());
                if (in == null) {
                    log.error("\u8bfb\u53d6p12\u6587\u4ef6\u5931\u8d25");
                    ArrayList list = new ArrayList(configuration.getTokenSet());
                    result.setFailedTokens(list);
                    PushResult pushResult = result;
                    return pushResult;
                }
                apnsClient = apnsClientBuilder.setApnsServer("api.push.apple.com").setClientCredentials(in, configuration.getProduceP12pwd()).build();
            } else {
                in = this.getP12InputStream(configuration.getDevP12());
                if (in == null) {
                    ArrayList list = new ArrayList(configuration.getTokenSet());
                    result.setFailedTokens(list);
                    PushResult pushResult = result;
                    return pushResult;
                }
                apnsClient = apnsClientBuilder.setApnsServer("api.sandbox.push.apple.com").setClientCredentials(in, configuration.getDevP12pwd()).build();
            }
            for (String token : configuration.getTokenSet()) {
                apnsClient.sendNotification((ApnsPushNotification)new SimpleApnsPushNotification(TokenUtil.sanitizeTokenString((String)token), configuration.getBundleId(), payload));
            }
            log.info("Apns\u63a8\u9001\u6210\u529f\uff01");
        }
        return result;
    }

    private String BuildMessage(Message message, String pushId) {
        SimpleApnsPayloadBuilder apnsPayloadBuilder = new SimpleApnsPayloadBuilder();
        apnsPayloadBuilder.setBadgeNumber(Integer.valueOf(message.getBadge() == null ? 0 : message.getBadge()));
        apnsPayloadBuilder.setAlertTitle(message.getTitle());
        apnsPayloadBuilder.setAlertBody(message.getContent());
        if (message.getApnsMessage() != null) {
            ApnsMessage apnsMessage = message.getApnsMessage();
            if (HussarUtils.isNotEmpty((Object)apnsMessage.getSound())) {
                apnsPayloadBuilder.setSound(apnsMessage.getSound());
            }
            apnsPayloadBuilder.setCategoryName(apnsMessage.getCategory());
            if (HussarUtils.isNotEmpty((Object)apnsMessage.getActionLocKey())) {
                apnsPayloadBuilder.setLocalizedActionButtonKey(apnsMessage.getActionLocKey());
            }
            if (apnsMessage.getCustomFields() != null) {
                apnsMessage.getCustomFields().forEach((arg_0, arg_1) -> ApnsServiceImpl.lambda$BuildMessage$0((ApnsPayloadBuilder)apnsPayloadBuilder, arg_0, arg_1));
            }
            apnsPayloadBuilder.setLaunchImageFileName(apnsMessage.getLaunchImage());
            if (HussarUtils.isNotEmpty((Object)apnsMessage.getLocKey())) {
                apnsPayloadBuilder.setLocalizedAlertMessage(apnsMessage.getLocKey(), apnsMessage.getLocArgs() == null ? new String[]{} : apnsMessage.getLocArgs().toArray(new String[0]));
            }
            if (HussarUtils.isNotEmpty((Object)apnsMessage.getTitleLocKey())) {
                apnsPayloadBuilder.setLocalizedAlertTitle(apnsMessage.getTitleLocKey(), apnsMessage.getTitleLocArgs() == null ? new String[]{} : apnsMessage.getTitleLocArgs().toArray(new String[0]));
            }
            apnsPayloadBuilder.setContentAvailable(true);
        }
        Map content = (Map)JSON.parseObject((String)apnsPayloadBuilder.build(), Map.class);
        content.put("pushId", pushId);
        return JSON.toJSONString((Object)content);
    }

    private InputStream getP12InputStream(Long fileId) {
        try {
            AttachmentManagerModelVo byFileId = this.attachmentManagerService.getByFileId(fileId);
            File file = new File(byFileId.getPath());
            FileInputStream inputStream = new FileInputStream(file);
            return inputStream;
        }
        catch (IOException e) {
            e.printStackTrace();
            log.error(e.getMessage());
            return null;
        }
    }

    private static /* synthetic */ void lambda$BuildMessage$0(ApnsPayloadBuilder apnsPayloadBuilder, String k, Object v) {
        apnsPayloadBuilder.addCustomProperty(k, v);
    }
}

