/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.mobile.push.publish.service.impl;

import com.jxdinfo.hussar.mail.core.util.StrUtil;
import com.jxdinfo.hussar.mobile.push.annotation.MethodHandler;
import com.jxdinfo.hussar.mobile.push.annotation.ProType;
import com.jxdinfo.hussar.mobile.push.app.dto.ProducerConfiguration;
import com.jxdinfo.hussar.mobile.push.message.Action;
import com.jxdinfo.hussar.mobile.push.message.XmMessage;
import com.jxdinfo.hussar.mobile.push.publish.enums.ProTypeEnum;
import com.jxdinfo.hussar.mobile.push.publish.service.PushMessage;
import com.jxdinfo.hussar.mobile.push.publish.vo.PushResult;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.xiaomi.push.sdk.ErrorCode;
import com.xiaomi.xmpush.server.Constants;
import com.xiaomi.xmpush.server.Message;
import com.xiaomi.xmpush.server.Result;
import com.xiaomi.xmpush.server.Sender;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
@MethodHandler
public class XiaomiServiceImpl
implements PushMessage {
    @Value(value="${push.callbackURL.xiaomi}")
    private static String xmCallbackUrl;
    private static final Logger log;

    @ProType(value={ProTypeEnum.XIAOMI})
    public PushResult pushMessage(ProducerConfiguration configuration) {
        PushResult resResult = new PushResult();
        ArrayList decodeTokenList = new ArrayList(configuration.getTokenSet());
        try {
            Constants.useOfficial();
            Sender sender = new Sender(configuration.getProAppSecretKey());
            Message message = XiaomiServiceImpl.buildMessage(configuration);
            Result result = null;
            result = decodeTokenList != null && decodeTokenList.size() > 1 ? sender.send(message, decodeTokenList, 3) : sender.send(message, (String)decodeTokenList.get(0), 3);
            if (result.getErrorCode().getValue() == ErrorCode.Success.getValue()) {
                log.info("\u5c0f\u7c73\u5168\u90e8\u63a8\u9001\u6210\u529f");
                resResult.setSuccessTokens(decodeTokenList);
            } else {
                log.error(ProTypeEnum.XIAOMI.name() + ":" + result.getReason());
                resResult.setFailedTokens(decodeTokenList);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error(e.getMessage());
            resResult.setFailedTokens(decodeTokenList);
        }
        return resResult;
    }

    private static Message buildMessage(ProducerConfiguration configuration) {
        String description;
        XmMessage xmMessage = configuration.getMessage().getXmMessage() == null ? new XmMessage() : configuration.getMessage().getXmMessage();
        String title = configuration.getMessage().getTitle();
        if (StrUtil.length((CharSequence)title) >= 50) {
            title = StrUtil.sub((CharSequence)title, (int)0, (int)44);
            title = StrUtil.addSuffixIfNot((CharSequence)title, (CharSequence)"......");
        }
        if (StrUtil.length((CharSequence)(description = configuration.getMessage().getContent())) >= 128) {
            description = StrUtil.sub((CharSequence)description, (int)0, (int)122);
            description = StrUtil.addSuffixIfNot((CharSequence)description, (CharSequence)"......");
        }
        Message message = new Message.Builder().title(title).description(description).payload(xmMessage.getPayload()).restrictedPackageName(configuration.getPackageName()).passThrough(configuration.getMessageType() == null ? 0 : configuration.getMessageType()).timeToSend(XiaomiServiceImpl.getTimeToSend(configuration.getMessage().getSendTime())).notifyType(Integer.valueOf(XiaomiServiceImpl.getNotifyType(configuration.getMessage().getRing(), configuration.getMessage().getRingRaw(), configuration.getMessage().getVibrate(), configuration.getMessage().getLights()))).extra(XiaomiServiceImpl.setExtra(configuration.getPackageName(), configuration.getMessage().getRingRaw(), configuration.getMessage().getAction())).timeToLive((long)XiaomiServiceImpl.getTimeToLive(configuration.getMessage().getExpireTime())).enableFlowControl(xmMessage.getNeedFlowControl() == null ? false : xmMessage.getNeedFlowControl()).notifyId(configuration.getMessage().getCollapseId()).extra("callback", xmCallbackUrl).extra("callback.param", configuration.getPushId()).extra("callback.type", "3").build();
        return message;
    }

    private static long getTimeToSend(String time) {
        if (HussarUtils.isEmpty((Object)time)) {
            return System.currentTimeMillis();
        }
        Calendar calender = Calendar.getInstance();
        try {
            calender.setTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(time));
            if (calender.getTimeInMillis() > System.currentTimeMillis()) {
                return calender.getTimeInMillis();
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return System.currentTimeMillis();
    }

    private static int getNotifyType(int ring, String ringRaw, int vibrate, int lights) {
        if (ring == 1 && vibrate == 1 && lights == 1) {
            return -1;
        }
        if (ring == 0 && vibrate == 0 && lights == 0) {
            return 0;
        }
        if (ring == 1 && vibrate == 0 && lights == 0) {
            return 1;
        }
        if (ring == 0 && vibrate == 1 && lights == 0) {
            return 2;
        }
        if (ring == 1 && vibrate == 1 && lights == 0) {
            return 3;
        }
        if (ring == 0 && vibrate == 0 && lights == 1) {
            return 4;
        }
        if (ring == 1 && vibrate == 0 && lights == 1) {
            return 5;
        }
        if (ring == 0 && vibrate == 1 && lights == 1) {
            return 6;
        }
        return -1;
    }

    private static Map<String, String> setExtra(String packageName, String ringRaw, Action action) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (ringRaw != null && !"".equals(ringRaw)) {
            map.put("sound_uri", "android.resource://" + packageName + ringRaw);
        }
        if (action != null) {
            if (action.getType() == 0) {
                map.put("notify_effect", "1");
            } else if (action.getType() == 1) {
                map.put("notify_effect", "2");
                map.put("intent_uri", action.getActivity());
            } else if (action.getType() == 2) {
                map.put("notify_effect", "3");
                map.put("web_uri", action.getUrl());
            } else if (action.getType() == 3) {
                map.put("notify_effect", "2");
                map.put("intent_uri", action.getIntent());
            }
        }
        return map;
    }

    private static int getTimeToLive(Integer expireTime) {
        if (expireTime == null) {
            expireTime = 0;
        }
        int liveTime = 0;
        liveTime = expireTime > 0 && expireTime <= 800 ? 800 : (expireTime < 259200 ? expireTime : 259200);
        return liveTime;
    }

    static {
        log = LoggerFactory.getLogger(XiaomiServiceImpl.class);
    }
}

