/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.mobile.push.publish.service.impl;

import com.jxdinfo.hussar.mobile.push.annotation.MethodHandler;
import com.jxdinfo.hussar.mobile.push.annotation.ProType;
import com.jxdinfo.hussar.mobile.push.app.dto.ProducerConfiguration;
import com.jxdinfo.hussar.mobile.push.message.Message;
import com.jxdinfo.hussar.mobile.push.message.OppoMessage;
import com.jxdinfo.hussar.mobile.push.publish.enums.ProTypeEnum;
import com.jxdinfo.hussar.mobile.push.publish.service.PushMessage;
import com.jxdinfo.hussar.mobile.push.publish.vo.PushResult;
import com.oppo.push.server.Notification;
import com.oppo.push.server.Result;
import com.oppo.push.server.Sender;
import com.oppo.push.server.Target;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@MethodHandler
@Component
public class OppoServiceImpl
implements PushMessage {
    @Resource
    private Environment environment;

    private Notification buildMessage(ProducerConfiguration configuration) {
        Notification notification = new Notification();
        Message message = configuration.getMessage();
        OppoMessage oppoMessage = message.getOppoMessage();
        if (oppoMessage != null) {
            notification.setCallBackUrl(this.environment.getProperty("push.callbackURL.oppo"));
            notification.setCallBackParameter("pushId=" + configuration.getPushId());
            notification.setStyle(oppoMessage.getStyle());
            notification.setShowTimeType(oppoMessage.getShowTimeType());
            notification.setShowEndTime(oppoMessage.getShowEndTime());
            notification.setShowStartTime(oppoMessage.getShowStartTime());
            notification.setTimeZone(oppoMessage.getTimeZone());
            notification.setNetworkType(oppoMessage.getNetworkType());
        }
        notification.setTitle(message.getTitle());
        notification.setContent(message.getContent());
        notification.setAppMessageId(message.getRequestId());
        if (message.getAction() != null) {
            notification.setClickActionType(OppoServiceImpl.getClickActionType(message.getAction().getType()));
            if (notification.getClickActionType() == 4) {
                notification.setClickActionActivity(message.getAction().getActivity());
            }
            if (notification.getClickActionType() == 2) {
                notification.setClickActionUrl(message.getAction().getUrl());
            }
            if (notification.getClickActionType() == 5) {
                notification.setClickActionUrl(message.getAction().getIntent());
            }
        }
        notification.setActionParameters(message.getParameters());
        notification.setOffLineTtl(message.getExpireTime());
        return notification;
    }

    private static Integer getClickActionType(Integer number) {
        if (number == 1) {
            return 4;
        }
        if (number == 3) {
            return 5;
        }
        return number;
    }

    @ProType(value={ProTypeEnum.OPPO})
    public PushResult pushMessage(ProducerConfiguration configuration) {
        PushResult pushResult = new PushResult();
        try {
            Sender sender = new Sender(configuration.getProAppKey(), configuration.getProAppSecretKey());
            Notification notification = this.buildMessage(configuration);
            ArrayList<String> list = new ArrayList<String>();
            if (configuration.getTokenSet().size() == 1) {
                for (String i2 : configuration.getTokenSet()) {
                    Result result = sender.unicastNotification(notification, Target.build((String)i2));
                    if (result.getReturnCode().getCode() != 0) {
                        list.add(i2);
                    }
                    pushResult.setFailedTokens(list);
                }
            } else {
                String messageId = sender.saveNotification(notification).getMessageId();
                StringBuffer stringBuffer = new StringBuffer();
                configuration.getTokenSet().forEach(i -> {
                    stringBuffer.append(";");
                    stringBuffer.append((String)i);
                });
                Result result = sender.broadcastNotification(messageId, Target.build((String)stringBuffer.toString().substring(1)));
                List errorList = result.getBroadcastErrorResults();
                if (errorList.size() > 0) {
                    for (Result.BroadcastErrorResult error : errorList) {
                        list.add(error.getTargetValue());
                    }
                }
                pushResult.setFailedTokens(list);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            pushResult.setFailedTokens(new ArrayList(configuration.getTokenSet()));
        }
        return pushResult;
    }
}

