/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.mobile.push.app.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.common.base.PageInfo;
import com.jxdinfo.hussar.mobile.push.app.dto.DeviceTokenDto;
import com.jxdinfo.hussar.mobile.push.app.service.TokenService;
import com.jxdinfo.hussar.mobile.push.app.vo.DeviceTokenVo;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u8bbe\u5907token\u76f8\u5173\u64cd\u4f5c"})
@RestController
@RequestMapping(value={"/hussarbase/push"})
public class DeviceTokenController {
    @Resource
    private TokenService tokenService;

    @ApiOperation(value="\u6ce8\u518ctoken")
    @PostMapping(value={"/token"})
    @AuditLog(moduleName="\u6ce8\u518ctoken", eventDesc="\u6ce8\u518ctoken", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.INSERT)
    public ApiResponse<String> saveToken(@RequestBody DeviceTokenDto tokenDto) {
        return this.tokenService.saveToken(tokenDto);
    }

    @ApiOperation(value="\u5220\u9664token")
    @PostMapping(value={"/token/delete"})
    @AuditLog(moduleName="\u5220\u9664token", eventDesc="\u5220\u9664token", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.DELETE)
    public ApiResponse<Boolean> removeToken(@RequestBody DeviceTokenDto tokenDto) {
        return this.tokenService.removeToken(tokenDto);
    }

    @ApiOperation(value="\u83b7\u53d6\u8bbe\u5907token\u5217\u8868")
    @GetMapping(value={"/token"})
    @AuditLog(moduleName="\u83b7\u53d6\u8bbe\u5907token\u5217\u8868", eventDesc="\u83b7\u53d6\u8bbe\u5907token\u5217\u8868", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<Page<DeviceTokenVo>> getDeviceTokenList(@ApiParam(value="\u5206\u9875\u4fe1\u606f") PageInfo pageInfo, String appId, String proType, String device) {
        return this.tokenService.getDeviceTokenList(pageInfo, appId, proType, device);
    }
}

