/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.mobile.push.publish.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.jxdinfo.hussar.mobile.push.annotation.MethodHandler;
import com.jxdinfo.hussar.mobile.push.annotation.ProType;
import com.jxdinfo.hussar.mobile.push.app.dto.ProducerConfiguration;
import com.jxdinfo.hussar.mobile.push.message.Action;
import com.jxdinfo.hussar.mobile.push.message.VivoMessage;
import com.jxdinfo.hussar.mobile.push.publish.enums.ProTypeEnum;
import com.jxdinfo.hussar.mobile.push.publish.service.PushMessage;
import com.jxdinfo.hussar.mobile.push.publish.vo.PushResult;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.IdUtil;
import com.vivo.push.sdk.notofication.InvalidUser;
import com.vivo.push.sdk.notofication.Message;
import com.vivo.push.sdk.notofication.Result;
import com.vivo.push.sdk.notofication.TargetMessage;
import com.vivo.push.sdk.server.Sender;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@MethodHandler
@Component
public class VivoServiceImpl
implements PushMessage {
    @Resource
    private Environment environment;
    private static final Logger log = LoggerFactory.getLogger(VivoServiceImpl.class);

    private Message buildMessage(ProducerConfiguration configuration, String regId) {
        com.jxdinfo.hussar.mobile.push.message.Message message = configuration.getMessage();
        Message.Builder builder = new Message.Builder();
        if (HussarUtils.isNotEmpty((Object)regId)) {
            builder.regId(regId);
        }
        builder.title(message.getTitle()).content(message.getContent()).notifyType(this.getNotifyType(message.getRing(), message.getVibrate()).intValue()).extra(this.environment.getProperty("push.callbackUR.oppo"), "pushId=" + configuration.getPushId()).clientCustomMap((Map)JSON.parseObject((String)message.getParameters(), (TypeReference)new TypeReference<HashMap<String, String>>(){}, (Feature[])new Feature[0])).requestId(message.getRequestId());
        builder.timeToLive(message.getExpireTime() == null ? 900 : message.getExpireTime());
        if (configuration.getEnvironment() != null) {
            builder.pushMode(configuration.getEnvironment().intValue());
        }
        if (message.getVivoMessage() != null) {
            VivoMessage vivoMessage = message.getVivoMessage();
            builder.networkType(vivoMessage.getNetworkType().intValue()).classification(vivoMessage.getClassification().intValue());
        }
        if (message.getAction() != null) {
            builder.skipType(this.getSkipTyp(message.getAction().getType()).intValue()).skipContent(this.getSkipContent(message.getAction()));
        }
        return builder.build();
    }

    private Integer getNotifyType(Integer ring, Integer vibrate) {
        if (ring == 1 && vibrate == 0) {
            return 2;
        }
        if (ring == 0 && vibrate == 1) {
            return 3;
        }
        if (ring == 1 && vibrate == 1) {
            return 4;
        }
        return 1;
    }

    private Integer getSkipTyp(Integer number) {
        if (number == 0) {
            return 1;
        }
        if (number == 1) {
            return 4;
        }
        return number;
    }

    private String getSkipContent(Action action) {
        if (action.getType() == 1) {
            return action.getActivity();
        }
        if (action.getType() == 2) {
            return action.getUrl();
        }
        if (action.getType() == 3) {
            return action.getIntent();
        }
        return "";
    }

    @ProType(value={ProTypeEnum.VIVO})
    public PushResult pushMessage(ProducerConfiguration configuration) {
        if (HussarUtils.isEmpty((Object)configuration.getMessage().getRequestId())) {
            configuration.getMessage().setRequestId(IdUtil.randomUUID());
        }
        PushResult pushResult = new PushResult();
        ArrayList<String> list = new ArrayList<String>();
        try {
            Sender sender = new Sender(configuration.getProAppSecretKey());
            sender.initPool(20, 10);
            sender.setAuthToken(sender.getToken(Integer.parseInt(configuration.getProAppId()), configuration.getProAppKey()).getAuthToken());
            if (configuration.getTokenSet().size() == 1) {
                String regId = (String)new ArrayList(configuration.getTokenSet()).get(0);
                Result result = sender.sendSingle(this.buildMessage(configuration, regId));
                if (result.getResult() != 0) {
                    list.add(regId);
                }
            } else {
                TargetMessage targetMessage = new TargetMessage.Builder().taskId(sender.saveListPayLoad(this.buildMessage(configuration, "")).getTaskId()).regIds(configuration.getTokenSet()).requestId(configuration.getMessage().getRequestId()).build();
                Result result = sender.sendToList(targetMessage);
                if (result.getInvalidUsers() != null) {
                    list.addAll(result.getInvalidUsers().stream().map(InvalidUser::getUserid).collect(Collectors.toList()));
                }
            }
            pushResult.setFailedTokens(list);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            pushResult.setFailedTokens(new ArrayList(configuration.getTokenSet()));
        }
        return pushResult;
    }
}

