/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.mobile.push.publish.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.common.base.PageInfo;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.mobile.push.app.service.AppService;
import com.jxdinfo.hussar.mobile.push.publish.enums.FirmEnum;
import com.jxdinfo.hussar.mobile.push.publish.model.PushRecordDO;
import com.jxdinfo.hussar.mobile.push.publish.model.PushRecordDetailDO;
import com.jxdinfo.hussar.mobile.push.publish.service.PushRecordService;
import com.jxdinfo.hussar.mobile.push.publish.vo.RecordStatisticVO;
import com.jxdinfo.hussar.mobile.push.publish.vo.RecordVO;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.DateUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.mongodb.client.result.UpdateResult;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.stereotype.Service;

@Service
public class PushRecordServiceImpl
implements PushRecordService {
    private static final String PUSH_RECORD_TITLE = "title";
    private static final String PUSH_RECORD_APPID = "appId";
    private static final String PUSH_RECORD_CREATETIME = "createTime";
    private static final String PUSH_RECORD_SENDTIME = "sendTime";
    private static final String PUSH_RECORD_PUSHID = "pushId";
    @Resource
    private MongoTemplate mongoTemplate;
    @Resource
    private AppService appService;

    public ApiResponse<Page<RecordVO>> getPushRecordPage(PageInfo pageInfo, String title, String startTime, String endTime, String appId) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>(9);
        paramMap.put(PUSH_RECORD_TITLE, title);
        paramMap.put("startTime", startTime);
        paramMap.put("endTime", endTime);
        paramMap.put(PUSH_RECORD_APPID, appId);
        paramMap.put("pageSize", pageInfo.getSize());
        paramMap.put("pageNum", pageInfo.getCurrent());
        try {
            if (appId == null || "".equals(appId)) {
                Long userId = BaseSecurityUtil.getUser().getId();
                List appIdList = this.appService.getAppIdList(userId);
                HashSet appIds = new HashSet(appIdList);
                paramMap.put("appIds", appIds);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return ApiResponse.fail((String)"\u83b7\u53d6\u63a8\u9001\u8bb0\u5f55\u5217\u8868\u5931\u8d25");
        }
        title = paramMap.get(PUSH_RECORD_TITLE) == null ? "" : paramMap.get(PUSH_RECORD_TITLE).toString();
        startTime = paramMap.get("startTime") == null ? "" : paramMap.get("startTime").toString();
        endTime = paramMap.get("endTime") == null ? "" : paramMap.get("endTime").toString();
        appId = paramMap.get(PUSH_RECORD_APPID) == null ? "" : paramMap.get(PUSH_RECORD_APPID).toString();
        int pageSize = paramMap.get("pageSize") == null ? 20 : Integer.parseInt(paramMap.get("pageSize").toString());
        int pageNum = paramMap.get("pageNum") == null ? 1 : Integer.parseInt(paramMap.get("pageNum").toString());
        Page page = new Page();
        page.setSize((long)pageSize);
        page.setCurrent((long)pageNum);
        Criteria criteria = new Criteria();
        if (HussarUtils.isNotEmpty((Object)title)) {
            Pattern searchPattern = Pattern.compile("^.*" + title + ".*$", 2);
            criteria.and(PUSH_RECORD_TITLE).regex(searchPattern);
        }
        if (HussarUtils.isNotEmpty((Object)appId)) {
            criteria.and(PUSH_RECORD_APPID).is((Object)appId);
        } else {
            Set appIds = paramMap.get("appIds") == null ? new HashSet() : (Set)paramMap.get("appIds");
            criteria.and(PUSH_RECORD_APPID).in(appIds);
        }
        if (HussarUtils.isNotEmpty((Object)startTime) && HussarUtils.isNotEmpty((Object)endTime)) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)PUSH_RECORD_SENDTIME).gte((Object)DateUtil.parse((String)startTime, (String)"yyyy-MM-dd HH:mm:ss").getTime()).lte((Object)DateUtil.parse((String)endTime, (String)"yyyy-MM-dd HH:mm:ss").getTime())});
        } else if (!HussarUtils.isNotEmpty((Object)startTime) && HussarUtils.isNotEmpty((Object)endTime)) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)PUSH_RECORD_SENDTIME).lte((Object)DateUtil.parse((String)endTime, (String)"yyyy-MM-dd HH:mm:ss").getTime())});
        } else if (HussarUtils.isNotEmpty((Object)startTime) && !HussarUtils.isNotEmpty((Object)endTime)) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)PUSH_RECORD_SENDTIME).gte((Object)DateUtil.parse((String)startTime, (String)"yyyy-MM-dd HH:mm:ss").getTime())});
        }
        List recordDOList = this.mongoTemplate.find(new Query((CriteriaDefinition)criteria).with(Sort.by((Sort.Order[])new Sort.Order[]{Sort.Order.desc((String)PUSH_RECORD_CREATETIME)})).skip(page.getSize() * (page.getCurrent() - 1L)).limit((int)page.getSize()), PushRecordDO.class);
        ArrayList recordVOList = new ArrayList();
        recordDOList.forEach(recordDO -> {
            RecordVO recordVO = new RecordVO();
            BeanUtils.copyProperties((Object)recordDO, (Object)recordVO);
            recordVO.setSendTime(this.longToStr(recordDO.getSendTime()));
            recordVO.setCreateTime(this.longToStr(recordDO.getCreateTime()));
            recordVO.setModifyTime(this.longToStr(recordDO.getModifyTime()));
            recordVOList.add(recordVO);
        });
        page.setRecords(recordVOList);
        page.setTotal(this.mongoTemplate.count(new Query((CriteriaDefinition)criteria), PushRecordDO.class));
        return ApiResponse.success((Object)page);
    }

    public ApiResponse<RecordVO> getPushRecordDetail(String pushId) {
        RecordVO recordVO = new RecordVO();
        Criteria criteria = new Criteria();
        criteria.and(PUSH_RECORD_PUSHID).is((Object)pushId);
        List recordDOList = this.mongoTemplate.find(new Query((CriteriaDefinition)criteria), PushRecordDO.class);
        if (recordDOList != null && recordDOList.size() > 0) {
            PushRecordDO pushRecordDO = (PushRecordDO)recordDOList.get(0);
            BeanUtils.copyProperties((Object)pushRecordDO, (Object)recordVO);
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            recordVO.setCreateTime(simpleDateFormat.format(new Date(pushRecordDO.getCreateTime())));
            recordVO.setModifyTime(simpleDateFormat.format(pushRecordDO.getModifyTime()));
            recordVO.setSendTime(simpleDateFormat.format(pushRecordDO.getSendTime()));
        }
        return ApiResponse.success((Object)recordVO);
    }

    public boolean updateArrivedPushRecordDetail(String pushId, List<String> tokenList) {
        Criteria criteria = new Criteria();
        criteria.and("proToken").in(tokenList);
        criteria.and(PUSH_RECORD_PUSHID).is((Object)pushId);
        Update update = new Update();
        update.set("arrive", (Object)1);
        update.set("modifyTime", (Object)DateUtil.now());
        UpdateResult result = this.mongoTemplate.updateMulti(new Query((CriteriaDefinition)criteria), (UpdateDefinition)update, PushRecordDetailDO.class);
        return result.getModifiedCount() > 0L;
    }

    public boolean updateApnsStatusPushRecordDetail(String pushId, String token, int type) {
        Criteria criteria = new Criteria();
        criteria.and("token").is((Object)token);
        criteria.and(PUSH_RECORD_PUSHID).is((Object)pushId);
        Update update = new Update();
        if (type == 1) {
            update.set("click", (Object)1);
        } else if (type == 2) {
            update.set("arrive", (Object)1);
        }
        update.set("modifyTime", (Object)DateUtil.now());
        UpdateResult result = this.mongoTemplate.updateFirst(new Query((CriteriaDefinition)criteria), (UpdateDefinition)update, PushRecordDetailDO.class);
        return result.getModifiedCount() > 0L;
    }

    public boolean updateClickedPushRecordDetail(String pushId, List<String> tokenList) {
        Criteria criteria = new Criteria();
        criteria.and("proToken").in(tokenList);
        criteria.and(PUSH_RECORD_PUSHID).is((Object)pushId);
        Update update = new Update();
        update.set("click", (Object)1);
        update.set("modifyTime", (Object)DateUtil.now());
        UpdateResult result = this.mongoTemplate.updateMulti(new Query((CriteriaDefinition)criteria), (UpdateDefinition)update, PushRecordDetailDO.class);
        return result.getModifiedCount() > 0L;
    }

    public ApiResponse<List<RecordStatisticVO>> getPushStatistic(String pushId) {
        Criteria criteria = new Criteria();
        criteria.and(PUSH_RECORD_PUSHID).is((Object)pushId);
        List recordList = this.mongoTemplate.find(new Query((CriteriaDefinition)criteria), PushRecordDetailDO.class);
        ArrayList<RecordStatisticVO> statisticList = new ArrayList<RecordStatisticVO>();
        List hwRecordList = recordList.stream().filter(i -> i.getProType().intValue() == FirmEnum.\u534e\u4e3a.ordinal()).collect(Collectors.toList());
        Long hwSuccessNum = hwRecordList.stream().filter(i -> i.getDataStatus() == 1).count();
        Long hwArriveNum = hwRecordList.stream().filter(i -> i.getArrive() != null && i.getArrive() == 1).count();
        Long hwClickNum = hwRecordList.stream().filter(i -> i.getClick() != null && i.getClick() == 1).count();
        RecordStatisticVO hwStatisticVO = new RecordStatisticVO();
        hwStatisticVO.setProType(Integer.valueOf(FirmEnum.\u534e\u4e3a.ordinal()));
        hwStatisticVO.setProTypeName(FirmEnum.\u534e\u4e3a);
        hwStatisticVO.setPlanNum(Integer.valueOf(hwRecordList.size()));
        hwStatisticVO.setSuccessNum(Integer.valueOf(hwSuccessNum.intValue()));
        hwStatisticVO.setArrivedNum(Integer.valueOf(hwArriveNum.intValue()));
        hwStatisticVO.setClickNum(Integer.valueOf(hwClickNum.intValue()));
        statisticList.add(hwStatisticVO);
        List xmRecordList = recordList.stream().filter(i -> i.getProType().intValue() == FirmEnum.\u5c0f\u7c73.ordinal()).collect(Collectors.toList());
        Long xmSuccessNum = xmRecordList.stream().filter(i -> i.getDataStatus() == 1).count();
        Long xmArriveNum = xmRecordList.stream().filter(i -> i.getArrive() != null && i.getArrive() == 1).count();
        Long xmClickNum = xmRecordList.stream().filter(i -> i.getClick() != null && i.getClick() == 1).count();
        RecordStatisticVO xmStatisticVO = new RecordStatisticVO();
        xmStatisticVO.setProType(Integer.valueOf(FirmEnum.\u5c0f\u7c73.ordinal()));
        xmStatisticVO.setProTypeName(FirmEnum.\u5c0f\u7c73);
        xmStatisticVO.setPlanNum(Integer.valueOf(xmRecordList.size()));
        xmStatisticVO.setSuccessNum(Integer.valueOf(xmSuccessNum.intValue()));
        xmStatisticVO.setArrivedNum(Integer.valueOf(xmArriveNum.intValue()));
        xmStatisticVO.setClickNum(Integer.valueOf(xmClickNum.intValue()));
        statisticList.add(xmStatisticVO);
        List mzRecordList = recordList.stream().filter(i -> i.getProType().intValue() == FirmEnum.\u9b45\u65cf.ordinal()).collect(Collectors.toList());
        Long mzSuccessNum = mzRecordList.stream().filter(i -> i.getDataStatus() == 1).count();
        Long mzArriveNum = mzRecordList.stream().filter(i -> i.getArrive() != null && i.getArrive() == 1).count();
        Long mzClickNum = mzRecordList.stream().filter(i -> i.getClick() != null && i.getClick() == 1).count();
        RecordStatisticVO mzStatisticVO = new RecordStatisticVO();
        mzStatisticVO.setProType(Integer.valueOf(FirmEnum.\u9b45\u65cf.ordinal()));
        mzStatisticVO.setProTypeName(FirmEnum.\u9b45\u65cf);
        mzStatisticVO.setPlanNum(Integer.valueOf(mzRecordList.size()));
        mzStatisticVO.setSuccessNum(Integer.valueOf(mzSuccessNum.intValue()));
        mzStatisticVO.setArrivedNum(Integer.valueOf(mzArriveNum.intValue()));
        mzStatisticVO.setClickNum(Integer.valueOf(mzClickNum.intValue()));
        statisticList.add(mzStatisticVO);
        List vivoRecordList = recordList.stream().filter(i -> i.getProType().intValue() == FirmEnum.vivo.ordinal()).collect(Collectors.toList());
        Long vivoSuccessNum = vivoRecordList.stream().filter(i -> i.getDataStatus() == 1).count();
        Long vivoArriveNum = vivoRecordList.stream().filter(i -> i.getArrive() != null && i.getArrive() == 1).count();
        Long vivoClickNum = vivoRecordList.stream().filter(i -> i.getClick() != null && i.getClick() == 1).count();
        RecordStatisticVO vivoStatisticVO = new RecordStatisticVO();
        vivoStatisticVO.setProType(Integer.valueOf(FirmEnum.vivo.ordinal()));
        vivoStatisticVO.setProTypeName(FirmEnum.vivo);
        vivoStatisticVO.setPlanNum(Integer.valueOf(vivoRecordList.size()));
        vivoStatisticVO.setSuccessNum(Integer.valueOf(vivoSuccessNum.intValue()));
        vivoStatisticVO.setArrivedNum(Integer.valueOf(vivoArriveNum.intValue()));
        vivoStatisticVO.setClickNum(Integer.valueOf(vivoClickNum.intValue()));
        statisticList.add(vivoStatisticVO);
        List oppoRecordList = recordList.stream().filter(i -> i.getProType().intValue() == FirmEnum.OPPO.ordinal()).collect(Collectors.toList());
        Long oppoSuccessNum = oppoRecordList.stream().filter(i -> i.getDataStatus() == 1).count();
        Long oppoArriveNum = oppoRecordList.stream().filter(i -> i.getArrive() != null && i.getArrive() == 1).count();
        Long oppoClickNum = oppoRecordList.stream().filter(i -> i.getClick() != null && i.getClick() == 1).count();
        RecordStatisticVO oppoStatisticVO = new RecordStatisticVO();
        oppoStatisticVO.setProType(Integer.valueOf(FirmEnum.OPPO.ordinal()));
        oppoStatisticVO.setProTypeName(FirmEnum.OPPO);
        oppoStatisticVO.setPlanNum(Integer.valueOf(oppoRecordList.size()));
        oppoStatisticVO.setSuccessNum(Integer.valueOf(oppoSuccessNum.intValue()));
        oppoStatisticVO.setArrivedNum(Integer.valueOf(oppoArriveNum.intValue()));
        oppoStatisticVO.setClickNum(Integer.valueOf(oppoClickNum.intValue()));
        statisticList.add(oppoStatisticVO);
        List apnsRecordList = recordList.stream().filter(i -> i.getProType().intValue() == FirmEnum.\u82f9\u679c.ordinal()).collect(Collectors.toList());
        Long apnsSuccessNum = apnsRecordList.stream().filter(i -> i.getDataStatus() == 1).count();
        Long apnsArriveNum = apnsRecordList.stream().filter(i -> i.getArrive() != null && i.getArrive() == 1).count();
        Long apnsClickNum = apnsRecordList.stream().filter(i -> i.getClick() != null && i.getClick() == 1).count();
        RecordStatisticVO apnsStatisticVO = new RecordStatisticVO();
        apnsStatisticVO.setProType(Integer.valueOf(FirmEnum.\u82f9\u679c.ordinal()));
        apnsStatisticVO.setProTypeName(FirmEnum.\u82f9\u679c);
        apnsStatisticVO.setPlanNum(Integer.valueOf(apnsRecordList.size()));
        apnsStatisticVO.setSuccessNum(Integer.valueOf(apnsSuccessNum.intValue()));
        apnsStatisticVO.setArrivedNum(Integer.valueOf(apnsArriveNum.intValue()));
        apnsStatisticVO.setClickNum(Integer.valueOf(apnsClickNum.intValue()));
        statisticList.add(apnsStatisticVO);
        return ApiResponse.success(statisticList);
    }

    private String longToStr(Long time) {
        if (time == null) {
            return "";
        }
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(time);
    }
}

