/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.mobile.push.publish.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.common.base.PageInfo;
import com.jxdinfo.hussar.mobile.push.message.PushApp;
import com.jxdinfo.hussar.mobile.push.publish.service.PushRecordService;
import com.jxdinfo.hussar.mobile.push.publish.service.PushService;
import com.jxdinfo.hussar.mobile.push.publish.vo.RecordStatisticVO;
import com.jxdinfo.hussar.mobile.push.publish.vo.RecordVO;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u63a8\u9001\u76f8\u5173\u64cd\u4f5c"})
@RestController
@RequestMapping(value={"/hussarbase/push"})
public class PushController {
    @Resource
    private PushRecordService pushRecordService;
    @Resource
    private PushService pushService;

    @ApiOperation(value="\u63a8\u9001\u901a\u77e5")
    @PostMapping(value={"/pushMessage"})
    public ApiResponse<Boolean> pushMessage(@RequestBody PushApp pushApp) {
        return this.pushService.sendConfiguration(pushApp);
    }

    @ApiOperation(value="\u63a8\u9001\u901a\u77e5\uff08\u540e\u53f0\uff09")
    @PostMapping(value={"/manager/{appId}"})
    public ApiResponse<Boolean> pushManager(@RequestBody PushApp pushApp, @PathVariable(value="appId") Long appId) {
        pushApp.setAppId(appId);
        return this.pushService.sendConfiguration(pushApp);
    }

    @ApiOperation(value="\u83b7\u53d6\u63a8\u9001\u8bb0\u5f55\u5217\u8868")
    @GetMapping(value={"/getPushRecord"})
    public ApiResponse<Page<RecordVO>> getPushRecord(PageInfo pageInfo, @RequestParam(required=false) @ApiParam(value="\u6807\u9898") String title, @RequestParam(required=false) @ApiParam(value="\u5f00\u59cb\u65f6\u95f4") String startTime, @RequestParam(required=false) @ApiParam(value="\u7ed3\u675f\u65f6\u95f4") String endTime, @RequestParam(required=false) @ApiParam(value="\u5e94\u7528appId") String appId) {
        return this.pushRecordService.getPushRecordPage(pageInfo, title, startTime, endTime, appId);
    }

    @ApiOperation(value="\u83b7\u53d6\u63a8\u9001\u8bb0\u5f55\u5217\u8868(\u540e\u53f0\u7ba1\u7406)")
    @GetMapping(value={"/manager"})
    public ApiResponse<Page<RecordVO>> getPushRecordManager(PageInfo pageInfo, @RequestParam(required=false) @ApiParam(value="\u6807\u9898") String title, @RequestParam(required=false) @ApiParam(value="\u5f00\u59cb\u65f6\u95f4") String startTime, @RequestParam(required=false) @ApiParam(value="\u7ed3\u675f\u65f6\u95f4") String endTime, @RequestParam(required=false) @ApiParam(value="\u5e94\u7528appId") String appId) {
        return this.pushRecordService.getPushRecordPage(pageInfo, title, startTime, endTime, appId);
    }

    @ApiOperation(value="\u83b7\u53d6\u63a8\u9001\u660e\u7ec6")
    @GetMapping(value={"/getPushRecordDetail"})
    public ApiResponse<RecordVO> getPushRecordDetail(@RequestParam @ApiParam(value="\u63a8\u9001\u8bb0\u5f55id") String pushId) {
        return this.pushRecordService.getPushRecordDetail(pushId);
    }

    @ApiOperation(value="\u83b7\u53d6\u660e\u7ec6\u7edf\u8ba1")
    @GetMapping(value={"/getPushStatistic"})
    public ApiResponse<List<RecordStatisticVO>> getPushStatistic(@RequestParam @ApiParam(value="\u63a8\u9001\u8bb0\u5f55id") String pushId) {
        return this.pushRecordService.getPushStatistic(pushId);
    }

    @ApiOperation(value="\u5c0f\u7c73\u63a8\u9001\u56de\u8c03")
    @PostMapping(value={"/xmCallback"})
    public void xmCallback(@RequestBody String data, HttpServletRequest request) {
        JSONObject clickInfo;
        if (HussarUtils.isEmpty((Object)data)) {
            data = request.getParameter("data");
        }
        String bodyStr = data;
        System.out.println("\u5c0f\u7c73\u56de\u8c03\u8fd4\u56de\uff1a" + bodyStr);
        JSONObject jsonObject = JSONObject.parseObject((String)bodyStr);
        JSONObject arriveInfo = JSONObject.parseObject((String)jsonObject.getString("msgId1"));
        String pushId = arriveInfo.getString("param") == null ? "" : arriveInfo.getString("param");
        String targets = arriveInfo.getString("targets") == null ? "" : arriveInfo.getString("targets");
        List<String> arriveList = Arrays.asList(targets.split(","));
        if (arriveList.size() > 0) {
            this.pushRecordService.updateArrivedPushRecordDetail(pushId, arriveList);
        }
        String pushId2 = (clickInfo = JSONObject.parseObject((String)jsonObject.getString("msgId2"))).getString("param") == null ? "" : clickInfo.getString("param");
        String clickTargets = clickInfo.getString("targets") == null ? "" : clickInfo.getString("targets");
        List<String> clickList = Arrays.asList(clickTargets.split(","));
        if (clickList.size() > 0) {
            this.pushRecordService.updateClickedPushRecordDetail(pushId2, clickList);
        }
    }

    @ApiOperation(value="\u9b45\u65cf\u63a8\u9001\u56de\u8c03")
    @PostMapping(value={"/mzCallback"})
    public void mzCallback(@RequestBody String cb, HttpServletRequest request) {
        if (HussarUtils.isEmpty((Object)cb)) {
            cb = request.getParameter("cb");
        }
        String bodyStr = cb;
        System.out.println("\u9b45\u65cf\u56de\u8c03\u8fd4\u56de\uff1a" + bodyStr);
        JSONObject jsonObject = JSONObject.parseObject((String)bodyStr);
        Collection valCollection = jsonObject.values();
        valCollection.forEach(n -> {
            JSONObject valJsonObject = JSONObject.parseObject((String)n.toString());
            String pushId = valJsonObject.getString("param");
            int type = valJsonObject.getInteger("type");
            JSONArray tokenJson = valJsonObject.getJSONArray("targets");
            List tokenList = tokenJson.toJavaList(String.class);
            if (type == 1) {
                this.pushRecordService.updateArrivedPushRecordDetail(pushId, tokenList);
            } else if (type == 2) {
                this.pushRecordService.updateClickedPushRecordDetail(pushId, tokenList);
            }
        });
    }

    @ApiOperation(value="\u534e\u4e3a\u63a8\u9001\u56de\u8c03")
    @PostMapping(value={"/hwCallback"})
    public Object hwCallback(HttpServletRequest request) {
        HashMap<String, String> resultMap = new HashMap<String, String>(4);
        String bodyStr = request.getParameter("statuses");
        System.out.println("\u534e\u4e3a\u56de\u8c03\u8fd4\u56de\uff1a" + bodyStr);
        try {
            JSONArray jsonArray = JSONArray.parseArray((String)bodyStr);
            if (jsonArray.size() > 0) {
                for (Object o : jsonArray) {
                    JSONObject objJson = (JSONObject)o;
                    Integer status = objJson.getInteger("status");
                    if (status != 0) continue;
                    String biTag = objJson.getString("biTag");
                    String token = objJson.getString("token");
                    ArrayList<String> tokens = new ArrayList<String>();
                    tokens.add(token);
                    this.pushRecordService.updateArrivedPushRecordDetail(biTag, tokens);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            resultMap.put("errno", "500");
            resultMap.put("errmsg", "\u66f4\u65b0\u5931\u8d25");
        }
        return resultMap;
    }

    @ApiOperation(value="\u82f9\u679c\u63a8\u9001\u56de\u8c03")
    @PostMapping(value={"/apnsCallback"})
    public ApiResponse<Boolean> apnsCallback(@RequestBody Map<String, Object> parameters) {
        boolean flag;
        String token = parameters.get("token") == null ? "" : parameters.get("token").toString();
        String pushId = parameters.get("pushId") == null ? "" : parameters.get("pushId").toString();
        int type = parameters.get("type") == null ? 1 : Integer.parseInt(parameters.get("type").toString());
        try {
            flag = this.pushRecordService.updateApnsStatusPushRecordDetail(pushId, token, type);
        }
        catch (Exception e) {
            e.printStackTrace();
            return ApiResponse.fail((String)"\u56de\u8c03\u5931\u8d25");
        }
        return ApiResponse.success((Object)flag);
    }
}

