/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.mobile.push.publish.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.mail.core.collection.CollUtil;
import com.jxdinfo.hussar.mail.core.util.StrUtil;
import com.jxdinfo.hussar.mobile.push.annotation.MethodHandler;
import com.jxdinfo.hussar.mobile.push.annotation.ProType;
import com.jxdinfo.hussar.mobile.push.app.dto.ProducerConfiguration;
import com.jxdinfo.hussar.mobile.push.message.Action;
import com.jxdinfo.hussar.mobile.push.message.HwMessage;
import com.jxdinfo.hussar.mobile.push.publish.enums.ProTypeEnum;
import com.jxdinfo.hussar.mobile.push.publish.service.PushMessage;
import com.jxdinfo.hussar.mobile.push.publish.vo.PushResult;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.push.huawei.android.AndroidNotification;
import com.jxdinfo.push.huawei.android.BadgeNotification;
import com.jxdinfo.push.huawei.android.ClickAction;
import com.jxdinfo.push.huawei.android.Color;
import com.jxdinfo.push.huawei.android.LightSettings;
import com.jxdinfo.push.huawei.exception.HuaweiMesssagingException;
import com.jxdinfo.push.huawei.message.AndroidConfig;
import com.jxdinfo.push.huawei.message.Message;
import com.jxdinfo.push.huawei.message.Notification;
import com.jxdinfo.push.huawei.messaging.HuaweiApp;
import com.jxdinfo.push.huawei.messaging.HuaweiMessaging;
import com.jxdinfo.push.huawei.model.Importance;
import com.jxdinfo.push.huawei.model.Visibility;
import com.jxdinfo.push.huawei.response.SendResponse;
import com.jxdinfo.push.huawei.util.InitAppUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@MethodHandler
public class HuaweiServiceImpl
implements PushMessage {
    private static final Logger log = LoggerFactory.getLogger(HuaweiServiceImpl.class);

    @ProType(value={ProTypeEnum.HUAWEI})
    public PushResult pushMessage(ProducerConfiguration configuration) {
        PushResult resResult = new PushResult();
        HuaweiApp app = InitAppUtils.initializeApp((String)configuration.getProAppId(), (String)configuration.getProAppSecretKey());
        HuaweiMessaging huaweiMessaging = HuaweiMessaging.getInstance((HuaweiApp)app);
        ArrayList decodeTokenList = new ArrayList(configuration.getTokenSet());
        com.jxdinfo.hussar.mobile.push.message.Message xlxMessage = configuration.getMessage();
        String title = xlxMessage.getTitle();
        if (StrUtil.length((CharSequence)title) > 40) {
            title = StrUtil.sub((CharSequence)title, (int)0, (int)34);
            title = StrUtil.addSuffixIfNot((CharSequence)title, (CharSequence)"......");
        }
        xlxMessage.setTitle(title);
        String description = xlxMessage.getContent();
        if (StrUtil.length((CharSequence)description) > 80) {
            description = StrUtil.sub((CharSequence)description, (int)0, (int)74);
            description = StrUtil.addSuffixIfNot((CharSequence)description, (CharSequence)"......");
        }
        xlxMessage.setContent(description);
        try {
            Notification notification = Notification.builder().setTitle(xlxMessage.getTitle()).setBody(xlxMessage.getContent()).build();
            AndroidNotification androidNotification = HuaweiServiceImpl.createAndroidNotification(configuration);
            AndroidConfig androidConfig = AndroidConfig.builder().setCollapseKey(Integer.valueOf(-1)).setTtl(HuaweiServiceImpl.getTtl(xlxMessage.getExpireTime())).setNotification(androidNotification).setBiTag(configuration.getPushId()).setData(xlxMessage.getCustomContent()).build();
            Message.Builder builder = Message.builder().setNotification(notification).setAndroidConfig(androidConfig);
            if (decodeTokenList != null && decodeTokenList.size() > 1) {
                builder.addAllToken(decodeTokenList);
            } else {
                builder.addToken((String)decodeTokenList.get(0));
            }
            Message message = builder.build();
            SendResponse response = huaweiMessaging.sendMessage(message);
            if (Integer.valueOf(response.getCode()) == 200 || Integer.valueOf(response.getCode()) == 80000000) {
                log.info("\u534e\u4e3a\u5168\u90e8\u63a8\u9001\u6210\u529f");
                resResult.setSuccessTokens(decodeTokenList);
            } else if (Integer.valueOf(response.getCode()) == 80100000) {
                log.info("\u534e\u4e3a\u90e8\u5206\u63a8\u9001\u6210\u529f");
                JSONObject jsonObject = JSONObject.parseObject((String)response.getMsg());
                resResult.setFailedTokens(JSONObject.parseArray((String)jsonObject.getString("illegal_tokens"), String.class));
            } else {
                log.error(response.getMsg());
                resResult.setFailedTokens(decodeTokenList);
            }
        }
        catch (HuaweiMesssagingException e) {
            e.printStackTrace();
            log.error(e.getMessage());
            resResult.setFailedTokens(decodeTokenList);
        }
        return resResult;
    }

    private static AndroidNotification createAndroidNotification(ProducerConfiguration configuration) {
        HwMessage hwMessage = configuration.getMessage().getHwMessage() == null ? new HwMessage() : configuration.getMessage().getHwMessage();
        JSONObject multiLangKey = new JSONObject();
        LightSettings lightSettings = LightSettings.builder().setColor(Color.builder().setAlpha(Float.valueOf(0.0f)).setRed(Float.valueOf(0.0f)).setBlue(Float.valueOf(1.0f)).setGreen(Float.valueOf(1.0f)).build()).setLightOnDuration("3.5").setLightOffDuration("5S").build();
        AndroidNotification androidNotification = AndroidNotification.builder().setSound(configuration.getMessage().getRingRaw()).setDefaultSound(HuaweiServiceImpl.getDefaultSound(configuration.getMessage().getRingRaw())).setTag(hwMessage.getTag()).setClickAction(HuaweiServiceImpl.getClickAction(configuration.getMessage().getAction() == null ? new Action() : configuration.getMessage().getAction())).setChannelId(hwMessage.getChannelId()).setNotifySummary(hwMessage.getNotifySummary()).setMultiLangkey(multiLangKey).setStyle(hwMessage.getStyle()).setBigTitle(hwMessage.getBigTitle()).setBigBody(hwMessage.getBigBody()).setAutoClear(HuaweiServiceImpl.getAutoClearTime(configuration.getMessage().getClearable())).setNotifyId(configuration.getMessage().getCollapseId()).setGroup(configuration.getMessage().getThreadId()).setImportance("".equals(hwMessage.getImportance()) ? Importance.NORMAL.getValue() : hwMessage.getImportance()).setLightSettings(lightSettings).setBadge(HuaweiServiceImpl.getBadgeNotification(configuration.getMessage().getBadge())).setVisibility("".equals(hwMessage.getVisibility()) ? Visibility.PUBLIC.getValue() : hwMessage.getVisibility()).setForegroundShow(Boolean.valueOf(hwMessage.getForegroundShow()).booleanValue()).setForegroundShow(false).setTitle(configuration.getMessage().getTitle()).setBody(configuration.getMessage().getContent()).setUseDefaultLight(HuaweiServiceImpl.getBooleanValue(configuration.getMessage().getLights())).setUseDefaultVibrate(HuaweiServiceImpl.getBooleanValue(configuration.getMessage().getVibrate())).setIcon(hwMessage.getIcon()).addAllBodyLocArgs(hwMessage.getBodyLocArgs() == null ? new ArrayList() : Arrays.asList(hwMessage.getBodyLocArgs())).addAllTitleLocArgs(hwMessage.getTitleLocArgs() == null ? new ArrayList() : Arrays.asList(hwMessage.getTitleLocArgs())).setImage(hwMessage.getImage()).setTicker(hwMessage.getTicker()).setAutoCancel(hwMessage.getAutoCancel().booleanValue()).setWhen(hwMessage.getWhen()).addAllVibrateConfig((List)CollUtil.newArrayList((Object[])new String[]{"0.035S", "0.020S"})).build();
        return androidNotification;
    }

    private static boolean getDefaultSound(String ringRaw) {
        return !HussarUtils.isNotEmpty((Object)ringRaw);
    }

    private static boolean getBooleanValue(Integer number) {
        return number == null || number == 1;
    }

    private static String getTtl(Integer time) {
        String expireTime = "86400";
        if (time == null || time == 0) {
            expireTime = "86400";
        } else if (time < 800) {
            expireTime = "800";
        } else if (time < 259200) {
            expireTime = time.toString();
        } else if (time >= 259200) {
            expireTime = "259200";
        }
        return expireTime;
    }

    private static Integer getAutoClearTime(int clearable) {
        Integer time = null;
        time = clearable == 1 ? Integer.valueOf(86400000) : Integer.valueOf(259200000);
        return time;
    }

    private static BadgeNotification getBadgeNotification(Integer badge) {
        BadgeNotification badgeNotification = null;
        badgeNotification = badge != null && badge > 0 ? BadgeNotification.builder().setAddNum(badge).setBadgeClass("Classic").build() : BadgeNotification.builder().setAddNum(Integer.valueOf(1)).setBadgeClass("Classic").build();
        return badgeNotification;
    }

    private static ClickAction getClickAction(Action action) {
        ClickAction clickAction = null;
        if (action.getType() == null || action.getType() == 0) {
            clickAction = ClickAction.builder().setType(Integer.valueOf(3)).build();
        } else if (action.getType() == 1) {
            clickAction = ClickAction.builder().setType(Integer.valueOf(1)).setAction(action.getActivity()).build();
        } else if (action.getType() == 2) {
            clickAction = ClickAction.builder().setType(Integer.valueOf(2)).setUrl(action.getUrl()).build();
        } else if (action.getType() == 3) {
            clickAction = ClickAction.builder().setType(Integer.valueOf(1)).setIntent(action.getIntent()).build();
        }
        return clickAction;
    }
}

