/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.mobile.push.handler;

import com.jxdinfo.hussar.mobile.push.annotation.MethodHandler;
import com.jxdinfo.hussar.mobile.push.annotation.ProType;
import com.jxdinfo.hussar.mobile.push.handler.MethodMapping;
import com.jxdinfo.hussar.mobile.push.publish.enums.ProTypeEnum;
import com.jxdinfo.hussar.mobile.push.publish.vo.PushResult;
import com.jxdinfo.hussar.mobile.push.util.ApplicationContextProvider;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component
public class DetectMethodAnnotation
implements ApplicationContextAware,
InitializingBean {
    private ApplicationContext applicationContext;
    private HashMap<String, List<MethodMapping>> classMethodMap = new HashMap();

    public void afterPropertiesSet() throws Exception {
        Map methodHandlerMap = this.applicationContext.getBeansWithAnnotation(MethodHandler.class);
        methodHandlerMap.forEach((k, v) -> {
            Class<?> clazz = v.getClass();
            Method[] methods = clazz.getDeclaredMethods();
            ArrayList<MethodMapping> methodMappings = new ArrayList<MethodMapping>();
            for (Method method : methods) {
                if (!method.isAnnotationPresent(ProType.class)) continue;
                ProType nameAnnotation = method.getAnnotation(ProType.class);
                methodMappings.add(new MethodMapping(nameAnnotation.value(), method));
            }
            if (!methodMappings.isEmpty()) {
                this.classMethodMap.put(clazz.getName(), methodMappings);
            }
        });
    }

    public PushResult execute(ProTypeEnum proType, Object ... parameters) throws Exception {
        for (String k : this.classMethodMap.keySet()) {
            List<MethodMapping> methodMappings = this.classMethodMap.get(k);
            for (MethodMapping methodMapping : methodMappings) {
                ProTypeEnum[] names = methodMapping.names;
                Class<?> cls = Class.forName(k);
                if (!Arrays.asList(names).contains(proType)) continue;
                return (PushResult)methodMapping.method.invoke(ApplicationContextProvider.getBean(cls), parameters);
            }
        }
        return new PushResult();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

