/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.mobile.publish.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.mobile.publish.config.MobilePublishConfigProperty;
import com.jxdinfo.hussar.mobile.publish.dao.PublishAppMapper;
import com.jxdinfo.hussar.mobile.publish.dao.PublishAppVersionMapper;
import com.jxdinfo.hussar.mobile.publish.dao.PublishDownloadRecordMapper;
import com.jxdinfo.hussar.mobile.publish.model.PublishRecord;
import com.jxdinfo.hussar.mobile.publish.model.PublishVersion;
import com.jxdinfo.hussar.mobile.publish.service.PublishVersionService;
import com.jxdinfo.hussar.mobile.publish.vo.PublishVersionVo;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.mobile.publish.service.impl.publishVersionServiceImpl")
public class PublishVersionServiceImpl
extends HussarServiceImpl<PublishAppVersionMapper, PublishVersion>
implements PublishVersionService {
    @Resource
    private PublishAppVersionMapper publishAppVersionMapper;
    @Resource
    private PublishAppMapper publishAppMapper;
    @Resource
    private PublishDownloadRecordMapper downloadRecordMapper;

    public List<PublishVersionVo> queryAppVersion(Long appId) {
        List<PublishVersionVo> versionVos = this.publishAppVersionMapper.queryAppVersion(appId);
        for (PublishVersionVo versionVo : versionVos) {
            LambdaQueryWrapper recordQW = new LambdaQueryWrapper();
            recordQW.eq(PublishRecord::getAppId, (Object)versionVo.getAppId());
            recordQW.eq(PublishRecord::getVersionId, (Object)versionVo.getId());
            Integer download = Integer.valueOf(this.downloadRecordMapper.selectCount((Wrapper)recordQW).toString());
            versionVo.setVersionNum(download);
        }
        return versionVos;
    }

    public Map<String, Object> getCurrentInfo(String apiKey, String buildKey, String buildType, HttpServletRequest request) {
        String reg = "[0-9]+";
        if (!apiKey.matches(reg)) {
            apiKey = this.publishAppVersionMapper.getUserIdByApikey(apiKey);
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        boolean success = true;
        String msg = "\u67e5\u8be2\u6210\u529f";
        buildType = "".equals(buildType) ? "5" : buildType;
        try {
            List<Map<String, Object>> list = this.publishAppMapper.getCurrentInfo(apiKey, buildKey, buildType);
            if (list.size() > 0) {
                list.get(0).put("downloadUrl", ((MobilePublishConfigProperty)SpringContextHolder.getBean(MobilePublishConfigProperty.class)).getPrepareUrl() + list.get(0).get("shortLink"));
                result.put("data", list.get(0));
            } else {
                success = false;
                msg = "\u672a\u627e\u5230\u76f8\u5173\u4fe1\u606f\uff0c\u8bf7\u6838\u5bf9\u540e\u91cd\u8bd5\uff01";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            success = false;
            msg = "\u670d\u52a1\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01";
        }
        result.put("success", success);
        result.put("msg", msg);
        return result;
    }
}

