/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.mobile.publish.service.impl;

import com.jxdinfo.hussar.mobile.publish.service.PublishAppPrepareService;
import com.jxdinfo.hussar.mobile.publish.service.PublishAppRecordService;
import com.jxdinfo.hussar.mobile.publish.service.PublishAppService;
import com.jxdinfo.hussar.mobile.publish.vo.PublishAppVo;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.mobile.publish.service.impl.publishAppPrepareServiceImpl")
public class PublishAppPrepareServiceImpl
implements PublishAppPrepareService {
    @Resource
    private PublishAppService appService;
    @Resource
    private PublishAppRecordService appRecordService;

    public int getPlatform(HttpServletRequest request) {
        String str = request.getHeader("User-Agent");
        return this.appService.getDetail(str);
    }

    public ApiResponse<List<PublishAppVo>> getPublishAppVo(String shortLink, String platform, Long versionId) {
        List appVoList = new ArrayList<PublishAppVo>();
        if (HussarUtils.isNotEmpty((Object)versionId) && HussarUtils.isEmpty((Object)shortLink)) {
            PublishAppVo appVo2 = this.appService.getAppVoByVersionId(versionId);
            appVoList.add(appVo2);
        } else if (HussarUtils.isNotEmpty((Object)shortLink) && HussarUtils.isEmpty((Object)versionId)) {
            if ("2".equals(platform)) {
                platform = "";
            }
            appVoList = this.appService.getPreAppVoList(platform, shortLink);
        } else {
            return ApiResponse.fail((String)"\u77ed\u94fe\u63a5\u548c\u7248\u672cID\u4e0d\u80fd\u540c\u65f6\u90fd\u6ca1\u6709\u6216\u540c\u65f6\u90fd\u6709");
        }
        if (appVoList != null && appVoList.size() > 0) {
            appVoList.stream().forEach(appVo -> {
                if (StringUtil.isNotEmpty((Object)appVo.getSecretCode())) {
                    appVo.setSecret(true);
                    appVo.setSecretCode("");
                }
            });
        }
        return appVoList != null && appVoList.size() > 0 ? ApiResponse.success(appVoList) : ApiResponse.fail((String)"\u5e94\u7528\u4e0d\u5b58\u5728");
    }
}

