/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.mobile.publish.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.common.base.PageInfo;
import com.jxdinfo.hussar.mobile.publish.dto.BindingDto;
import com.jxdinfo.hussar.mobile.publish.dto.PublishAppDto;
import com.jxdinfo.hussar.mobile.publish.dto.PublishVersionDto;
import com.jxdinfo.hussar.mobile.publish.service.PublishAppService;
import com.jxdinfo.hussar.mobile.publish.service.PublishVersionService;
import com.jxdinfo.hussar.mobile.publish.vo.PublishAppStatisticVo;
import com.jxdinfo.hussar.mobile.publish.vo.PublishAppVo;
import com.jxdinfo.hussar.mobile.publish.vo.PublishVersionVo;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Api(tags={"\u79fb\u52a8\u5e94\u7528\u53d1\u5e03\u4e0b\u8f7d"})
@RestController
@RequestMapping(value={"/hussarbase/publish"})
public class PublishAppController {
    @Resource
    private PublishAppService publishAppService;
    @Resource
    private PublishVersionService publishVersionService;

    @ApiOperation(value="\u83b7\u53d6APP\u5217\u8868", notes="\u83b7\u53d6APP\u5217\u8868")
    @GetMapping(value={"/list"})
    @AuditLog(moduleName="\u83b7\u53d6APP\u5217\u8868", eventDesc="\u83b7\u53d6APP\u5217\u8868", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<Page<PublishAppVo>> getAppList(@RequestParam(required=false, value="searchKey") @ApiParam(value="\u67e5\u8be2\u6761\u4ef6") String searchKey, @RequestParam(required=false, value="platForm") @ApiParam(value="\u5e73\u53f0") String platForm, @ApiParam(value="\u5206\u9875\u4fe1\u606f") PageInfo pageInfo) {
        return this.publishAppService.getAppVoList(searchKey, platForm, "", pageInfo);
    }

    @ApiOperation(value="\u5220\u9664APP", notes="\u5220\u9664APP")
    @PostMapping(value={"/deleteApp"})
    @AuditLog(moduleName="\u5220\u9664APP", eventDesc="\u5220\u9664APP", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<Boolean> deleteApp(@RequestParam @ApiParam(value="appId") Long appId) {
        return this.publishAppService.deleteApp(appId);
    }

    @ApiOperation(value="\u83b7\u53d6app\u8be6\u60c5", notes="\u83b7\u53d6app\u8be6\u60c5")
    @GetMapping(value={"/appDetail"})
    @AuditLog(moduleName="\u83b7\u53d6app\u8be6\u60c5", eventDesc="\u83b7\u53d6app\u8be6\u60c5", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<PublishAppVo> getOpenAppDetail(@RequestParam(value="appId") @ApiParam(value="appId") String appId) {
        return ApiResponse.success((Object)this.publishAppService.getAppDetail(null, appId));
    }

    @ApiOperation(value="\u67e5\u8be2\u5df2\u5408\u5e76 ", notes="\u67e5\u8be2\u5df2\u5408\u5e76 ")
    @GetMapping(value={"/relation"})
    @AuditLog(moduleName="\u67e5\u8be2\u5df2\u5408\u5e76 ", eventDesc="\u67e5\u8be2\u5df2\u5408\u5e76 ", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<PublishAppVo>> getCombineApp(@RequestParam(value="appId") @ApiParam(value="appId") Long appId) {
        return this.publishAppService.getCombineAppVoList(appId);
    }

    @ApiOperation(value=" \u53ef\u5408\u5e76\u5e94\u7528", notes=" \u53ef\u5408\u5e76\u5e94\u7528")
    @GetMapping(value={"/unrelation"})
    @AuditLog(moduleName=" \u53ef\u5408\u5e76\u5e94\u7528", eventDesc="/ \u53ef\u5408\u5e76\u5e94\u7528", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<PublishAppVo>> getUncomposedApp(@RequestParam(value="appId") @ApiParam(value="appId") Long appId, @RequestParam(value="appName") @ApiParam(value="\u5e94\u7528\u540d\u79f0") String appName, @RequestParam(value="plat") @ApiParam(value="\u5e73\u53f0\u7c7b\u578b") String plat, @RequestParam(value="reAppId") @ApiParam(value="\u5df2\u5220\u9664\u7684appId") Long reAppId) {
        return this.publishAppService.getUnCombineAppVoList(appId, appName, plat, reAppId);
    }

    @ApiOperation(value="\u5408\u5e76/\u89e3\u9664\u5e94\u7528", notes="\u5408\u5e76/\u89e3\u9664\u5e94\u7528")
    @PostMapping(value={"/relation"})
    @AuditLog(moduleName="\u5408\u5e76/\u89e3\u9664\u5e94\u7528", eventDesc="\u5408\u5e76/\u89e3\u9664\u5e94\u7528", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<Boolean> combineApp(@RequestBody @ApiParam(value="BindingDto") BindingDto bindingDto) {
        return this.publishAppService.combineApp(bindingDto);
    }

    @ApiOperation(value="\u4fee\u6539\u5e94\u7528", notes="\u4fee\u6539\u5e94\u7528")
    @PostMapping(value={"/updateApp"})
    @AuditLog(moduleName="\u4fee\u6539\u5e94\u7528", eventDesc="\u4fee\u6539\u5e94\u7528", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<Boolean> updateApp(@RequestBody @ApiParam(value="app\u5b9e\u4f53\u7c7b") PublishAppDto appDto) {
        return this.publishAppService.updateApp(appDto);
    }

    @ApiOperation(value="\u7f16\u8f91app\u7684\u67d0\u7248\u672c", notes="\u7f16\u8f91app\u7684\u67d0\u7248\u672c")
    @PostMapping(value={"/version"})
    @AuditLog(moduleName="\u7f16\u8f91app\u7684\u67d0\u7248\u672c", eventDesc="\u7f16\u8f91app\u7684\u67d0\u7248\u672c", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<PublishVersionVo> editAppVersion(@RequestBody @ApiParam(value="\u79fb\u52a8\u53d1\u5e03\u5e94\u7528\u7248\u672c\u8868Dto") PublishVersionDto appVersionDto) {
        return this.publishAppService.editAppVersion(appVersionDto);
    }

    @ApiOperation(value="\u6839\u636e\u5e94\u7528\u7edf\u8ba1", notes="\u6839\u636e\u5e94\u7528\u7edf\u8ba1")
    @GetMapping(value={"/statistics"})
    @AuditLog(moduleName="\u6839\u636e\u5e94\u7528\u7edf\u8ba1", eventDesc="\u6839\u636e\u5e94\u7528\u7edf\u8ba1", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<PublishAppStatisticVo> getAppStatistic(@RequestParam(value="appId") @ApiParam(value="appId") Long appId, @RequestParam(value="type") @ApiParam(value="\u7c7b\u578b\uff0c0\uff1a\u5468\uff0c1\uff1a\u6708\uff0c2\uff1a\u5e74") Integer type, @RequestParam(value="isAll", required=false, defaultValue="false") @ApiParam(value="\u662f\u5426\u7edf\u8ba1\u5408\u5e76") Boolean isAll) {
        return this.publishAppService.getAppStatistic(appId, type.intValue(), isAll.booleanValue());
    }

    @ApiOperation(value="\u6839\u636e\u8eab\u4efd\u4fe1\u606f\u83b7\u53d6\u7248\u672c\u4fe1\u606f", notes="\u6839\u636e\u8eab\u4efd\u4fe1\u606f\u83b7\u53d6\u7248\u672c\u4fe1\u606f")
    @GetMapping(value={"/appVersion"})
    @AuditLog(moduleName="\u6839\u636e\u8eab\u4efd\u4fe1\u606f\u83b7\u53d6\u7248\u672c\u4fe1\u606f", eventDesc="\u6839\u636e\u8eab\u4efd\u4fe1\u606f\u83b7\u53d6\u7248\u672c\u4fe1\u606f", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<PublishVersionVo>> queryAppVersion(@RequestParam(value="appId") @ApiParam(value="appId") Long appId) {
        return ApiResponse.success((Object)this.publishVersionService.queryAppVersion(appId));
    }

    @ApiOperation(value="\u89e3\u6790\u4e0a\u4f20App")
    @PostMapping(value={"/uploadApp"})
    public ApiResponse<PublishAppVo> uploadApp(MultipartHttpServletRequest file, HttpServletRequest request, @RequestParam(value="appId", required=false) Long appId) {
        return this.publishAppService.uploadApp(file, request, appId);
    }

    @ApiOperation(value="\u6821\u9a8c\u5bc6\u7801")
    @GetMapping(value={"{appID}/password"})
    public ApiResponse<Boolean> checkPassword(@PathVariable Long appID, @RequestParam String password) {
        return this.publishAppService.checkPassword(appID, password);
    }

    @ApiParam(value="\u5e94\u7528\u6c47\u603b\u5217\u8868")
    @GetMapping(value={"/appCollect"})
    @AuditLog(moduleName="\u5e94\u7528\u6c47\u603b\u5217\u8868", eventDesc="\u5e94\u7528\u6c47\u603b\u5217\u8868", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<Page<PublishAppVo>> getAppCollect(@RequestParam @ApiParam(value="userId") Long userId, @RequestParam @ApiParam(value="\u5e94\u7528\u540d\u79f0") String appName, @ApiParam(value="\u5206\u9875\u4fe1\u606f") PageInfo pageInfo) {
        return ApiResponse.success((Object)this.publishAppService.getAppCollect(userId, appName, pageInfo));
    }

    @GetMapping(value={"/getUserList"})
    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u5217\u8868", notes="\u83b7\u53d6\u7528\u6237\u5217\u8868")
    @AuditLog(moduleName="\u83b7\u53d6\u7528\u6237\u5217\u8868", eventDesc="\u83b7\u53d6\u7528\u6237\u5217\u8868", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<HashMap<String, Object>>> queryUserList(@RequestParam @ApiParam(value="\u7528\u6237\u540d") String userName) {
        return this.publishAppService.queryUserList(userName);
    }
}

