/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.mobile.publish.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.mobile.publish.config.MobilePublishConfigProperty;
import com.jxdinfo.hussar.mobile.publish.model.PublishRecord;
import com.jxdinfo.hussar.mobile.publish.model.PublishVersion;
import com.jxdinfo.hussar.mobile.publish.service.PublishAppDownloadService;
import com.jxdinfo.hussar.mobile.publish.service.PublishAppRecordService;
import com.jxdinfo.hussar.mobile.publish.service.PublishAppService;
import com.jxdinfo.hussar.mobile.publish.service.PublishVersionService;
import com.jxdinfo.hussar.mobile.publish.util.AppFileUtil;
import com.jxdinfo.hussar.mobile.publish.vo.PublishAppVo;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.oss.api.service.OssService;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.mobile.publish.service.impl.publishAppDownloadServiceImpl")
public class PublishAppDownloadServiceImpl
implements PublishAppDownloadService {
    @Resource
    private PublishVersionService versionService;
    @Resource
    private PublishAppRecordService appRecordService;
    @Resource
    private OssService ossService;
    private PublishAppService publishAppService;

    public ApiResponse<Map<String, Object>> downloadApp(Long versionId, Integer platform, String isPcDown, HttpServletRequest request, HttpServletResponse response) {
        PublishVersion appVersionDO = (PublishVersion)this.versionService.getById((Serializable)versionId);
        Long fileId = appVersionDO.getFileId();
        PublishRecord appRecordDO = new PublishRecord();
        appRecordDO.setAppId(appVersionDO.getAppId());
        appRecordDO.setVersionId(appVersionDO.getId());
        appRecordDO.setDownloadIp(request.getRemoteAddr());
        appRecordDO.setPhoneModel(request.getHeader("User-Agent"));
        this.appRecordService.save((Object)appRecordDO);
        HashMap<String, String> result = new HashMap<String, String>(16);
        result.put("address", "");
        if (platform == 0 && "1".equals(isPcDown)) {
            result.put("address", "itms-services://?action=download-manifest&url=" + ((MobilePublishConfigProperty)SpringContextHolder.getBean(MobilePublishConfigProperty.class)).getDownloadUrl() + "plists/" + fileId);
        } else {
            result.put("address", ((MobilePublishConfigProperty)SpringContextHolder.getBean(MobilePublishConfigProperty.class)).getDownloadUrl() + "fileDownload?fileId=" + fileId);
        }
        response.addHeader("Pragma", "no-cache");
        response.setHeader("Cache-Control", "no-cache, no-store, must-revalidate");
        response.addHeader("Cache-Control", "pre-check=0, post-check=0");
        response.setDateHeader("Expires", 0L);
        return ApiResponse.success(result);
    }

    public void downloadFile(Long fileId, HttpServletRequest request, HttpServletResponse response) {
        try {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"FILE_ID", (Object)fileId);
            PublishVersion appVersionDO = (PublishVersion)this.versionService.getOne((Wrapper)queryWrapper);
            if (appVersionDO.getPlistFile() == null || appVersionDO.getPlistFile().equals("")) {
                PublishAppVo appDetail = this.publishAppService.getAppDetail(appVersionDO.getUserId(), String.valueOf(appVersionDO.getAppId()));
                String plistFile = AppFileUtil.generatePlistFile(((MobilePublishConfigProperty)SpringContextHolder.getBean(MobilePublishConfigProperty.class)).getDownloadUrl() + "fileDownload", fileId, appVersionDO, appDetail.getPackageName());
                appVersionDO.setPlistFile(plistFile);
                UpdateWrapper updateWrapper = new UpdateWrapper();
                updateWrapper.eq((Object)"VERSION_ID", (Object)appVersionDO.getId());
                updateWrapper.set((Object)"PLIST_FILE", (Object)plistFile);
                this.versionService.update((Wrapper)updateWrapper);
            }
            response.setContentType("application/octet-stream;charset=UTF-8");
            response.setHeader("Content-Disposition", "attachment;fileName=" + fileId);
            response.setHeader("Content-Length", String.valueOf(appVersionDO.getPlistFile().getBytes().length));
            ServletOutputStream outputStream = response.getOutputStream();
            outputStream.write(appVersionDO.getPlistFile().getBytes());
            outputStream.flush();
            outputStream.close();
        }
        catch (IOException e) {
            e.fillInStackTrace();
        }
    }

    public void fileDownload(HttpServletResponse response, String fileId) {
        ApiResponse apiResponse = this.ossService.backgroundDownload(Long.valueOf(fileId));
        byte[] data = (byte[])apiResponse.getData();
        try (ServletOutputStream outputStream = response.getOutputStream();){
            outputStream.write(data);
            outputStream.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

