/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.mobile.pack.build.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.jxdinfo.hussar.common.base.PageInfo;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.mobile.pack.build.dto.PackageBuildDto;
import com.jxdinfo.hussar.mobile.pack.build.dto.PackageBuildQueryReqDto;
import com.jxdinfo.hussar.mobile.pack.build.model.PackageBuild;
import com.jxdinfo.hussar.mobile.pack.build.service.PackageBuildService;
import com.jxdinfo.hussar.mobile.pack.build.vo.PackageBuildVo;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"app\u6784\u5efa\u64cd\u4f5c\u7c7b"})
@RestController
@RequestMapping(value={"/hussarbase/package/build"})
public class PackageBuildController {
    @Resource
    private PackageBuildService buildService;

    @PostMapping(value={"addBuild"})
    @ApiOperation(value="\u65b0\u589e\u79fb\u52a8\u5e94\u7528\u6253\u5305\u6784\u5efa", notes="\u65b0\u589e\u79fb\u52a8\u5e94\u7528\u6253\u5305\u6784\u5efa")
    @AuditLog(moduleName="\u79fb\u52a8\u5e94\u7528\u6253\u5305\u6784\u5efa", eventDesc="\u65b0\u589e\u79fb\u52a8\u5e94\u7528\u6253\u5305\u6784\u5efa", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.INSERT)
    public ApiResponse<Boolean> addAppBuild(@RequestBody @ApiParam(value="\u79fb\u52a8\u6253\u5305\u6784\u5efa\u5b9e\u4f53dto") PackageBuildDto packageBuildDto, @RequestHeader(value="Authorization") String accessToken) {
        return this.buildService.addAppBuild(packageBuildDto, accessToken);
    }

    @GetMapping(value={"getBuildList"})
    @ApiOperation(value="\u83b7\u53d6\u6253\u5305\u6784\u5efa\u5217\u8868", notes="\u83b7\u53d6\u6253\u5305\u6784\u5efa\u5217\u8868")
    @AuditLog(moduleName="\u79fb\u52a8\u5e94\u7528\u6253\u5305\u6784\u5efa", eventDesc="\u83b7\u53d6\u6253\u5305\u6784\u5efa\u5217\u8868", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<IPage<PackageBuildVo>> getPackageBuildList(@ApiParam(value="\u5206\u9875\u4fe1\u606f") PageInfo pageInfo, @ApiParam(value="\u6253\u5305\u6784\u5efa\u67e5\u8be2dto") PackageBuildQueryReqDto packageBuildQueryReqDto) {
        return this.buildService.getPackageBuildList(pageInfo, packageBuildQueryReqDto);
    }

    @GetMapping(value={"latest"})
    @ApiOperation(value="\u6839\u636e\u914d\u7f6eID\u83b7\u53d6\u6700\u65b0\u4e00\u6b21\u6784\u5efa\u8bb0\u5f55", notes="\u6839\u636e\u914d\u7f6eID\u83b7\u53d6\u6700\u65b0\u4e00\u6b21\u6784\u5efa\u8bb0\u5f55")
    @AuditLog(moduleName="\u79fb\u52a8\u5e94\u7528\u6253\u5305\u6784\u5efa", eventDesc="\u6839\u636e\u914d\u7f6eID\u83b7\u53d6\u6700\u65b0\u4e00\u6b21\u6784\u5efa\u8bb0\u5f55", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<PackageBuildVo> getAppPackBuildByConfigId(@RequestParam @ApiParam(value="\u914d\u7f6eId") Long configId) {
        return this.buildService.getLastPackageBuildByConfigId(configId);
    }

    @GetMapping
    @ApiOperation(value="\u6839\u636e\u6784\u5efaid\u83b7\u53d6\u6784\u5efa\u8be6\u60c5", notes="\u6839\u636e\u6784\u5efaid\u83b7\u53d6\u6784\u5efa\u8be6\u60c5")
    @AuditLog(moduleName="\u79fb\u52a8\u5e94\u7528\u6253\u5305\u6784\u5efa", eventDesc="\u6839\u636e\u6784\u5efaid\u83b7\u53d6\u6784\u5efa\u8be6\u60c5", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<PackageBuildVo> getAppPackBuild(@RequestParam @ApiParam(value="\u5e94\u7528Id") Long buildId) {
        return this.buildService.getPackageBuildById(buildId);
    }

    @PostMapping(value={"release"})
    @ApiOperation(value="\u53d1\u5e03app", notes="\u53d1\u5e03app")
    @AuditLog(moduleName="\u79fb\u52a8\u5e94\u7528\u6253\u5305\u6784\u5efa", eventDesc="\u6784\u5efa\u5b8c\u6210\u540e\u8c03\u7528", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.INSERT)
    public ApiResponse<Boolean> releaseApp(@RequestBody @ApiParam(value="\u6784\u5efaId") Long buildId, HttpServletRequest request) {
        PackageBuild build = (PackageBuild)this.buildService.getById((Serializable)buildId);
        Long userId = BaseSecurityUtil.getUser().getUserId();
        return ApiResponse.success((Object)this.buildService.releaseApp(build, request, userId));
    }
}

