/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.mobile.pack.build.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.common.base.PageInfo;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.utils.HussarPageUtils;
import com.jxdinfo.hussar.mobile.pack.app.model.PackageCodeVersion;
import com.jxdinfo.hussar.mobile.pack.app.model.PackageConfig;
import com.jxdinfo.hussar.mobile.pack.app.service.PackageCodeVersionService;
import com.jxdinfo.hussar.mobile.pack.app.service.PackageConfigService;
import com.jxdinfo.hussar.mobile.pack.build.dao.PackageBuildMapper;
import com.jxdinfo.hussar.mobile.pack.build.dto.PackageBuildDto;
import com.jxdinfo.hussar.mobile.pack.build.dto.PackageBuildQueryReqDto;
import com.jxdinfo.hussar.mobile.pack.build.model.PackageBuild;
import com.jxdinfo.hussar.mobile.pack.build.model.PackageBuildLog;
import com.jxdinfo.hussar.mobile.pack.build.service.PackageBuildLogService;
import com.jxdinfo.hussar.mobile.pack.build.service.PackageBuildService;
import com.jxdinfo.hussar.mobile.pack.build.vo.PackageBuildManageVo;
import com.jxdinfo.hussar.mobile.pack.build.vo.PackageBuildVo;
import com.jxdinfo.hussar.mobile.pack.manager.FileManager;
import com.jxdinfo.hussar.mobile.pack.manager.JenkinsManager;
import com.jxdinfo.hussar.mobile.pack.setting.service.PackageSettingService;
import com.jxdinfo.hussar.mobile.pack.utils.CommonUtills;
import com.jxdinfo.hussar.mobile.pack.utils.HttpUtil;
import com.jxdinfo.hussar.mobile.publish.service.PublishAppBoService;
import com.jxdinfo.hussar.mobile.publish.vo.PublishAppVo;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.platform.core.utils.url.URLUtil;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.oss.core.support.vo.AttachmentManagerModelVo;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.BeanUtils;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service(value="com.jxdinfo.hussar.mobile.pack.build.service.impl.packageBuildServiceImpl")
public class PackageBuildServiceImpl
extends HussarServiceImpl<PackageBuildMapper, PackageBuild>
implements PackageBuildService {
    @Resource
    private PackageBuildMapper buildMapper;
    @Resource
    private JenkinsManager jenkinsManager;
    @Resource
    private PackageBuildLogService buildLogService;
    @Resource
    private PackageConfigService packageAppConfigService;
    @Resource
    private PackageCodeVersionService packageCodeVersionService;
    @Resource
    private PublishAppBoService publishAppBoService;
    @Resource
    private PackageSettingService packageSettingService;
    @Resource
    private FileManager fileManager;

    public ApiResponse<IPage<PackageBuildVo>> getPackageBuildList(PageInfo pageInfo, PackageBuildQueryReqDto packageBuildQueryReqDto) {
        Page page = HussarPageUtils.convert((PageInfo)pageInfo);
        try {
            List<PackageBuildVo> list = this.buildMapper.getAppBuildList((Page<PackageBuildVo>)page, packageBuildQueryReqDto);
            page.setRecords(list);
        }
        catch (Exception e) {
            throw new HussarException("\u67e5\u8be2\u6784\u5efa\u8bb0\u5f55\u5931\u8d25\uff01");
        }
        return ApiResponse.success((Object)page);
    }

    public ApiResponse<PackageBuildVo> getLastPackageBuildByConfigId(Long configId) {
        PackageBuildVo buildVo = null;
        try {
            List<PackageBuildVo> buildVoList = this.buildMapper.getLastPackageBuildByConfigId(configId);
            if (CollectionUtil.isNotEmpty(buildVoList)) {
                buildVo = buildVoList.get(0);
            }
        }
        catch (Exception e) {
            throw new HussarException("\u83b7\u53d6\u6784\u5efa\u4fe1\u606f\u5931\u8d25\uff01");
        }
        return ApiResponse.success(buildVo);
    }

    public ApiResponse<PackageBuildVo> getPackageBuildById(Long buildId) {
        PackageBuildVo buildVo = null;
        try {
            buildVo = this.buildMapper.getPackageBuildById(buildId);
        }
        catch (Exception e) {
            throw new HussarException("\u83b7\u53d6\u6784\u5efa\u8be6\u60c5\u5931\u8d25\uff01");
        }
        return ApiResponse.success((Object)buildVo);
    }

    public ApiResponse<IPage<PackageBuildManageVo>> getAppManageBuildList(PageInfo pageInfo, PackageBuildQueryReqDto packageBuildQueryReqDto) {
        Page page = HussarPageUtils.convert((PageInfo)pageInfo);
        try {
            packageBuildQueryReqDto.setConfigName(CommonUtills.replaceSpeciaChar((String)packageBuildQueryReqDto.getConfigName()));
            packageBuildQueryReqDto.setAppName(CommonUtills.replaceSpeciaChar((String)packageBuildQueryReqDto.getAppName()));
            List<PackageBuildManageVo> list = this.buildMapper.getAppManageBuildList((Page<PackageBuildManageVo>)page, packageBuildQueryReqDto);
            page.setRecords(list);
        }
        catch (Exception e) {
            throw new HussarException("\u83b7\u53d6\u6784\u5efa\u8bb0\u5f55\u5931\u8d25\uff01");
        }
        return ApiResponse.success((Object)page);
    }

    @Async
    @HussarTransactional
    public void dealAfterBuild(PackageBuild build) {
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        Map settingMap = this.packageSettingService.getSettingMap();
        if (settingMap == null) {
            throw new com.jxdinfo.hussar.core.exception.HussarException("\u83b7\u53d6\u4e0d\u5230\u6784\u5efa\u914d\u7f6e");
        }
        String jobName = null;
        if ("1".equals(build.getBuildType())) {
            jobName = (String)settingMap.get("JENKINS_ANDROID_JOB_NAME");
        } else if ("0".equals(build.getBuildType())) {
            jobName = (String)settingMap.get("JENKINS_IOS_JOB_NAME");
        }
        Boolean result = this.jenkinsManager.getBuildResult(jobName, build.getJenkinsBuildId());
        PackageBuildLog buildLog = this.jenkinsManager.getJenkinsBuildLog(build);
        if (buildLog != null) {
            this.buildLogService.save((Object)buildLog);
        }
        if (result != null && result.booleanValue()) {
            build.setBuildStatus("1");
        } else {
            build.setBuildStatus("0");
        }
        this.updateById((BaseEntity)build);
    }

    @Async
    public void dealJenkinsBuildId(PackageBuild build) {
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        String jobName = null;
        Map settingMap = this.packageSettingService.getSettingMap();
        if (settingMap == null) {
            throw new com.jxdinfo.hussar.core.exception.HussarException("\u83b7\u53d6\u4e0d\u5230\u6784\u5efa\u914d\u7f6e");
        }
        if ("1".equals(build.getBuildType())) {
            jobName = (String)settingMap.get("JENKINS_ANDROID_JOB_NAME");
        } else if ("0".equals(build.getBuildType())) {
            jobName = (String)settingMap.get("JENKINS_IOS_JOB_NAME");
        }
        String jenkinsBuildId = this.jenkinsManager.getBuildId(jobName, String.valueOf(build.getId()));
        build.setJenkinsBuildId(jenkinsBuildId);
        this.updateById((BaseEntity)build);
    }

    @HussarTransactional
    public boolean releaseApp(PackageBuild build, HttpServletRequest request, Long userId) {
        ApiResponse apiResponse;
        String uploadLog = null;
        PackageCodeVersion codeVersion = (PackageCodeVersion)this.packageCodeVersionService.getById((Serializable)build.getVersionId());
        if (codeVersion != null) {
            uploadLog = codeVersion.getUpdateLog();
        }
        if ((apiResponse = this.publishAppBoService.uploadAppByFileId(build.getFileId(), request, null, userId, uploadLog)) != null && apiResponse.getData() != null) {
            build.setPreviewAddress(((PublishAppVo)apiResponse.getData()).getShortLink());
            build.setPublish("1");
            return this.updateById((BaseEntity)build);
        }
        throw new HussarException("\u53d1\u5e03\u5931\u8d25\uff01");
    }

    @HussarTransactional
    public ApiResponse<Boolean> addAppBuild(PackageBuildDto packageBuildDto, String accessToken) {
        PackageConfig packageConfig = (PackageConfig)this.packageAppConfigService.getById((Serializable)packageBuildDto.getConfigId());
        PackageBuild packageBuild = new PackageBuild();
        BeanUtils.copyProperties((Object)packageBuildDto, (Object)packageBuild);
        packageBuild.setBuildType(packageConfig.getConfigType());
        packageBuild.setAppId(packageConfig.getbId());
        packageBuild.setBuildStatus("2");
        Long buildId = CommonUtills.generateAssignId();
        packageBuild.setId(buildId);
        Map settingMap = this.packageSettingService.getSettingMap();
        if (settingMap == null) {
            throw new com.jxdinfo.hussar.core.exception.HussarException("\u83b7\u53d6\u4e0d\u5230\u6784\u5efa\u914d\u7f6e");
        }
        HashMap params = new HashMap();
        if ("1".equals(packageConfig.getConfigType())) {
            params.put("job", settingMap.get("JENKINS_ANDROID_JOB_NAME"));
        } else if ("0".equals(packageConfig.getConfigType())) {
            params.put("job", settingMap.get("JENKINS_IOS_JOB_NAME"));
        }
        params.put("objId", packageBuild.getConfigId());
        params.put("appId", packageConfig.getbId());
        params.put("buildId", packageBuild.getId());
        params.put("configId", packageBuild.getConfigId());
        params.put("checkCodeVersion", packageBuildDto.getCheckCodeVersion());
        params.put("versionId", ((PackageCodeVersion)this.packageCodeVersionService.getById((Serializable)packageBuild.getVersionId())).getFileId());
        params.put("accessToken", URLUtil.encode((String)accessToken));
        params.put("apiKey", BaseSecurityUtil.getUser().getUserId());
        try {
            this.jenkinsManager.executeJenkinsBuild(params);
            this.save((BaseEntity)packageBuild);
            this.dealJenkinsBuildId(packageBuild);
            packageConfig.setVersionId(packageBuild.getVersionId());
            this.packageAppConfigService.updateById((Object)packageConfig);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new HussarException("\u6253\u5305\u6784\u5efa\u5931\u8d25\uff01");
        }
        return ApiResponse.success((Object)true);
    }

    @HussarTransactional
    public ApiResponse<Boolean> updateCodePackage(MultipartFile multipartFile, Long buildId, HttpServletRequest request, Long userId) {
        Map settingMap = this.packageSettingService.getSettingMap();
        if (settingMap == null) {
            throw new com.jxdinfo.hussar.core.exception.HussarException("\u83b7\u53d6\u4e0d\u5230\u6784\u5efa\u914d\u7f6e");
        }
        String ip = HttpUtil.getIpAddress((HttpServletRequest)request);
        if (StringUtil.isEmpty((Object)ip) || StringUtil.isNotBlank((CharSequence)ip) && !ip.equals(settingMap.get("JENKINS_SERVER_IP").toString())) {
            throw new HussarException("\u6ca1\u6709\u4e0a\u4f20\u6743\u9650\uff01");
        }
        try {
            PackageBuild packageBuild = (PackageBuild)this.getById(buildId);
            Long fileId = null;
            AttachmentManagerModelVo attachmentManagerModelVo = this.fileManager.uploadFile(multipartFile);
            if (attachmentManagerModelVo != null) {
                fileId = attachmentManagerModelVo.getId();
            }
            if ("1".equals(packageBuild.getPublish())) {
                ApiResponse apiResponse;
                String uploadLog = null;
                PackageCodeVersion codeVersion = (PackageCodeVersion)this.packageCodeVersionService.getById((Serializable)packageBuild.getVersionId());
                if (codeVersion != null) {
                    uploadLog = codeVersion.getUpdateLog();
                }
                if ((apiResponse = this.publishAppBoService.uploadAppByFileId(fileId, request, null, userId, uploadLog)) != null && apiResponse.getData() != null) {
                    packageBuild.setPreviewAddress(((PublishAppVo)apiResponse.getData()).getShortLink());
                }
            }
            packageBuild.setFileId(fileId);
            packageBuild.setFileName(multipartFile.getOriginalFilename());
            packageBuild.setFileSize(String.valueOf(multipartFile.getSize()));
            this.updateById((BaseEntity)packageBuild);
        }
        catch (Exception e) {
            throw new HussarException("\u66f4\u65b0\u4ee3\u7801\u5305\u5931\u8d25\uff01");
        }
        return ApiResponse.success((Object)true);
    }
}

