/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.mobile.pack.app.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.common.base.PageInfo;
import com.jxdinfo.hussar.common.utils.HussarPageUtils;
import com.jxdinfo.hussar.mobile.pack.app.dao.PackageCodeVersionMapper;
import com.jxdinfo.hussar.mobile.pack.app.dto.PackageCodeVersionDto;
import com.jxdinfo.hussar.mobile.pack.app.model.PackageCodeVersion;
import com.jxdinfo.hussar.mobile.pack.app.model.PackageConfig;
import com.jxdinfo.hussar.mobile.pack.app.service.PackageCodeVersionService;
import com.jxdinfo.hussar.mobile.pack.app.service.PackageConfigService;
import com.jxdinfo.hussar.mobile.pack.app.vo.PackageCodeVersionVo;
import com.jxdinfo.hussar.mobile.pack.setting.service.PackageSettingService;
import com.jxdinfo.hussar.mobile.pack.utils.CommonUtills;
import com.jxdinfo.hussar.mobile.pack.utils.UUIDTransformUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.mobile.pack.app.service.impl.packageAppCodeVersionServiceImpl")
public class PackageCodeVersionServiceImpl
extends HussarServiceImpl<PackageCodeVersionMapper, PackageCodeVersion>
implements PackageCodeVersionService {
    @Resource
    private PackageConfigService appConfigService;
    @Resource
    PackageCodeVersionMapper appCodeVersionMapper;
    @Resource
    private PackageSettingService packageSettingService;

    public ApiResponse<Boolean> addAppCodeVersion(PackageCodeVersionDto appCodeDto) {
        PackageCodeVersion codeVersion = new PackageCodeVersion();
        BeanUtils.copyProperties((Object)appCodeDto, (Object)codeVersion);
        try {
            this.save((BaseEntity)codeVersion);
        }
        catch (Exception e) {
            throw new HussarException("\u65b0\u589e\u7248\u672c\u5931\u8d25\uff01");
        }
        return ApiResponse.success((Object)true);
    }

    public ApiResponse<Page<PackageCodeVersionVo>> getAppCodeVersion(String searchKey, Long appId, PageInfo pageInfo) {
        Page page = HussarPageUtils.convert((PageInfo)pageInfo);
        try {
            searchKey = CommonUtills.replaceSpeciaChar((String)searchKey);
            List<PackageCodeVersionVo> list = this.appCodeVersionMapper.getAppCodeVersion(searchKey, appId, (Page<PackageCodeVersionVo>)page);
            page.setRecords(list);
        }
        catch (Exception e) {
            throw new HussarException("\u83b7\u53d6\u7248\u672c\u5217\u8868\u5931\u8d25\uff01");
        }
        return ApiResponse.success((Object)page);
    }

    public ApiResponse<Boolean> deleteAppCodeVersion(String versionId) {
        try {
            this.removeById((Serializable)((Object)versionId));
        }
        catch (Exception e) {
            throw new HussarException("\u5220\u9664\u7248\u672c\u5931\u8d25\uff01");
        }
        return ApiResponse.success((Object)true);
    }

    public ApiResponse<Boolean> updateAppCodeVersion(PackageCodeVersionDto appCodeDto) {
        try {
            this.updateById((BaseEntity)appCodeDto);
        }
        catch (Exception e) {
            throw new HussarException("\u4fee\u6539\u7248\u672c\u4fe1\u606f\u5931\u8d25\uff01");
        }
        return ApiResponse.success((Object)true);
    }

    public Object getLatestAppCodeVersion(String configId, int type) {
        String reg = "[0-9]+";
        long newConfigId = !configId.matches(reg) ? UUIDTransformUtil.uuid2long((String)configId) : Long.parseLong(configId);
        Map settingMap = this.packageSettingService.getSettingMap();
        if (settingMap == null) {
            throw new com.jxdinfo.hussar.core.exception.HussarException("\u83b7\u53d6\u4e0d\u5230\u6784\u5efa\u914d\u7f6e");
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("success", true);
        hashMap.put("msg", "");
        Long versionId = ((PackageConfig)this.appConfigService.getById((Serializable)Long.valueOf(newConfigId))).getVersionId();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(PackageCodeVersion::getId, (Object)versionId);
        PackageCodeVersion appCode = (PackageCodeVersion)this.getOne((Wrapper)queryWrapper);
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put("modifyTime", appCode.getLastTime());
        dataMap.put("createTime", appCode.getCreateTime());
        dataMap.put("objID", appCode.getbId());
        dataMap.put("downloadURL", settingMap.get("FILE_OUT_SERVER") + "?fileId=" + appCode.getFileId());
        dataMap.put("updateLog", appCode.getUpdateLog());
        dataMap.put("version", appCode.getFileId());
        hashMap.put("data", dataMap);
        return hashMap;
    }
}

