/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.mobile.pack.build.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.common.base.PageInfo;
import com.jxdinfo.hussar.common.utils.HussarPageUtils;
import com.jxdinfo.hussar.mobile.pack.build.dao.PackageBuildLogMapper;
import com.jxdinfo.hussar.mobile.pack.build.model.PackageBuildLog;
import com.jxdinfo.hussar.mobile.pack.build.service.PackageBuildLogService;
import com.jxdinfo.hussar.mobile.pack.build.vo.PackageBuildLogManagerVo;
import com.jxdinfo.hussar.mobile.pack.manager.FileManager;
import com.jxdinfo.hussar.mobile.pack.setting.service.PackageSettingService;
import com.jxdinfo.hussar.mobile.pack.utils.HttpUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.oss.core.support.vo.AttachmentManagerModelVo;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service(value="com.jxdinfo.hussar.mobile.pack.build.service.impl.packageBuildLogServiceImpl")
public class PackageBuildLogServiceImpl
extends HussarServiceImpl<PackageBuildLogMapper, PackageBuildLog>
implements PackageBuildLogService {
    @Resource
    private PackageBuildLogMapper buildLogMapper;
    @Resource
    private FileManager fileManager;
    @Resource
    private PackageSettingService packageSettingService;

    public ApiResponse<IPage<PackageBuildLogManagerVo>> getAppBuildLogList(PageInfo pageInfo, Long buildId) {
        Page page = HussarPageUtils.convert((PageInfo)pageInfo);
        try {
            List<PackageBuildLogManagerVo> list = this.buildLogMapper.getAppBuildLogList((Page<PackageBuildLogManagerVo>)page, buildId);
            page.setRecords(list);
        }
        catch (Exception e) {
            throw new com.jxdinfo.hussar.core.exception.HussarException("\u83b7\u53d6\u6784\u5efa\u65e5\u5fd7\u5931\u8d25\uff01");
        }
        return ApiResponse.success((Object)page);
    }

    @HussarTransactional
    public ApiResponse<Boolean> uploadBuildLog(MultipartFile multipartFile, Long buildId, HttpServletRequest request) {
        Map settingMap = this.packageSettingService.getSettingMap();
        if (settingMap == null) {
            throw new com.jxdinfo.hussar.core.exception.HussarException("\u83b7\u53d6\u4e0d\u5230\u6784\u5efa\u914d\u7f6e");
        }
        String ip = HttpUtil.getIpAddress((HttpServletRequest)request);
        if (StringUtil.isEmpty((Object)ip) || StringUtil.isNotBlank((CharSequence)ip) && !ip.equals(settingMap.get("JENKINS_SERVER_IP").toString())) {
            throw new HussarException("\u6ca1\u6709\u4e0a\u4f20\u6743\u9650\uff01");
        }
        try {
            AttachmentManagerModelVo attachmentManagerModelVo = this.fileManager.uploadFile(multipartFile);
            if (attachmentManagerModelVo != null) {
                Long fileId = attachmentManagerModelVo.getId();
                PackageBuildLog mobilePackBuildLog = new PackageBuildLog();
                mobilePackBuildLog.setBuildId(buildId);
                mobilePackBuildLog.setFileName(attachmentManagerModelVo.getAttachmentName());
                mobilePackBuildLog.setFileId(fileId);
                mobilePackBuildLog.setFileSize(attachmentManagerModelVo.getBytes());
                this.save((BaseEntity)mobilePackBuildLog);
                return ApiResponse.success((Object)true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new com.jxdinfo.hussar.core.exception.HussarException("\u4e0a\u4f20\u65e5\u5fd7\u5931\u8d25\uff01");
        }
        return ApiResponse.fail((String)"\u4e0a\u4f20\u5931\u8d25");
    }
}

