/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.mobile.pack.app.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.common.base.PageInfo;
import com.jxdinfo.hussar.common.constant.enums.SysUserAndRole;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.utils.HussarPageUtils;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.mobile.pack.app.dao.PackageManageMapper;
import com.jxdinfo.hussar.mobile.pack.app.service.PackageManageService;
import com.jxdinfo.hussar.mobile.pack.app.vo.PackageAppVo;
import com.jxdinfo.hussar.mobile.pack.app.vo.PackageManageVo;
import com.jxdinfo.hussar.mobile.pack.utils.CommonUtills;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.mobile.pack.app.service.impl.packageAppManageServiceImpl")
public class PackageManageServiceImpl
implements PackageManageService {
    @Resource
    private PackageManageMapper packAppManageMapper;

    public Page<PackageManageVo> getAppManageVo(PageInfo pageInfo, String searchKey, Long userId) {
        Page page = HussarPageUtils.convert((PageInfo)pageInfo);
        try {
            searchKey = CommonUtills.replaceSpeciaChar((String)searchKey);
            Long creator = BaseSecurityUtil.getUser().getId();
            List rolesList = BaseSecurityUtil.getUser().getRolesList();
            boolean isSuperAdminOrDeveloper = false;
            if (ToolUtil.isNotEmpty((Object)rolesList) && rolesList.contains(SysUserAndRole.SUPERADMIN_ROLE.getValue()) || rolesList.contains(SysUserAndRole.DEVELOP_ROLE.getValue())) {
                isSuperAdminOrDeveloper = true;
            }
            List<PackageManageVo> list = this.packAppManageMapper.getAppManageVo((Page<PackageManageVo>)page, searchKey, creator, isSuperAdminOrDeveloper);
            page.setRecords(list);
        }
        catch (Exception e) {
            throw new HussarException("\u67e5\u8be2\u5e94\u7528\u4fe1\u606f\u5931\u8d25\uff01");
        }
        return page;
    }

    public ApiResponse<List<HashMap<String, Object>>> queryUserList(String userName) {
        ArrayList list = new ArrayList();
        try {
            userName = CommonUtills.replaceSpeciaChar((String)userName);
            List<PackageAppVo> appList = this.packAppManageMapper.getAppList(userName);
            appList.forEach(app -> {
                HashMap<String, Object> resultMap = new HashMap<String, Object>();
                resultMap.put("label", app.getUserName());
                resultMap.put("value", app.getCreator());
                list.add(resultMap);
            });
        }
        catch (Exception e) {
            throw new HussarException("\u67e5\u8be2\u7528\u6237\u5217\u8868\u5931\u8d25\uff01");
        }
        return ApiResponse.success(list);
    }
}

