/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.mobile.pack.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicHttpEntityEnclosingRequest;
import org.apache.http.message.BasicHttpRequest;
import org.apache.http.util.EntityUtils;

public class HttpUtil {
    private static final RequestConfig config = RequestConfig.custom().setConnectionRequestTimeout(35000).setConnectTimeout(60000).setSocketTimeout(60000).build();
    private static final HttpClient client = HttpClientBuilder.create().setDefaultRequestConfig(config).build();
    public static final String METHOD_GET = "GET";
    public static final String METHOD_POST = "POST";
    public static final String METHOD_DELETE = "DELETE";
    private static final ContentType MIME_TEXT = ContentType.create((String)ContentType.TEXT_PLAIN.getMimeType(), (Charset)StandardCharsets.UTF_8);
    private static final ContentType MIME_JSON = ContentType.create((String)ContentType.APPLICATION_JSON.getMimeType(), (Charset)StandardCharsets.UTF_8);
    private static final ContentType MIME_BINARY = ContentType.APPLICATION_OCTET_STREAM;
    private static final Pattern REGEX_URL_SCHEME = Pattern.compile("^https?:.+");

    public static HttpResponse request(String method, String addr, String path, Map<String, Object> params, Header[] headers, Object body) {
        BasicHttpRequest request;
        String uri;
        HttpHost host = HttpHost.create((String)addr);
        try {
            uri = HttpUtil.buildURI(addr, path, params).toString();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            throw new IllegalArgumentException(e);
        }
        if (body == null) {
            request = new BasicHttpRequest(method, uri);
        } else {
            BasicHttpEntityEnclosingRequest requestWithBody = new BasicHttpEntityEnclosingRequest(method, uri);
            requestWithBody.setEntity(HttpUtil.buildHttpEntity(body));
            request = requestWithBody;
        }
        if (headers != null) {
            request.setHeaders(headers);
        }
        try {
            return client.execute(host, (HttpRequest)request);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new UncheckedIOException(e);
        }
    }

    private static HttpEntity buildHttpEntity(Object body) {
        ContentType mime;
        byte[] content;
        if (body == null) {
            return null;
        }
        if (body instanceof byte[]) {
            content = (byte[])body;
            mime = MIME_BINARY;
        } else {
            if (body instanceof InputStream) {
                return new InputStreamEntity((InputStream)body, MIME_BINARY);
            }
            if (body instanceof String) {
                content = ((String)body).getBytes(StandardCharsets.UTF_8);
                mime = MIME_TEXT;
            } else {
                content = JSON.toJSONBytes((Object)body, (SerializerFeature[])new SerializerFeature[0]);
                mime = MIME_JSON;
            }
        }
        return new ByteArrayEntity(content, mime);
    }

    public static HttpResponse doGet(String addr, String path, Header[] headers, Map<String, Object> params) {
        CloseableHttpClient client = HttpClientBuilder.create().build();
        try {
            URI uri = HttpUtil.buildURI(addr, path, params);
            HttpGet httpGet = new HttpGet(uri);
            httpGet.setConfig(config);
            if (headers != null) {
                httpGet.setHeaders(headers);
            }
            return client.execute((HttpUriRequest)httpGet);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static HttpResponse doPost(String addr, String path, Header[] headers, Map<String, Object> params, byte[] file) {
        CloseableHttpClient client = HttpClientBuilder.create().build();
        try {
            URI uri = HttpUtil.buildURI(addr, path, params);
            HttpPost httpPost = new HttpPost(uri);
            httpPost.setConfig(config);
            if (headers != null) {
                httpPost.setHeaders(headers);
            }
            if (file != null) {
                ByteArrayEntity arrayEntity = new ByteArrayEntity(file);
                arrayEntity.setContentType("application/octet-stream");
                httpPost.setEntity((HttpEntity)arrayEntity);
            }
            return client.execute((HttpUriRequest)httpPost);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static HttpResponse doDelete(String addr, String path, Header[] headers, Map<String, Object> params) {
        CloseableHttpClient client = HttpClientBuilder.create().build();
        try {
            URI uri = HttpUtil.buildURI(addr, path, params);
            HttpDelete httpDelete = new HttpDelete(uri);
            httpDelete.setConfig(config);
            if (headers != null) {
                httpDelete.setHeaders(headers);
            }
            return client.execute((HttpUriRequest)httpDelete);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static URI buildURI(String addr, String path, Map<String, Object> params) throws URISyntaxException {
        if (!REGEX_URL_SCHEME.matcher(addr).matches()) {
            addr = "http://" + addr;
        }
        if (path == null || path.isEmpty()) {
            path = "/";
        }
        if (!(path = path.replace("\\", "/")).startsWith("/")) {
            path = "/" + path;
        }
        URIBuilder builder = new URIBuilder(addr);
        builder.setPath(path);
        if (params != null) {
            for (Map.Entry<String, Object> param : params.entrySet()) {
                builder.addParameter(param.getKey(), String.valueOf(param.getValue()));
            }
        }
        return builder.build();
    }

    public static String toString(HttpResponse response) throws IOException {
        if (response != null && response.getEntity() != null) {
            return EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
        }
        return null;
    }

    public static String getIpAddress(HttpServletRequest request) {
        String ip = request.getHeader("x-forwarded-for");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_CLIENT_IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_X_FORWARDED_FOR");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        return ip;
    }
}

