/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.migration.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.common.base.PageInfo;
import com.jxdinfo.hussar.migration.dto.MigrationDumpDto;
import com.jxdinfo.hussar.migration.dto.MigrationDumpListDto;
import com.jxdinfo.hussar.migration.service.HussarBaseMigrationDumpService;
import com.jxdinfo.hussar.migration.vo.MigrationDumpRecordVo;
import com.jxdinfo.hussar.migration.vo.MigrationDumpReportVo;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.support.security.core.annotation.CheckPermission;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u6570\u636e\u8fc1\u79fb\u5bfc\u51fa\u7ba1\u7406"})
@AuditLog(moduleName="\u6570\u636e\u8fc1\u79fb\u5bfc\u51fa\u7ba1\u7406")
@RestController(value="com.jxdinfo.hussar.migration.controller.hussarBaseMigrationDumpController")
@RequestMapping(value={"/hussarBase/migration/dump"})
public class HussarBaseMigrationDumpController {
    @Autowired
    private HussarBaseMigrationDumpService dumpService;

    @ApiOperation(value="\u5f00\u59cb\u5bfc\u51fa\u4efb\u52a1", notes="\u5f00\u59cb\u5bfc\u51fa\u4efb\u52a1\uff0c\u5f02\u6b65\u6267\u884c\u5e76\u63d0\u524d\u8fd4\u56de\u5bfc\u51fa\u4efb\u52a1 ID")
    @AuditLog(eventDesc="\u5f00\u59cb\u5bfc\u51fa\u4efb\u52a1", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.INSERT)
    @CheckPermission(value={"hussarBase:migration:dump:start"})
    @PostMapping(value={"start"})
    public ApiResponse<Long> start(@ApiParam(value="\u5bfc\u51fa\u53c2\u6570\u5b9e\u4f53") @RequestBody MigrationDumpDto migrationDumpDto) {
        return this.dumpService.dump(migrationDumpDto);
    }

    @ApiOperation(value="\u67e5\u8be2\u5bfc\u51fa\u9636\u6bb5\u6267\u884c\u7ed3\u679c", notes="\u6839\u636e\u4efb\u52a1 ID \u67e5\u8be2\u5bfc\u51fa\u9636\u6bb5\u6267\u884c\u7ed3\u679c")
    @AuditLog(eventDesc="\u67e5\u8be2\u5bfc\u51fa\u9636\u6bb5\u6267\u884c\u7ed3\u679c", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @CheckPermission(value={"hussarBase:migration:dump:report"})
    @GetMapping(value={"report"})
    public ApiResponse<MigrationDumpReportVo> report(@ApiParam(value="\u5bfc\u51fa\u4efb\u52a1 ID") @RequestParam Long dumpId) {
        return this.dumpService.report(dumpId);
    }

    @ApiOperation(value="\u4e0b\u8f7d\u5df2\u6210\u529f\u5bfc\u51fa\u7684\u6570\u636e\u5305", notes="\u4e0b\u8f7d\u5df2\u6210\u529f\u5bfc\u51fa\u7684\u6570\u636e\u5305\uff0c\u4efb\u52a1\u6b63\u5728\u6267\u884c\u6216\u6267\u884c\u5931\u8d25\u7b49\u60c5\u51b5\u65e0\u6cd5\u4e0b\u8f7d")
    @AuditLog(eventDesc="\u4e0b\u8f7d\u5df2\u6210\u529f\u5bfc\u51fa\u7684\u6570\u636e\u5305", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @CheckPermission(value={"hussarBase:migration:dump:download"})
    @GetMapping(value={"download"})
    public void download(HttpServletResponse response, @ApiParam(value="\u5bfc\u51fa\u4efb\u52a1 ID") @RequestParam Long dumpId, @ApiParam(value="\u6587\u4ef6\u5bc6\u7ea7") @RequestParam(required=false) String securityLevel) {
        this.dumpService.downloadWithSecurity(response, dumpId, securityLevel);
    }

    @ApiOperation(value="\u67e5\u8be2\u5355\u6761\u5bfc\u51fa\u8bb0\u5f55\u7684\u6700\u65b0\u72b6\u6001", notes="\u6839\u636e\u4efb\u52a1 ID \u67e5\u8be2\u5bfc\u51fa\u8bb0\u5f55\u5b9e\u4f53\u5bf9\u8c61")
    @CheckPermission(value={"hussarBase:migration:dump:query"})
    @GetMapping(value={"query"})
    public ApiResponse<MigrationDumpRecordVo> query(@ApiParam(value="\u5bfc\u51fa\u4efb\u52a1 ID") @RequestParam Long dumpId) {
        return this.dumpService.query(dumpId);
    }

    @ApiOperation(value="\u67e5\u8be2\u5bfc\u51fa\u8bb0\u5f55\u5217\u8868", notes="\u5206\u9875\u67e5\u8be2\u5bfc\u51fa\u8bb0\u5f55\uff0c\u53ef\u6839\u636e\u72b6\u6001\u7801\u5217\u8868\u8fdb\u884c\u7b5b\u9009\uff0c\u7ed3\u679c\u6309\u521b\u5efa\u65f6\u95f4\u5012\u5e8f\u6392\u5217")
    @AuditLog(eventDesc="\u67e5\u8be2\u5bfc\u51fa\u8bb0\u5f55\u5217\u8868", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @CheckPermission(value={"hussarBase:migration:dump:list"})
    @GetMapping(value={"list"})
    public ApiResponse<Page<MigrationDumpRecordVo>> list(@ApiParam(value="\u5206\u9875\u53c2\u6570") PageInfo page, @ApiParam(value="\u67e5\u8be2\u5bfc\u51fa\u8bb0\u5f55\u5217\u8868Dto") MigrationDumpListDto queryDumpParams) {
        return this.dumpService.list(page, queryDumpParams);
    }

    @ApiOperation(value="\u5220\u9664\u5bfc\u51fa\u4efb\u52a1\u53ca\u5173\u8054\u7684\u6570\u636e\u5305", notes="\u5220\u9664\u5bfc\u51fa\u4efb\u52a1\u53ca\u5173\u8054\u7684\u6570\u636e\u5305\uff0c\u6b63\u5728\u961f\u5217\u6216\u6267\u884c\u4e2d\u7684\u4efb\u52a1\u65e0\u6cd5\u5220\u9664")
    @AuditLog(eventDesc="\u5220\u9664\u5bfc\u51fa\u4efb\u52a1\u53ca\u5173\u8054\u7684\u6570\u636e\u5305", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.DELETE)
    @CheckPermission(value={"hussarBase:migration:dump:remove"})
    @PostMapping(value={"remove"})
    public ApiResponse<Boolean> remove(@ApiParam(value="\u5bfc\u51fa\u4efb\u52a1 ID") @RequestBody Long dumpId) {
        return this.dumpService.remove(dumpId);
    }
}

