/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.migration.utils;

import com.jxdinfo.hussar.migration.exceptions.MigrationException;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.lang3.StringUtils;

public final class MigrationContextUtils {
    private MigrationContextUtils() {
    }

    public static List<String> getPayloadList(File itemWorkspace) {
        if (itemWorkspace == null) {
            throw new NullPointerException();
        }
        if (!itemWorkspace.exists()) {
            return Collections.emptyList();
        }
        if (itemWorkspace.exists() && !itemWorkspace.isDirectory()) {
            throw new MigrationException("payload root is not a directory");
        }
        itemWorkspace = new File(FilenameUtils.normalize((String)itemWorkspace.toString()));
        Collection files = FileUtils.listFiles((File)itemWorkspace, (IOFileFilter)TrueFileFilter.INSTANCE, (IOFileFilter)TrueFileFilter.INSTANCE);
        String prefix = itemWorkspace + File.separator;
        return files.stream().filter(File::isFile).map(File::toString).filter(path -> path.startsWith(prefix)).map(path -> FilenameUtils.normalize((String)StringUtils.removeStart((String)path, (String)prefix), (boolean)true)).collect(Collectors.toList());
    }
}

