/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.migration.utils;

import com.jxdinfo.hussar.migration.constants.MigrationExceptionEnum;
import com.jxdinfo.hussar.migration.enums.ChecksumType;
import com.jxdinfo.hussar.migration.enums.EncryptionType;
import com.jxdinfo.hussar.migration.enums.SignatureType;
import com.jxdinfo.hussar.migration.exceptions.MigrationCheckException;
import com.jxdinfo.hussar.migration.exceptions.MigrationCryptoException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.crypto.Cipher;
import javax.crypto.CipherOutputStream;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.lang.NonNull;

public final class MigrationCryptoUtils {
    private static final Logger logger = LoggerFactory.getLogger(MigrationCryptoUtils.class);
    private static final int AES128_PBKDF2_SALT_LENGTH = 16;
    private static final int AES128_PBKDF2_ITERATION_COUNT = 16384;
    private static final int AES128_PBKDF2_KEY_LENGTH = 128;
    private static final String DEFAULT_AES_KEY = "785ec7ca9c111f9771214e912caa0b737419da29d3472d36c3ed048c15b01a";
    private static final String DEFAULT_RSA_PUBLIC_KEY = "MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDHRHbvkUxeFH5i7Ozn5X5G04B1\nI+RraZUW9S0c2FQ29YEgP9alu3yl9MSCoFrLCbfZnw+cIDNxvBQJxXQuh6wR1dN6\ngtOPOfgQ0d6Fz5isl99KgNhCLgw37VB85l4VJdHIR/4kxgLi5KTMFeB1EhKFWyu9\nygWBL4bLcxr6/04PCQIDAQAB";
    private static final String DEFAULT_RSA_PRIVATE_KEY = "MIICdgIBADANBgkqhkiG9w0BAQEFAASCAmAwggJcAgEAAoGBAMdEdu+RTF4UfmLs\n7OflfkbTgHUj5GtplRb1LRzYVDb1gSA/1qW7fKX0xIKgWssJt9mfD5wgM3G8FAnF\ndC6HrBHV03qC0485+BDR3oXPmKyX30qA2EIuDDftUHzmXhUl0chH/iTGAuLkpMwV\n4HUSEoVbK73KBYEvhstzGvr/Tg8JAgMBAAECgYBqA6fPTxs1FmwjT2++9F7ZaZ73\nM3BMITEbtLcamJE9aCIZuT0GkZgAZxfBc3S6fuIcWr6gTpVwFiMHC9EDDFVjesbr\nCiYwgsGAAafmeXDENOOUVQHE+cBGBgqqLUvWU6eU/ivwRsOvXFum0Anwb3B8Sl6K\nVVBLNL599FH3R1jIMQJBAPMrDGcOzWzFQ/BVrXxvQMuEYc/WJPZ6YBtOSMKmKNEn\nD+P0AtVsMbGrg3GO6ajfx3nY7pVWRbkcVy/PstzGtU0CQQDRyFzU8bVZgAyYaDVC\nfkb+keSY+B08Ouup+VUsHEdoLPzo7SKPCIZGwObgJt5JaDlkOKEc1R04RhcsNBc7\nzrKtAkEAhioHQslBADVqwayT9qbvahqVWPW/GRr18brknDjPJm7V7qCP+68hT/Tg\npgQC2YD2bz0Ije62s2Z2mFORTQx5tQJABk8jU5gtXxK1zkOcDnLjybYzjNIxduVC\nvyrrf9cd4qkvtgWju2+DMk+M4gLpPoXu6++0ELzsEwwwmDi81iSiRQJAbMe749+6\nrZxyeuw3yBmzllDM20ryImWUW9yqs7WrVzbCHoi41mnzp2mgfkAe9tyqwB1fsgeT\no5YD7N/ilV3d/A==";
    private static final Pattern EXTERNAL_KEY_PATTERN = Pattern.compile("^(?:file|classpath):.*$");

    private MigrationCryptoUtils() {
    }

    public static ChecksumTypedValue computeChecksum(ChecksumType type, InputStream data) {
        if (type == null) {
            return null;
        }
        String value = MigrationCryptoUtils.checksum(type, data);
        return ChecksumTypedValue.of(type, value);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ChecksumTypedValue computeChecksum(ChecksumType type, File data) {
        if (type == null) {
            return null;
        }
        if (data == null) {
            throw new NullPointerException();
        }
        try (InputStream input = Files.newInputStream(data.toPath(), new OpenOption[0]);){
            ChecksumTypedValue checksumTypedValue = MigrationCryptoUtils.computeChecksum(type, input);
            return checksumTypedValue;
        }
        catch (IOException ex) {
            throw new MigrationCheckException((Throwable)ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ChecksumTypedValue computeChecksum(ChecksumType type, byte[] data) {
        if (type == null) {
            return null;
        }
        if (data == null) {
            throw new NullPointerException();
        }
        try (ByteArrayInputStream input = new ByteArrayInputStream(data);){
            ChecksumTypedValue checksumTypedValue = MigrationCryptoUtils.computeChecksum(type, input);
            return checksumTypedValue;
        }
        catch (IOException ex) {
            throw new MigrationCheckException((Throwable)ex);
        }
    }

    public static boolean verifyChecksum(ChecksumTypedValue checksum, InputStream data) {
        if (checksum == null) {
            return true;
        }
        String verify = MigrationCryptoUtils.checksum(checksum.getType(), data);
        return StringUtils.equalsIgnoreCase((CharSequence)checksum.getValue(), (CharSequence)verify);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean verifyChecksum(ChecksumTypedValue checksum, File data) {
        if (checksum == null) {
            return true;
        }
        if (data == null) {
            throw new NullPointerException();
        }
        try (InputStream input = Files.newInputStream(data.toPath(), new OpenOption[0]);){
            boolean bl = MigrationCryptoUtils.verifyChecksum(checksum, input);
            return bl;
        }
        catch (IOException ex) {
            throw new MigrationCheckException(MigrationExceptionEnum.CHECK_EXCEPTION.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean verifyChecksum(ChecksumTypedValue checksum, byte[] data) {
        if (checksum == null) {
            return true;
        }
        if (data == null) {
            throw new NullPointerException();
        }
        try (ByteArrayInputStream input = new ByteArrayInputStream(data);){
            boolean bl = MigrationCryptoUtils.verifyChecksum(checksum, input);
            return bl;
        }
        catch (IOException ex) {
            throw new MigrationCheckException((Throwable)ex);
        }
    }

    private static String checksum(ChecksumType type, InputStream payload) {
        String value;
        if (type == null || payload == null) {
            throw new NullPointerException();
        }
        try {
            switch (type) {
                case SHA1: {
                    value = DigestUtils.sha1Hex((InputStream)payload);
                    break;
                }
                case SHA256: {
                    value = DigestUtils.sha256Hex((InputStream)payload);
                    break;
                }
                case SHA512: {
                    value = DigestUtils.sha512Hex((InputStream)payload);
                    break;
                }
                default: {
                    throw new MigrationCheckException("checksum algorithm " + type + " not implemented yet");
                }
            }
        }
        catch (IOException ex) {
            throw new MigrationCheckException(MigrationExceptionEnum.CHECK_EXCEPTION.getMessage());
        }
        return value;
    }

    public static SignatureTypedValue computeSignature(SignatureType type, String privateKey, InputStream data) {
        if (type == null) {
            return null;
        }
        try {
            String value;
            switch (type) {
                case RSA: {
                    privateKey = StringUtils.isNotEmpty((CharSequence)privateKey) ? privateKey : DEFAULT_RSA_PRIVATE_KEY;
                    String loadedPrivateKey = MigrationCryptoUtils.loadSignaturePrivateKey(type, privateKey);
                    Signature rsaSignature = MigrationCryptoUtils.doRsaSignature(type, loadedPrivateKey, false);
                    try (SignatureOutputStream signatureOutputStream = new SignatureOutputStream(rsaSignature);){
                        IOUtils.copy((InputStream)data, (OutputStream)signatureOutputStream);
                    }
                    byte[] rsaSign = rsaSignature.sign();
                    value = MigrationCryptoUtils.encodeBase64(rsaSign);
                    break;
                }
                default: {
                    throw new MigrationCheckException("signature algorithm " + type + " not implemented yet");
                }
            }
            return SignatureTypedValue.of(type, value);
        }
        catch (IOException | SignatureException ex) {
            throw new MigrationCheckException((Throwable)ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static SignatureTypedValue computeSignature(SignatureType type, String privateKey, File data) {
        if (type == null) {
            return null;
        }
        if (data == null) {
            throw new NullPointerException();
        }
        try (InputStream input = Files.newInputStream(data.toPath(), new OpenOption[0]);){
            SignatureTypedValue signatureTypedValue = MigrationCryptoUtils.computeSignature(type, privateKey, input);
            return signatureTypedValue;
        }
        catch (IOException ex) {
            throw new MigrationCheckException((Throwable)ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static SignatureTypedValue computeSignature(SignatureType type, String privateKey, byte[] data) {
        if (type == null) {
            return null;
        }
        if (data == null) {
            throw new NullPointerException();
        }
        try (ByteArrayInputStream input = new ByteArrayInputStream(data);){
            SignatureTypedValue signatureTypedValue = MigrationCryptoUtils.computeSignature(type, privateKey, input);
            return signatureTypedValue;
        }
        catch (IOException ex) {
            throw new MigrationCheckException((Throwable)ex);
        }
    }

    private static String loadSignaturePrivateKey(SignatureType type, String privateKey) {
        if (MigrationCryptoUtils.isExternalLocation(privateKey = StringUtils.trim((String)privateKey))) {
            String result = MigrationCryptoUtils.loadExternalKey(privateKey);
            if (result == null) {
                throw new MigrationCheckException();
            }
            return result;
        }
        return privateKey;
    }

    public static boolean verifySignature(SignatureTypedValue signature, Set<String> publicKeys, InputStream data) {
        if (signature == null) {
            return true;
        }
        try {
            SignatureType type = signature.getType();
            String value = signature.getValue();
            switch (type) {
                case RSA: {
                    Set loadedPublicKeys = Optional.ofNullable(publicKeys).map(set -> set.size() > 0 ? set : null).orElse(Collections.singleton(DEFAULT_RSA_PUBLIC_KEY)).stream().map(key -> MigrationCryptoUtils.loadSignaturePublicKey(type, key)).collect(Collectors.toSet());
                    for (String publicKey : loadedPublicKeys) {
                        Signature rsaSignature = MigrationCryptoUtils.doRsaSignature(type, publicKey, true);
                        try (SignatureOutputStream outputStream = new SignatureOutputStream(rsaSignature);){
                            IOUtils.copy((InputStream)data, (OutputStream)outputStream);
                        }
                        if (!rsaSignature.verify(MigrationCryptoUtils.decodeBase64(value))) continue;
                        return true;
                    }
                    return false;
                }
            }
            throw new MigrationCheckException("signature verify algorithm " + type + " not implemented yet");
        }
        catch (IOException | SignatureException ex) {
            throw new MigrationCheckException(MigrationExceptionEnum.CHECK_EXCEPTION.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean verifySignature(SignatureTypedValue signature, Set<String> publicKeys, File data) {
        if (signature == null) {
            return true;
        }
        if (data == null) {
            throw new NullPointerException();
        }
        try (InputStream input = Files.newInputStream(data.toPath(), new OpenOption[0]);){
            boolean bl = MigrationCryptoUtils.verifySignature(signature, publicKeys, input);
            return bl;
        }
        catch (IOException ex) {
            throw new MigrationCheckException(MigrationExceptionEnum.CHECK_EXCEPTION.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean verifySignature(SignatureTypedValue signature, Set<String> publicKeys, byte[] data) {
        if (signature == null) {
            return true;
        }
        if (data == null) {
            throw new NullPointerException();
        }
        try (ByteArrayInputStream input = new ByteArrayInputStream(data);){
            boolean bl = MigrationCryptoUtils.verifySignature(signature, publicKeys, input);
            return bl;
        }
        catch (IOException ex) {
            throw new MigrationCheckException((Throwable)ex);
        }
    }

    private static String loadSignaturePublicKey(SignatureType type, String publicKey) {
        if (MigrationCryptoUtils.isExternalLocation(publicKey = StringUtils.trim((String)publicKey))) {
            String result = MigrationCryptoUtils.loadExternalKey(publicKey);
            if (result == null) {
                throw new MigrationCheckException();
            }
            return result;
        }
        return publicKey;
    }

    private static Signature doRsaSignature(SignatureType type, String key, boolean verify) {
        if (type == null || key == null) {
            throw new NullPointerException();
        }
        try {
            Signature rsaSignature;
            switch (type) {
                case RSA: {
                    rsaSignature = Signature.getInstance("SHA256withRSA");
                    break;
                }
                default: {
                    throw new MigrationCheckException("signature algorithm " + type + " not implemented yet");
                }
            }
            if (verify) {
                X509EncodedKeySpec rsaPublicKeySpec = new X509EncodedKeySpec(MigrationCryptoUtils.decodeBase64(key));
                PublicKey rsaPublicKey = KeyFactory.getInstance("RSA").generatePublic(rsaPublicKeySpec);
                rsaSignature.initVerify(rsaPublicKey);
            } else {
                PKCS8EncodedKeySpec rsaPrivateKeySpec = new PKCS8EncodedKeySpec(MigrationCryptoUtils.decodeBase64(key));
                PrivateKey rsaPrivateKey = KeyFactory.getInstance("RSA").generatePrivate(rsaPrivateKeySpec);
                rsaSignature.initSign(rsaPrivateKey);
            }
            return rsaSignature;
        }
        catch (NoSuchAlgorithmException ex) {
            throw new MigrationCheckException("cannot get signature instance for algorithm " + type, (Throwable)ex);
        }
        catch (InvalidKeyException | InvalidKeySpecException ex) {
            if (verify) {
                throw new MigrationCheckException("cannot initialize " + type + " public key for verification", (Throwable)ex);
            }
            throw new MigrationCheckException("cannot initialize " + type + " private key for signature", (Throwable)ex);
        }
    }

    public static void encrypt(EncryptionType type, String key, InputStream source, OutputStream destination) {
        block15: {
            try {
                if (type == null) {
                    IOUtils.copy((InputStream)source, (OutputStream)destination);
                    break block15;
                }
                Cipher cipher = MigrationCryptoUtils.createCipher(type, key, false);
                try (CipherOutputStream output = new CipherOutputStream(destination, cipher);){
                    IOUtils.copy((InputStream)source, (OutputStream)output);
                }
            }
            catch (IOException ex) {
                throw new MigrationCryptoException((Throwable)ex);
            }
        }
    }

    public static void encrypt(EncryptionType type, String key, File source, File destination) {
        block27: {
            try {
                if (type == null) {
                    FileUtils.copyFile((File)source, (File)destination);
                    break block27;
                }
                try (InputStream input = Files.newInputStream(source.toPath(), new OpenOption[0]);
                     OutputStream output = Files.newOutputStream(destination.toPath(), new OpenOption[0]);){
                    MigrationCryptoUtils.encrypt(type, key, input, output);
                }
            }
            catch (IOException ex) {
                throw new MigrationCryptoException((Throwable)ex);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] encrypt(EncryptionType type, String key, byte[] data) {
        if (type == null) {
            return data;
        }
        try (ByteArrayInputStream input = new ByteArrayInputStream(data);){
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            MigrationCryptoUtils.encrypt(type, key, input, output);
            byte[] byArray = output.toByteArray();
            return byArray;
        }
        catch (IOException ex) {
            throw new MigrationCryptoException((Throwable)ex);
        }
    }

    public static void decrypt(EncryptionType type, String key, InputStream source, OutputStream destination) {
        block15: {
            try {
                if (type == null) {
                    IOUtils.copy((InputStream)source, (OutputStream)destination);
                    break block15;
                }
                Cipher cipher = MigrationCryptoUtils.createCipher(type, key, true);
                try (CipherOutputStream output = new CipherOutputStream(destination, cipher);){
                    IOUtils.copy((InputStream)source, (OutputStream)output);
                }
            }
            catch (IOException ex) {
                throw new MigrationCryptoException((Throwable)ex);
            }
        }
    }

    public static void decrypt(EncryptionType type, String key, File source, File destination) {
        block27: {
            try {
                if (type == null) {
                    FileUtils.copyFile((File)source, (File)destination);
                    break block27;
                }
                try (InputStream input = Files.newInputStream(source.toPath(), new OpenOption[0]);
                     OutputStream output = Files.newOutputStream(destination.toPath(), new OpenOption[0]);){
                    MigrationCryptoUtils.decrypt(type, key, input, output);
                }
            }
            catch (IOException ex) {
                throw new MigrationCryptoException((Throwable)ex);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] decrypt(EncryptionType type, String key, byte[] data) {
        if (type == null) {
            return data;
        }
        try (ByteArrayInputStream input = new ByteArrayInputStream(data);){
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            MigrationCryptoUtils.decrypt(type, key, input, output);
            byte[] byArray = output.toByteArray();
            return byArray;
        }
        catch (IOException ex) {
            throw new MigrationCryptoException((Throwable)ex);
        }
    }

    private static Cipher createCipher(EncryptionType type, String key, boolean decrypt) {
        if (type == null) {
            throw new NullPointerException();
        }
        try {
            switch (type) {
                case AES: {
                    key = key != null ? key : DEFAULT_AES_KEY;
                    String loadedKey = decrypt ? MigrationCryptoUtils.loadDecryptKey(type, key) : MigrationCryptoUtils.loadEncryptKey(type, key);
                    PBEKeySpec pbkdf2KeySpec = new PBEKeySpec(loadedKey.toCharArray(), new byte[16], 16384, 128);
                    byte[] aesKey = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1").generateSecret(pbkdf2KeySpec).getEncoded();
                    SecretKeySpec aesKeySpec = new SecretKeySpec(aesKey, "AES");
                    Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5PADDING");
                    cipher.init(decrypt ? 2 : 1, aesKeySpec);
                    return cipher;
                }
            }
            throw new MigrationCryptoException("encryption algorithm " + type + " not implemented yet");
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | InvalidKeySpecException | NoSuchPaddingException ex) {
            throw new MigrationCryptoException((Throwable)ex);
        }
    }

    private static String loadEncryptKey(EncryptionType type, String key) {
        if (MigrationCryptoUtils.isExternalLocation(key = StringUtils.trim((String)key))) {
            String result = MigrationCryptoUtils.loadExternalKey(key);
            if (result == null) {
                throw new MigrationCryptoException();
            }
            return result;
        }
        return key;
    }

    private static String loadDecryptKey(EncryptionType type, String key) {
        if (MigrationCryptoUtils.isExternalLocation(key = StringUtils.trim((String)key))) {
            String result = MigrationCryptoUtils.loadExternalKey(key);
            if (result == null) {
                throw new MigrationCryptoException();
            }
            return result;
        }
        return key;
    }

    private static boolean isExternalLocation(String key) {
        return key != null && EXTERNAL_KEY_PATTERN.matcher(key).matches();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String loadExternalKey(String key) {
        Resource resource = new DefaultResourceLoader().getResource(key);
        if (!resource.exists()) {
            return null;
        }
        try (InputStream input = resource.getInputStream();){
            byte[] data = IOUtils.toByteArray((InputStream)input);
            String text = new String(data, StandardCharsets.UTF_8);
            String string = StringUtils.trim((String)text);
            return string;
        }
        catch (IOException ex) {
            logger.error("failed to load external key", (Throwable)ex);
            return null;
        }
    }

    private static String encodeBase64(byte[] bytes) {
        return Base64.getEncoder().encodeToString(bytes);
    }

    private static byte[] decodeBase64(String base64) {
        return Base64.getDecoder().decode(base64.replaceAll("\\s", ""));
    }

    private static <T extends Enum<T>> T parseEnum(Class<T> clazz, String literal) {
        if (StringUtils.isNotEmpty((CharSequence)literal)) {
            try {
                return Enum.valueOf(clazz, literal.toUpperCase());
            }
            catch (IllegalArgumentException ex) {
                throw new MigrationCheckException("unsupported " + clazz.getSimpleName() + " value: " + literal, (Throwable)ex);
            }
        }
        return null;
    }

    private static final class SignatureOutputStream
    extends OutputStream {
        private final Signature signature;

        public SignatureOutputStream(Signature signature) {
            this.signature = signature;
        }

        @Override
        public void write(int b) throws IOException {
            try {
                this.signature.update((byte)b);
            }
            catch (SignatureException ex) {
                throw new IOException(ex);
            }
        }

        @Override
        public void write(@NonNull byte[] bytes) throws IOException {
            this.write(bytes, 0, bytes.length);
        }

        @Override
        public void write(@NonNull byte[] bytes, int offset, int len) throws IOException {
            try {
                this.signature.update(bytes, offset, len);
            }
            catch (SignatureException ex) {
                throw new IOException(ex);
            }
        }
    }

    public static final class SignatureTypedValue {
        private final SignatureType type;
        private final String value;

        private SignatureTypedValue(SignatureType type, String value) {
            if (type == null || value == null) {
                throw new NullPointerException();
            }
            this.type = type;
            this.value = value;
        }

        public static SignatureTypedValue of(SignatureType type, String value) {
            return new SignatureTypedValue(type, value);
        }

        public static SignatureTypedValue parse(String literal) {
            if (StringUtils.isEmpty((CharSequence)literal)) {
                return null;
            }
            String[] fields = literal.split(":", 2);
            if (fields.length != 2) {
                throw new MigrationCheckException("illegal signature literal: " + literal);
            }
            SignatureType type = (SignatureType)MigrationCryptoUtils.parseEnum(SignatureType.class, fields[0]);
            String value = fields[1];
            return SignatureTypedValue.of(type, value);
        }

        public SignatureType getType() {
            return this.type;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return this.type.toString().toLowerCase() + ':' + this.value;
        }
    }

    public static final class ChecksumTypedValue {
        private final ChecksumType type;
        private final String value;

        private ChecksumTypedValue(ChecksumType type, String value) {
            if (type == null || value == null) {
                throw new NullPointerException();
            }
            this.type = type;
            this.value = value;
        }

        public static ChecksumTypedValue of(ChecksumType type, String value) {
            return new ChecksumTypedValue(type, value);
        }

        public static ChecksumTypedValue parse(String literal) {
            if (StringUtils.isEmpty((CharSequence)literal)) {
                return null;
            }
            String[] fields = literal.split(":", 2);
            if (fields.length != 2) {
                throw new MigrationCheckException("illegal checksum literal: " + literal);
            }
            ChecksumType type = (ChecksumType)MigrationCryptoUtils.parseEnum(ChecksumType.class, fields[0]);
            String value = fields[1];
            return ChecksumTypedValue.of(type, value);
        }

        public ChecksumType getType() {
            return this.type;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return this.type.toString().toLowerCase() + ':' + this.value;
        }
    }
}

