/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.migration.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.CoreVersion;
import com.jxdinfo.hussar.common.base.PageInfo;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.common.utils.HussarPageUtils;
import com.jxdinfo.hussar.common.utils.IdempotentJsonUtils;
import com.jxdinfo.hussar.migration.constants.MigrationExceptionEnum;
import com.jxdinfo.hussar.migration.constants.MigrationLoadStatus;
import com.jxdinfo.hussar.migration.constants.MigrationTaskStatus;
import com.jxdinfo.hussar.migration.dto.MigrationLoadDto;
import com.jxdinfo.hussar.migration.dto.MigrationLoadItemDto;
import com.jxdinfo.hussar.migration.dto.MigrationLoadListDto;
import com.jxdinfo.hussar.migration.dto.MigrationPreloadDto;
import com.jxdinfo.hussar.migration.exceptions.MigrationArchiveException;
import com.jxdinfo.hussar.migration.exceptions.MigrationCheckException;
import com.jxdinfo.hussar.migration.exceptions.MigrationCryptoException;
import com.jxdinfo.hussar.migration.exceptions.MigrationException;
import com.jxdinfo.hussar.migration.exceptions.MigrationFormatCheckException;
import com.jxdinfo.hussar.migration.manager.HussarBaseMigrationLoadRecordManager;
import com.jxdinfo.hussar.migration.manager.HussarBaseMigrationLogManager;
import com.jxdinfo.hussar.migration.manager.HussarBaseMigrationStorageManager;
import com.jxdinfo.hussar.migration.manager.HussarBaseMigrationTaskManager;
import com.jxdinfo.hussar.migration.manifest.MigrationArchiveItem;
import com.jxdinfo.hussar.migration.manifest.MigrationArchiveManifest;
import com.jxdinfo.hussar.migration.model.MigrationLoadModel;
import com.jxdinfo.hussar.migration.plugin.MigrationPlugin;
import com.jxdinfo.hussar.migration.plugin.MigrationPluginHolder;
import com.jxdinfo.hussar.migration.plugin.MigrationPluginMetadata;
import com.jxdinfo.hussar.migration.plugin.context.AbstractMigrationReadonlyContext;
import com.jxdinfo.hussar.migration.plugin.context.MigrationLoadContext;
import com.jxdinfo.hussar.migration.plugin.context.MigrationPreloadContext;
import com.jxdinfo.hussar.migration.plugin.vo.MigrationLoadItemVo;
import com.jxdinfo.hussar.migration.plugin.vo.MigrationPreloadItemVo;
import com.jxdinfo.hussar.migration.properties.HussarBaseMigrationProperties;
import com.jxdinfo.hussar.migration.service.HussarBaseMigrationLoadService;
import com.jxdinfo.hussar.migration.utils.MigrationArchiveUtils;
import com.jxdinfo.hussar.migration.utils.MigrationContextUtils;
import com.jxdinfo.hussar.migration.utils.MigrationExceptionUtils;
import com.jxdinfo.hussar.migration.utils.MigrationUnarchiveOptions;
import com.jxdinfo.hussar.migration.vo.MigrationDetailItemVo;
import com.jxdinfo.hussar.migration.vo.MigrationDetailVo;
import com.jxdinfo.hussar.migration.vo.MigrationLoadRecordVo;
import com.jxdinfo.hussar.migration.vo.MigrationLoadReportVo;
import com.jxdinfo.hussar.migration.vo.MigrationPreloadReportVo;
import com.jxdinfo.hussar.migration.vo.MigrationUploadVo;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.http.HussarHttpServletRequest;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.tenant.common.util.HussarContextHolder;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.AsyncContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.multipart.MultipartFile;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.migration.service.impl.hussarBaseMigrationLoadServiceImpl")
public class HussarBaseMigrationLoadServiceImpl
implements HussarBaseMigrationLoadService {
    private static final Logger logger = LoggerFactory.getLogger(HussarBaseMigrationLoadServiceImpl.class);
    private static final boolean DEFAULT_SKIP_STRICT_VERSION_CHECK = false;
    private static final boolean DEFAULT_SKIP_CHECKSUM_VERIFY = false;
    private static final boolean DEFAULT_SKIP_SIGNATURE_VERIFY = false;
    private static final String MESSAGE_PRELOAD_SUCCESS = "\u6210\u529f\u6267\u884c %d \u79cd\u7c7b\u578b\u6570\u636e\u7684\u5bfc\u5165\u524d\u6821\u9a8c";
    private static final String MESSAGE_LOAD_SUCCESS = "\u6210\u529f\u5bfc\u5165 %d \u79cd\u4e1a\u52a1\u7c7b\u578b\uff0c\u603b\u8ba1 %d \u6761\u6570\u636e";
    private static final String MESSAGE_PRELOAD_FAILED = "\u68c0\u67e5\u9636\u6bb5\u6267\u884c\u5931\u8d25";
    private static final String MESSAGE_LOAD_FAILED = "\u5bfc\u5165\u9636\u6bb5\u6267\u884c\u5931\u8d25";
    private static final String MESSAGE_ITEM_PRELOAD_FAILED = "\u68c0\u67e5\u6761\u76ee %s \u5931\u8d25";
    private static final String MESSAGE_ITEM_LOAD_FAILED = "\u5bfc\u5165\u6761\u76ee %s \u5931\u8d25";
    private static final String MESSAGE_SERVICE_INCOMPATIBLE = "\u5bfc\u5165\u6761\u76ee %s \u7248\u672c\u53f7\u4e0d\u517c\u5bb9";
    private static final String MESSAGE_PLATFORM_INCOMPATIBLE = "\u5bfc\u5165\u5e73\u53f0\u7248\u672c %s \u4e0e\u5bfc\u51fa\u6765\u6e90\u5e73\u53f0\u7248\u672c %s \u4e0d\u517c\u5bb9";
    private static final String MESSAGE_ARCHIVE_NOT_FOUND = "\u5bfc\u5165\u5305\u4e0d\u5b58\u5728";
    private static final String MESSAGE_ARCHIVE_MANIFEST_PARSE_FAILED = "\u5bfc\u5165\u5305\u5143\u4fe1\u606f\u6570\u636e\u89e3\u6790\u5931\u8d25";
    private static final String MESSAGE_ITEM_MISSING_UUID = "\u89e3\u6790\u5bfc\u5165\u5305\u6761\u76ee\u7f3a\u5c11\u552f\u4e00\u6807\u8bc6\u7b26";
    private static final String MESSAGE_ITEM_MISSING_TYPE = "\u89e3\u6790\u5bfc\u5165\u5305\u6761\u76ee\u7f3a\u5c11\u4e1a\u52a1\u7c7b\u578b\u6807\u8bc6";
    private static final String MESSAGE_BAD_PRELOAD_TASK_STATUS = "\u6821\u9a8c\u9636\u6bb5\u6267\u884c\u7ed3\u679c\u7f3a\u5c11\u5b8c\u6210\u6216\u5931\u8d25\u7684\u6267\u884c\u72b6\u6001";
    private static final String MESSAGE_BAD_LOAD_TASK_STATUS = "\u5bfc\u5165\u9636\u6bb5\u6267\u884c\u7ed3\u679c\u7f3a\u5c11\u5b8c\u6210\u6216\u5931\u8d25\u7684\u6267\u884c\u72b6\u6001";
    private static final String MESSAGE_FAILED_PRELOAD_ITEM_STATUS = "\u6821\u9a8c\u9636\u6bb5\u4e1a\u52a1\u6761\u76ee %s (%s) \u6267\u884c\u8fd4\u56de\u5931\u8d25\u7ed3\u679c";
    private static final String MESSAGE_INVALID_PRELOAD_ITEM_STATUS = "\u6821\u9a8c\u9636\u6bb5\u4e1a\u52a1\u6761\u76ee %s (%s) \u6267\u884c\u8fd4\u56de\u72b6\u6001\u7801\u4e0d\u662f\u5b8c\u6210\u6216\u5931\u8d25";
    private static final String MESSAGE_FAILED_LOAD_ITEM_STATUS = "\u5bfc\u5165\u9636\u6bb5\u4e1a\u52a1\u6761\u76ee %s (%s) \u6267\u884c\u8fd4\u56de\u5931\u8d25\u7ed3\u679c";
    private static final String MESSAGE_INVALID_LOAD_ITEM_STATUS = "\u5bfc\u5165\u9636\u6bb5\u4e1a\u52a1\u6761\u76ee %s (%s) \u6267\u884c\u8fd4\u56de\u72b6\u6001\u7801\u4e0d\u662f\u5b8c\u6210\u6216\u5931\u8d25";
    private static final String WORKSPACE_PREFIX = "hussar-load-workspace-";
    @Autowired
    private HussarBaseMigrationProperties properties;
    @Autowired
    private HussarBaseMigrationLoadRecordManager loadRecordManager;
    @Autowired
    private HussarBaseMigrationTaskManager taskManager;
    @Autowired
    private HussarBaseMigrationStorageManager storageManager;
    @Autowired
    private HussarBaseMigrationLogManager logManager;

    public ApiResponse<MigrationUploadVo> upload(MultipartFile archive) {
        MigrationLoadModel record = null;
        try {
            boolean twiceLoad;
            File upload = Files.createTempFile("archive_load_", ".hussar", new FileAttribute[0]).toFile();
            FileUtils.copyInputStreamToFile((InputStream)archive.getInputStream(), (File)upload);
            record = new MigrationLoadModel();
            MigrationDetailVo detailVo = this.doParse(upload);
            String uuid = detailVo.getUuid();
            String description = detailVo.getDescription();
            List<MigrationLoadRecordVo> twiceLoadTasks = this.loadRecordManager.getTwiceLoadedTasks(uuid);
            MigrationLoadRecordVo twiceLoadTopRankedTask = this.pickTwiceLoadTopRankedTask(twiceLoadTasks);
            boolean bl = twiceLoad = twiceLoadTasks.size() > 0;
            if (twiceLoad) {
                logger.warn("archive upload: archive uuid {} already exists", (Object)uuid);
            }
            String filename = "archive_load_" + new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()) + "-" + Hex.encodeHexString((byte[])DigestUtils.digest((MessageDigest)MessageDigest.getInstance("SHA-1"), (File)upload)).substring(0, 12) + ".hussar";
            String handle = this.storageManager.upload(filename, upload);
            try {
                FileUtils.forceDelete((File)upload);
            }
            catch (IOException ex) {
                logger.warn("failed to remove temporary uploaded archive");
            }
            record.setLoadStatus(1);
            record.setArchiveUuid(uuid);
            record.setArchiveDescription(description);
            record.setArchiveFile(handle);
            SecurityUser user = BaseSecurityUtil.getUser();
            if (user != null) {
                record.setCreator(user.getUserId());
            }
            record.setCreateTime(LocalDateTime.now());
            this.loadRecordManager.saveOrUpdate((Object)record);
            logger.info("created migration load task {} status {}", (Object)record.getId(), (Object)MigrationLoadStatus.display((Integer)record.getLoadStatus()));
            String encodedArchiveDetail = this.logManager.encode(String.format("load_%s_log.upload_result_", record.getId()), detailVo);
            record.setArchiveDetail(encodedArchiveDetail);
            this.loadRecordManager.saveOrUpdate((Object)record);
            MigrationUploadVo resultVo = new MigrationUploadVo();
            resultVo.setLoadId(record.getId());
            resultVo.setTwiceLoad(Boolean.valueOf(twiceLoad));
            resultVo.setTwiceLoadAmount(Integer.valueOf(twiceLoadTasks.size()));
            resultVo.setTwiceLoadTopRankedTask(twiceLoadTopRankedTask);
            return ApiResponse.success((Object)resultVo);
        }
        catch (MigrationArchiveException ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            return ApiResponse.fail((int)MigrationExceptionEnum.ARCHIVE_UPLOAD_EXCEPTION.getCode(), (String)MigrationExceptionEnum.ARCHIVE_UPLOAD_EXCEPTION.getMessage());
        }
        catch (MigrationCheckException ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            return ApiResponse.fail((int)MigrationExceptionEnum.CHECK_EXCEPTION.getCode(), (String)MigrationExceptionEnum.CHECK_EXCEPTION.getMessage());
        }
        catch (MigrationCryptoException ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            return ApiResponse.fail((int)MigrationExceptionEnum.CRYPTO_EXCEPTION.getCode(), (String)MigrationExceptionEnum.CRYPTO_EXCEPTION.getMessage());
        }
        catch (MigrationFormatCheckException ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            return ApiResponse.fail((int)MigrationExceptionEnum.FORMAT_CHECK_EXCEPTION.getCode(), (String)MigrationExceptionEnum.FORMAT_CHECK_EXCEPTION.getMessage());
        }
        catch (Exception ex) {
            logger.error("failed to handle archive upload", (Throwable)ex);
            return ApiResponse.fail((int)MigrationExceptionEnum.UNHANDLED_MIGRATION_EXCEPTION.getCode(), (String)MigrationExceptionEnum.UNHANDLED_MIGRATION_EXCEPTION.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MigrationDetailVo doParse(File archive) {
        File workspace = null;
        MigrationDetailVo detailVo = new MigrationDetailVo();
        try {
            UnarchiveProfile profile = new UnarchiveProfile();
            File finalWorkspace = workspace = this.unarchive(archive, profile);
            MigrationArchiveManifest manifest = this.loadManifest(workspace);
            detailVo.setVersion(manifest.getVersion());
            detailVo.setFull(manifest.isFull());
            detailVo.setUnified(manifest.isUnified());
            detailVo.setUuid(manifest.getUuid());
            detailVo.setDescription(manifest.getDescription());
            detailVo.setTags(manifest.getTags());
            List items = Optional.ofNullable(manifest.getItems()).orElse(Collections.emptyList());
            List itemVoList = items.stream().filter(Objects::nonNull).map(item -> {
                MigrationDetailItemVo itemVo = new MigrationDetailItemVo();
                itemVo.setUuid(item.getUuid());
                itemVo.setType(item.getType());
                itemVo.setVersion(item.getVersion());
                itemVo.setDescription(item.getDescription());
                itemVo.setAttributes(item.getAttributes());
                itemVo.setPayloads((List)Optional.ofNullable(item.getUuid()).map(uuid -> MigrationContextUtils.getPayloadList(new File(finalWorkspace, (String)uuid))).orElse(null));
                return itemVo;
            }).collect(Collectors.toList());
            detailVo.setItems(itemVoList);
            for (MigrationDetailItemVo itemVo : itemVoList) {
                String uuid = itemVo.getUuid();
                String type = itemVo.getType();
                if (uuid == null) {
                    throw new MigrationFormatCheckException(MESSAGE_ITEM_MISSING_UUID);
                }
                if (type != null) continue;
                throw new MigrationFormatCheckException(MESSAGE_ITEM_MISSING_TYPE);
            }
            MigrationDetailVo migrationDetailVo = detailVo;
            return migrationDetailVo;
        }
        finally {
            if (workspace != null && workspace.exists()) {
                try {
                    FileUtils.forceDelete((File)workspace);
                }
                catch (IOException ex) {
                    logger.warn("failed to delete temporary parse and verify workspace", (Throwable)ex);
                }
            }
        }
    }

    private MigrationLoadRecordVo pickTwiceLoadTopRankedTask(List<MigrationLoadRecordVo> twiceLoadedTasks) {
        ArrayList<MigrationLoadRecordVo> sortedTasks = new ArrayList<MigrationLoadRecordVo>(twiceLoadedTasks);
        sortedTasks.sort(Comparator.comparing(MigrationLoadRecordVo::getCreateTime).reversed());
        sortedTasks.sort(Comparator.comparing(task -> MigrationLoadStatus.isTerminated((Integer)task.getLoadStatus())));
        return sortedTasks.size() > 0 ? (MigrationLoadRecordVo)sortedTasks.get(0) : null;
    }

    public ApiResponse<Boolean> preload(MigrationPreloadDto migrationPreloadDto) {
        if (migrationPreloadDto == null) {
            return ApiResponse.fail((int)MigrationExceptionEnum.MIGRATION_ILLEGAL_DTO_EXCEPTION.getCode(), (String)MigrationExceptionEnum.MIGRATION_ILLEGAL_DTO_EXCEPTION.getMessage());
        }
        MigrationLoadModel record = (MigrationLoadModel)((Object)this.loadRecordManager.getById(migrationPreloadDto.getLoadId()));
        if (record == null) {
            return ApiResponse.fail((int)MigrationExceptionEnum.TASK_NOT_FOUND_EXCEPTION.getCode(), (String)MigrationExceptionEnum.TASK_NOT_FOUND_EXCEPTION.getMessage());
        }
        if (!Objects.equals(record.getLoadStatus(), 1)) {
            return ApiResponse.fail((int)MigrationExceptionEnum.TASK_NOT_READY_PRELOAD_EXCEPTION.getCode(), (String)MigrationExceptionEnum.TASK_NOT_READY_PRELOAD_EXCEPTION.getMessage());
        }
        record.setLoadStatus(2);
        record.setLoadExplanation(migrationPreloadDto.getLoadExplanation());
        String encodedPreloadParametersLog = this.logManager.encode(String.format("load_%s_log.preload_params_", record.getId()), migrationPreloadDto);
        record.setPreloadParameters(encodedPreloadParametersLog);
        this.loadRecordManager.saveOrUpdate((Object)record);
        logger.info("migration preload task {} status: {}", (Object)record.getId(), (Object)MigrationLoadStatus.display((Integer)record.getLoadStatus()));
        String connName = HussarContextHolder.getConnName();
        String tenantCode = HussarContextHolder.getHussarTenant().getTenantCode();
        ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        ServletRequestAttributes newServletRequestAttributes = new ServletRequestAttributes((HttpServletRequest)new HussarHttpServletRequest(servletRequestAttributes.getRequest()));
        AsyncContext asyncContext = null;
        if (HussarUtils.isNotEmpty((Object)servletRequestAttributes)) {
            HttpServletRequest request = servletRequestAttributes.getRequest();
            asyncContext = request.startAsync();
        }
        AsyncContext finalAsyncContext = asyncContext;
        this.taskManager.schedule(false, () -> {
            block28: {
                RequestContextHolder.setRequestAttributes((RequestAttributes)newServletRequestAttributes);
                HussarContextHolder.setTenant((String)connName, (String)tenantCode);
                File workspace = null;
                record.setLoadStatus(3);
                record.setPreloadStart(LocalDateTime.now());
                this.loadRecordManager.saveOrUpdate((Object)record);
                logger.info("migration preload task {} status: {}", (Object)record.getId(), (Object)MigrationLoadStatus.display((Integer)record.getLoadStatus()));
                logger.info("migration preload task {} execute stage: PARSE", (Object)record.getId());
                UnarchiveProfile profile = new UnarchiveProfile(migrationPreloadDto);
                workspace = this.fetchAndUnarchive(record.getArchiveFile(), profile);
                MigrationArchiveManifest manifest = this.loadManifest(workspace);
                this.doVerify(record, migrationPreloadDto, manifest);
                logger.info("migration preload task {} execute stage: PREPARE", (Object)record.getId());
                List<ArchiveItemExecution<Object>> executions = this.buildExecutions(manifest.getItems(), null);
                logger.info("migration preload task {} execute stage: RUNNING", (Object)record.getId());
                MigrationPreloadReportVo preloadReport = this.doPreload(record, executions, workspace, manifest, this.properties.isFastFail());
                logger.info("migration preload task {} execute stage: POSTPROCESS", (Object)record.getId());
                String encodedPreloadResultLog = this.logManager.encode(String.format("load_%s_log.preload_result_", record.getId()), preloadReport);
                record.setPreloadResult(encodedPreloadResultLog);
                if (MigrationTaskStatus.isSuccess((Integer)preloadReport.getStatus())) {
                    record.setLoadStatus(4);
                } else if (MigrationTaskStatus.isFailed((Integer)preloadReport.getStatus())) {
                    record.setLoadStatus(-1);
                    record.setLoadError(preloadReport.getMessage());
                } else {
                    throw new MigrationException(MESSAGE_BAD_PRELOAD_TASK_STATUS);
                }
                record.setPreloadEnd(LocalDateTime.now());
                try {
                    this.loadRecordManager.saveOrUpdate((Object)record);
                    logger.info("migration preload task {} status: {}", (Object)record.getId(), (Object)MigrationLoadStatus.display((Integer)record.getLoadStatus()));
                }
                catch (Exception ex) {
                    logger.error("failed to update migration preload record", (Throwable)ex);
                }
                if (workspace != null) {
                    try {
                        FileUtils.forceDelete((File)workspace);
                    }
                    catch (IOException ex) {
                        logger.warn("failed to delete temporary preload workspace", (Throwable)ex);
                    }
                }
                if (HussarUtils.isNotEmpty((Object)finalAsyncContext)) {
                    finalAsyncContext.complete();
                }
                break block28;
                catch (Exception ex) {
                    try {
                        logger.error("migration preload thread failed", (Throwable)ex);
                        record.setLoadStatus(-1);
                        record.setLoadError("\u68c0\u67e5\u9636\u6bb5\u6267\u884c\u5931\u8d25: " + ex);
                        try {
                            MigrationPreloadReportVo preloadErrorReport = new MigrationPreloadReportVo();
                            preloadErrorReport.setStatus(Integer.valueOf(-1));
                            preloadErrorReport.setMessage("\u68c0\u67e5\u9636\u6bb5\u6267\u884c\u5931\u8d25: " + MigrationExceptionUtils.toMessage(ex));
                            String encodedPreloadResultLog2 = this.logManager.encode(String.format("load_%s_log.preload_result_", record.getId()), preloadErrorReport);
                            record.setPreloadResult(encodedPreloadResultLog2);
                        }
                        catch (Exception innerEx) {
                            logger.error("failed to flush back migration preload thread failure message", (Throwable)innerEx);
                        }
                        record.setPreloadEnd(LocalDateTime.now());
                    }
                    catch (Throwable throwable) {
                        record.setPreloadEnd(LocalDateTime.now());
                        try {
                            this.loadRecordManager.saveOrUpdate((Object)record);
                            logger.info("migration preload task {} status: {}", (Object)record.getId(), (Object)MigrationLoadStatus.display((Integer)record.getLoadStatus()));
                        }
                        catch (Exception ex2) {
                            logger.error("failed to update migration preload record", (Throwable)ex2);
                        }
                        if (workspace != null) {
                            try {
                                FileUtils.forceDelete(workspace);
                            }
                            catch (IOException ex3) {
                                logger.warn("failed to delete temporary preload workspace", (Throwable)ex3);
                            }
                        }
                        if (HussarUtils.isNotEmpty((Object)finalAsyncContext)) {
                            finalAsyncContext.complete();
                        }
                        throw throwable;
                    }
                    try {
                        this.loadRecordManager.saveOrUpdate((Object)record);
                        logger.info("migration preload task {} status: {}", (Object)record.getId(), (Object)MigrationLoadStatus.display((Integer)record.getLoadStatus()));
                    }
                    catch (Exception ex4) {
                        logger.error("failed to update migration preload record", (Throwable)ex4);
                    }
                    if (workspace != null) {
                        try {
                            FileUtils.forceDelete((File)workspace);
                        }
                        catch (IOException ex5) {
                            logger.warn("failed to delete temporary preload workspace", (Throwable)ex5);
                        }
                    }
                    if (HussarUtils.isNotEmpty((Object)finalAsyncContext)) {
                        finalAsyncContext.complete();
                    }
                }
            }
        });
        return ApiResponse.success((Object)true);
    }

    private void doVerify(MigrationLoadModel record, MigrationPreloadDto migrationPreloadDto, MigrationArchiveManifest manifest) {
        boolean skipStrictVersionCheck = Optional.ofNullable(migrationPreloadDto.getSkipStrictVersionCheck()).orElse(false);
        if (!skipStrictVersionCheck) {
            String dumpPlatform = Optional.ofNullable(manifest.getTags()).map(tags -> (String)tags.get("hussar.migration.platform")).orElse(null);
            String loadPlatform = CoreVersion.getFrameworkVersion();
            logger.info("migration preload task {} dump platform: {}, load platform: {}", new Object[]{record.getId(), dumpPlatform, loadPlatform});
            if (dumpPlatform != null && loadPlatform != null && !this.platformCompatible(dumpPlatform, loadPlatform)) {
                throw new MigrationException(String.format(MESSAGE_PLATFORM_INCOMPATIBLE, loadPlatform, dumpPlatform));
            }
            for (MigrationArchiveItem item : Optional.ofNullable(manifest.getItems()).orElse(Collections.emptyList())) {
                String type = item.getType();
                Long currentVersion = item.getVersion();
                MigrationPlugin service = MigrationPluginHolder.lookup(type);
                Long expectVersion = Optional.ofNullable(service.metadata()).map(MigrationPluginMetadata::getVersion).orElse(null);
                if (expectVersion == null || currentVersion == null || Objects.equals(currentVersion, expectVersion)) continue;
                throw new MigrationException(String.format(MESSAGE_SERVICE_INCOMPATIBLE, type) + ": " + currentVersion);
            }
        }
    }

    private MigrationPreloadReportVo doPreload(MigrationLoadModel record, List<ArchiveItemExecution<Object>> executions, File workspace, MigrationArchiveManifest manifest, boolean fastFail) {
        logger.info("migration preload task {} run items: total {}, workspace {}", new Object[]{record.getId(), executions.size(), workspace});
        MigrationPreloadReportVo preloadReport = new MigrationPreloadReportVo();
        try {
            List itemResults = executions.stream().map(execution -> {
                MigrationArchiveItem item = execution.getItem();
                MigrationPreloadItemVo itemResult = MigrationPreloadItemVo.of((Integer)1);
                itemResult.setUuid(item.getUuid());
                itemResult.setType(item.getType());
                return itemResult;
            }).collect(Collectors.toList());
            preloadReport.setItems(itemResults);
            boolean allSuccess = true;
            for (int i = 0; i < executions.size(); ++i) {
                MigrationPreloadItemVo itemResult;
                ArchiveItemExecution<Object> execution2 = executions.get(i);
                MigrationArchiveItem item = execution2.getItem();
                MigrationPlugin service = execution2.getService();
                logger.info("migration preload task {} run item: item {}/{}, uuid {}, service type {}, service class {}", new Object[]{record.getId(), i + 1, executions.size(), item.getUuid(), item.getType(), service.getClass().getName()});
                boolean throwByReturnFailed = false;
                try {
                    ((MigrationPreloadItemVo)itemResults.get(i)).setStatus(Integer.valueOf(2));
                    PreloadItemContext context = new PreloadItemContext(record.getId(), manifest, item, new File(workspace, item.getUuid()));
                    itemResult = service.preload((MigrationPreloadContext)context);
                    itemResult.setUuid(item.getUuid());
                    itemResult.setType(item.getType());
                    itemResults.set(i, itemResult);
                    if (MigrationTaskStatus.isFailed((Integer)itemResult.getStatus())) {
                        throwByReturnFailed = true;
                        throw new MigrationException(String.format(MESSAGE_FAILED_PRELOAD_ITEM_STATUS, item.getUuid(), item.getType()));
                    }
                    if (MigrationTaskStatus.isSuccess((Integer)itemResult.getStatus())) continue;
                    throw new MigrationException(String.format(MESSAGE_INVALID_PRELOAD_ITEM_STATUS, item.getUuid(), item.getType()) + ": " + itemResult.getStatus());
                }
                catch (Exception ex) {
                    logger.error("migration preload item {} ({}) of task {} execute failed", new Object[]{item.getUuid(), item.getType(), record.getId(), ex});
                    itemResult = (MigrationPreloadItemVo)itemResults.get(i);
                    itemResult.setStatus(Integer.valueOf(-1));
                    if (!throwByReturnFailed) {
                        itemResult.setMessage(String.format(MESSAGE_ITEM_PRELOAD_FAILED, item.getType()) + ": " + MigrationExceptionUtils.toMessage(ex));
                    }
                    if (fastFail) {
                        throw ex;
                    }
                    allSuccess = false;
                }
            }
            preloadReport.setStatus(Integer.valueOf(allSuccess ? 0 : -1));
            if (allSuccess) {
                preloadReport.setMessage(String.format(MESSAGE_PRELOAD_SUCCESS, itemResults.size()));
            }
        }
        catch (Exception ex) {
            logger.error("migration preload task {} execute failed", (Object)record.getId(), (Object)ex);
            preloadReport.setStatus(Integer.valueOf(-1));
            preloadReport.setMessage("\u68c0\u67e5\u9636\u6bb5\u6267\u884c\u5931\u8d25: " + MigrationExceptionUtils.toMessage(ex));
        }
        return preloadReport;
    }

    public ApiResponse<MigrationPreloadReportVo> preloadReport(Long loadId) {
        MigrationLoadModel record = (MigrationLoadModel)((Object)this.loadRecordManager.getById(loadId));
        if (record == null) {
            logger.error("migration preload task not found: {}", (Object)loadId);
            return ApiResponse.fail((int)MigrationExceptionEnum.TASK_NOT_FOUND_EXCEPTION.getCode(), (String)MigrationExceptionEnum.TASK_NOT_FOUND_EXCEPTION.getMessage());
        }
        if (!MigrationLoadStatus.isPreloadReportQueryable((Integer)record.getLoadStatus())) {
            logger.error("migration preload report not queryable: task {}, status {}", (Object)loadId, (Object)record.getLoadStatus());
            return ApiResponse.fail((int)MigrationExceptionEnum.TASK_PRELOAD_REPORT_DISALLOWED_EXCEPTION.getCode(), (String)MigrationExceptionEnum.TASK_PRELOAD_REPORT_DISALLOWED_EXCEPTION.getMessage());
        }
        if (record.getPreloadResult() == null) {
            logger.error("migration preload result log not found: task {}, status {}", (Object)loadId, (Object)record.getPreloadResult());
            return ApiResponse.fail((int)MigrationExceptionEnum.TASK_PRELOAD_REPORT_EXCEPTION.getCode(), (String)MigrationExceptionEnum.TASK_PRELOAD_REPORT_EXCEPTION.getMessage());
        }
        try {
            MigrationPreloadReportVo preloadReport = this.logManager.decode(record.getPreloadResult(), MigrationPreloadReportVo.class);
            return ApiResponse.success((Object)preloadReport);
        }
        catch (MigrationException ex) {
            logger.error("failed to decode migration preload result log: task {}, status {}, result {}", new Object[]{loadId, record.getLoadStatus(), record.getPreloadResult(), ex});
            return ApiResponse.fail((int)MigrationExceptionEnum.TASK_PRELOAD_REPORT_EXCEPTION.getCode(), (String)MigrationExceptionEnum.TASK_PRELOAD_REPORT_EXCEPTION.getMessage());
        }
    }

    public ApiResponse<Boolean> load(MigrationLoadDto migrationLoadDto) {
        if (migrationLoadDto == null) {
            return ApiResponse.fail((int)MigrationExceptionEnum.MIGRATION_ILLEGAL_DTO_EXCEPTION.getCode(), (String)MigrationExceptionEnum.MIGRATION_ILLEGAL_DTO_EXCEPTION.getMessage());
        }
        MigrationLoadModel record = (MigrationLoadModel)((Object)this.loadRecordManager.getById(migrationLoadDto.getLoadId()));
        if (record == null) {
            return ApiResponse.fail((int)MigrationExceptionEnum.TASK_NOT_FOUND_EXCEPTION.getCode(), (String)MigrationExceptionEnum.TASK_NOT_FOUND_EXCEPTION.getMessage());
        }
        if (!Objects.equals(record.getLoadStatus(), 4)) {
            return ApiResponse.fail((int)MigrationExceptionEnum.TASK_NOT_READY_LOAD_EXCEPTION.getCode(), (String)MigrationExceptionEnum.TASK_NOT_READY_LOAD_EXCEPTION.getMessage());
        }
        record.setLoadStatus(5);
        String encodedLoadParametersLog = this.logManager.encode(String.format("load_%s_log.load_params_", record.getId()), migrationLoadDto);
        record.setLoadParameters(encodedLoadParametersLog);
        this.loadRecordManager.saveOrUpdate((Object)record);
        logger.info("migration load task {} status: {}", (Object)record.getId(), (Object)MigrationLoadStatus.display((Integer)record.getLoadStatus()));
        String connName = HussarContextHolder.getConnName();
        String tenantCode = HussarContextHolder.getHussarTenant().getTenantCode();
        ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        ServletRequestAttributes newServletRequestAttributes = new ServletRequestAttributes((HttpServletRequest)new HussarHttpServletRequest(servletRequestAttributes.getRequest()));
        AsyncContext asyncContext = null;
        if (HussarUtils.isNotEmpty((Object)servletRequestAttributes)) {
            HttpServletRequest request = servletRequestAttributes.getRequest();
            asyncContext = request.startAsync();
        }
        AsyncContext finalAsyncContext = asyncContext;
        this.taskManager.schedule(true, () -> {
            block29: {
                RequestContextHolder.setRequestAttributes((RequestAttributes)newServletRequestAttributes);
                HussarContextHolder.setTenant((String)connName, (String)tenantCode);
                File workspace = null;
                record.setLoadStatus(6);
                record.setLoadStart(LocalDateTime.now());
                this.loadRecordManager.saveOrUpdate((Object)record);
                logger.info("migration load task {} status: {}", (Object)record.getId(), (Object)MigrationLoadStatus.display((Integer)record.getLoadStatus()));
                logger.info("migration load task {} execute stage: PARSE", (Object)record.getId());
                UnarchiveProfile profile = new UnarchiveProfile(migrationLoadDto);
                workspace = this.fetchAndUnarchive(record.getArchiveFile(), profile);
                MigrationArchiveManifest manifest = this.loadManifest(workspace);
                logger.info("migration load task {} execute stage: PREPARE", (Object)record.getId());
                HashMap paramsCache = new HashMap();
                for (MigrationLoadItemDto dto : Optional.ofNullable(migrationLoadDto.getItems()).orElse(Collections.emptyList())) {
                    if (dto.getUuid() == null) continue;
                    paramsCache.put(dto.getUuid(), dto.getParameters());
                }
                List<ArchiveItemExecution<Object>> executions = this.buildExecutions(manifest.getItems(), paramsCache);
                logger.info("migration load task {} execute stage: RUNNING", (Object)record.getId());
                MigrationLoadReportVo loadReport = this.doLoad(record, executions, workspace, manifest, this.properties.isFastFail());
                logger.info("migration load task {} execute stage: POSTPROCESS", (Object)record.getId());
                String encodedLoadResultLog = this.logManager.encode(String.format("load_%s_log.load_result_", record.getId()), loadReport);
                record.setLoadResult(encodedLoadResultLog);
                if (MigrationTaskStatus.isSuccess((Integer)loadReport.getStatus())) {
                    record.setLoadStatus(0);
                } else if (MigrationTaskStatus.isFailed((Integer)loadReport.getStatus())) {
                    record.setLoadStatus(-2);
                    record.setLoadError(loadReport.getMessage());
                } else {
                    throw new MigrationException(MESSAGE_BAD_LOAD_TASK_STATUS);
                }
                record.setLoadEnd(LocalDateTime.now());
                try {
                    this.loadRecordManager.saveOrUpdate((Object)record);
                    logger.info("migration load task {} status: {}", (Object)record.getId(), (Object)MigrationLoadStatus.display((Integer)record.getLoadStatus()));
                }
                catch (Exception ex) {
                    logger.error("failed to update migration load record", (Throwable)ex);
                }
                if (workspace != null) {
                    try {
                        FileUtils.forceDelete((File)workspace);
                    }
                    catch (IOException ex) {
                        logger.warn("failed to delete temporary load workspace", (Throwable)ex);
                    }
                }
                if (HussarUtils.isNotEmpty((Object)finalAsyncContext)) {
                    finalAsyncContext.complete();
                }
                break block29;
                catch (Exception ex) {
                    try {
                        logger.error("migration load thread failed", (Throwable)ex);
                        record.setLoadStatus(-2);
                        record.setLoadError("\u5bfc\u5165\u9636\u6bb5\u6267\u884c\u5931\u8d25: " + ex);
                        try {
                            MigrationLoadReportVo loadErrorReport = new MigrationLoadReportVo();
                            loadErrorReport.setStatus(Integer.valueOf(-1));
                            loadErrorReport.setMessage("\u5bfc\u5165\u9636\u6bb5\u6267\u884c\u5931\u8d25: " + MigrationExceptionUtils.toMessage(ex));
                            String encodedLoadResultLog2 = this.logManager.encode(String.format("load_%s_log.load_result_", record.getId()), loadErrorReport);
                            record.setLoadResult(encodedLoadResultLog2);
                        }
                        catch (Exception innerEx) {
                            logger.error("failed to flush back migration load thread failure message", (Throwable)innerEx);
                        }
                        record.setLoadEnd(LocalDateTime.now());
                    }
                    catch (Throwable throwable) {
                        record.setLoadEnd(LocalDateTime.now());
                        try {
                            this.loadRecordManager.saveOrUpdate((Object)record);
                            logger.info("migration load task {} status: {}", (Object)record.getId(), (Object)MigrationLoadStatus.display((Integer)record.getLoadStatus()));
                        }
                        catch (Exception ex2) {
                            logger.error("failed to update migration load record", (Throwable)ex2);
                        }
                        if (workspace != null) {
                            try {
                                FileUtils.forceDelete(workspace);
                            }
                            catch (IOException ex3) {
                                logger.warn("failed to delete temporary load workspace", (Throwable)ex3);
                            }
                        }
                        if (HussarUtils.isNotEmpty((Object)finalAsyncContext)) {
                            finalAsyncContext.complete();
                        }
                        throw throwable;
                    }
                    try {
                        this.loadRecordManager.saveOrUpdate((Object)record);
                        logger.info("migration load task {} status: {}", (Object)record.getId(), (Object)MigrationLoadStatus.display((Integer)record.getLoadStatus()));
                    }
                    catch (Exception ex4) {
                        logger.error("failed to update migration load record", (Throwable)ex4);
                    }
                    if (workspace != null) {
                        try {
                            FileUtils.forceDelete((File)workspace);
                        }
                        catch (IOException ex5) {
                            logger.warn("failed to delete temporary load workspace", (Throwable)ex5);
                        }
                    }
                    if (HussarUtils.isNotEmpty((Object)finalAsyncContext)) {
                        finalAsyncContext.complete();
                    }
                }
            }
        });
        return ApiResponse.success((Object)true);
    }

    private MigrationLoadReportVo doLoad(MigrationLoadModel record, List<ArchiveItemExecution<Object>> executions, File workspace, MigrationArchiveManifest manifest, boolean fastFail) {
        logger.info("migration load task {} run items: total {}, workspace {}", new Object[]{record.getId(), executions.size(), workspace});
        MigrationLoadReportVo loadReport = new MigrationLoadReportVo();
        try {
            List itemResults = executions.stream().map(execution -> {
                MigrationArchiveItem item = execution.getItem();
                MigrationLoadItemVo itemResult = MigrationLoadItemVo.of((Integer)1);
                itemResult.setUuid(item.getUuid());
                itemResult.setType(item.getType());
                return itemResult;
            }).collect(Collectors.toList());
            loadReport.setItems(itemResults);
            boolean allSuccess = true;
            for (int i = 0; i < executions.size(); ++i) {
                MigrationLoadItemVo itemResult;
                ArchiveItemExecution<Object> execution2 = executions.get(i);
                MigrationArchiveItem item = execution2.getItem();
                MigrationPlugin service = execution2.getService();
                Map<String, Object> parameters = execution2.getParameters();
                logger.info("migration load task {} run item: item {}/{}, uuid {}, service type {}, service class {}", new Object[]{record.getId(), i + 1, executions.size(), item.getUuid(), item.getType(), service.getClass().getName()});
                boolean throwByReturnFailed = false;
                try {
                    ((MigrationLoadItemVo)itemResults.get(i)).setStatus(Integer.valueOf(2));
                    LoadItemContext context = new LoadItemContext(record.getId(), manifest, item, new File(workspace, item.getUuid()));
                    itemResult = service.load((MigrationLoadContext)context, parameters);
                    itemResult.setUuid(item.getUuid());
                    itemResult.setType(item.getType());
                    itemResults.set(i, itemResult);
                    if (MigrationTaskStatus.isFailed((Integer)itemResult.getStatus())) {
                        throwByReturnFailed = true;
                        throw new MigrationException(String.format(MESSAGE_FAILED_LOAD_ITEM_STATUS, item.getUuid(), item.getType()));
                    }
                    if (MigrationTaskStatus.isSuccess((Integer)itemResult.getStatus())) continue;
                    throw new MigrationException(String.format(MESSAGE_INVALID_LOAD_ITEM_STATUS, item.getUuid(), item.getType()) + ": " + itemResult.getStatus());
                }
                catch (Exception ex) {
                    logger.error("migration load item {} ({}) of task {} execute failed", new Object[]{item.getUuid(), item.getType(), record.getId(), ex});
                    itemResult = (MigrationLoadItemVo)itemResults.get(i);
                    itemResult.setStatus(Integer.valueOf(-1));
                    if (!throwByReturnFailed) {
                        itemResult.setMessage(String.format(MESSAGE_ITEM_LOAD_FAILED, item.getType()) + ": " + MigrationExceptionUtils.toMessage(ex));
                    }
                    if (fastFail) {
                        throw ex;
                    }
                    allSuccess = false;
                }
            }
            loadReport.setStatus(Integer.valueOf(allSuccess ? 0 : -2));
            if (allSuccess) {
                long total = 0L;
                for (MigrationLoadItemVo itemResult : itemResults) {
                    Optional<Long> itemTotal = Optional.ofNullable(itemResult).map(MigrationLoadItemVo::getTotal);
                    if (!itemTotal.isPresent()) {
                        Long loadId = record.getId();
                        String uuid = Optional.ofNullable(itemResult).map(MigrationLoadItemVo::getUuid).orElse(null);
                        String type = Optional.ofNullable(itemResult).map(MigrationLoadItemVo::getType).orElse(null);
                        logger.warn("migration load item {} ({}) of task {} succeed without reporting total data count", new Object[]{uuid, type, loadId});
                    }
                    total += itemTotal.orElse(0L).longValue();
                }
                loadReport.setTotal(Long.valueOf(total));
                loadReport.setMessage(String.format(MESSAGE_LOAD_SUCCESS, itemResults.size(), total));
            }
            if (this.properties.isAutoRemove() && this.storageManager.exists(record.getArchiveFile())) {
                try {
                    logger.info("auto remove archive of succeed load task {}", (Object)record.getId());
                    this.storageManager.remove(record.getArchiveFile());
                }
                catch (Exception ex) {
                    logger.warn("cannot auto remove associated file {} of succeed migration load task {}", (Object)record.getArchiveFile(), (Object)record.getId());
                }
            }
        }
        catch (Exception ex) {
            logger.error("migration load task {} execute failed", (Object)record.getId(), (Object)ex);
            loadReport.setStatus(Integer.valueOf(-2));
            loadReport.setMessage("\u5bfc\u5165\u9636\u6bb5\u6267\u884c\u5931\u8d25: " + MigrationExceptionUtils.toMessage(ex));
        }
        return loadReport;
    }

    public ApiResponse<MigrationLoadReportVo> loadReport(Long loadId) {
        MigrationLoadModel record = (MigrationLoadModel)((Object)this.loadRecordManager.getById(loadId));
        if (record == null) {
            logger.error("migration load task not found: {}", (Object)loadId);
            return ApiResponse.fail((int)MigrationExceptionEnum.TASK_NOT_FOUND_EXCEPTION.getCode(), (String)MigrationExceptionEnum.TASK_NOT_FOUND_EXCEPTION.getMessage());
        }
        if (!MigrationLoadStatus.isLoadReportQueryable((Integer)record.getLoadStatus())) {
            logger.error("migration load report not queryable: task {}, status {}", (Object)loadId, (Object)record.getLoadStatus());
            return ApiResponse.fail((int)MigrationExceptionEnum.TASK_LOAD_REPORT_DISALLOWED_EXCEPTION.getCode(), (String)MigrationExceptionEnum.TASK_LOAD_REPORT_DISALLOWED_EXCEPTION.getMessage());
        }
        if (record.getPreloadResult() == null) {
            logger.error("migration load result log not found: task {}, status {}", (Object)loadId, (Object)record.getPreloadResult());
            return ApiResponse.fail((int)MigrationExceptionEnum.TASK_LOAD_REPORT_EXCEPTION.getCode(), (String)MigrationExceptionEnum.TASK_LOAD_REPORT_EXCEPTION.getMessage());
        }
        try {
            MigrationLoadReportVo loadReport = this.logManager.decode(record.getLoadResult(), MigrationLoadReportVo.class);
            return ApiResponse.success((Object)loadReport);
        }
        catch (MigrationException ex) {
            logger.error("failed to decode migration load result log: task {}, status {}, result {}", new Object[]{loadId, record.getLoadStatus(), record.getLoadResult(), ex});
            return ApiResponse.fail((int)MigrationExceptionEnum.TASK_LOAD_REPORT_EXCEPTION.getCode(), (String)MigrationExceptionEnum.TASK_LOAD_REPORT_EXCEPTION.getMessage());
        }
    }

    public ApiResponse<MigrationDetailVo> detail(Long loadId) {
        MigrationLoadModel record = (MigrationLoadModel)((Object)this.loadRecordManager.getById(loadId));
        if (record == null) {
            return ApiResponse.fail((int)MigrationExceptionEnum.TASK_NOT_FOUND_EXCEPTION.getCode(), (String)MigrationExceptionEnum.TASK_NOT_FOUND_EXCEPTION.getMessage());
        }
        MigrationDetailVo detailVo = this.logManager.decode(record.getArchiveDetail(), MigrationDetailVo.class);
        return ApiResponse.success((Object)detailVo);
    }

    public ApiResponse<MigrationLoadRecordVo> query(Long loadId) {
        MigrationLoadRecordVo record = this.loadRecordManager.query(loadId);
        if (record != null) {
            return ApiResponse.success((Object)record);
        }
        return ApiResponse.fail((int)MigrationExceptionEnum.TASK_NOT_FOUND_EXCEPTION.getCode(), (String)MigrationExceptionEnum.TASK_NOT_FOUND_EXCEPTION.getMessage());
    }

    public ApiResponse<Page<MigrationLoadRecordVo>> list(PageInfo page, MigrationLoadListDto queryLoadParams) {
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        List status = queryLoadParams.getStatus();
        List codes = Optional.ofNullable(status).orElse(Collections.emptyList()).stream().filter(Objects::nonNull).distinct().collect(Collectors.toList());
        queryParams.put("status", codes);
        queryParams.put("startTime", queryLoadParams.getStartTime());
        queryParams.put("endTime", queryLoadParams.getEndTime());
        return ApiResponse.success(this.loadRecordManager.list((Page<MigrationLoadRecordVo>)HussarPageUtils.convert((PageInfo)page), queryParams));
    }

    public ApiResponse<Boolean> remove(Long loadId) {
        MigrationLoadModel record = (MigrationLoadModel)((Object)this.loadRecordManager.getById(loadId));
        if (record != null && MigrationLoadStatus.isPendingOrRunning((Integer)record.getLoadStatus())) {
            logger.error("attempt to remove running migration load/preload task {}", (Object)loadId);
            return ApiResponse.fail((int)MigrationExceptionEnum.TASK_NOT_REMOVABLE_WHEN_RUNNING.getCode(), (String)MigrationExceptionEnum.TASK_NOT_REMOVABLE_WHEN_RUNNING.getMessage());
        }
        boolean removed = this.loadRecordManager.removeById(loadId);
        if (record != null && record.getArchiveFile() != null && this.storageManager.exists(record.getArchiveFile())) {
            try {
                logger.info("remove archive of load task {}", (Object)loadId);
                this.storageManager.remove(record.getArchiveFile());
            }
            catch (Exception ex) {
                logger.warn("cannot remove associated file {} of migration load task {}", (Object)record.getArchiveFile(), (Object)loadId);
            }
        }
        if (record != null) {
            this.removeAssociatedLog(loadId, "upload result", record.getArchiveDetail());
            this.removeAssociatedLog(loadId, "preload parameters", record.getPreloadParameters());
            this.removeAssociatedLog(loadId, "preload result", record.getPreloadResult());
            this.removeAssociatedLog(loadId, "load parameters", record.getLoadParameters());
            this.removeAssociatedLog(loadId, "load result", record.getLoadResult());
        }
        return ApiResponse.success((Object)removed);
    }

    private void removeAssociatedLog(Long loadId, String description, String encodedLog) {
        if (encodedLog != null) {
            logger.info("remove {} log of migration load task {}", (Object)description, (Object)loadId);
            boolean success = this.logManager.free(encodedLog);
            if (!success) {
                logger.warn("cannot remove associated log {} of migration load task {}", (Object)encodedLog, (Object)loadId);
            }
        }
    }

    private File unarchive(File archive, UnarchiveProfile profile) {
        try {
            File workspace = Files.createTempDirectory(WORKSPACE_PREFIX, new FileAttribute[0]).toFile();
            MigrationUnarchiveOptions options = profile.buildOptions();
            MigrationArchiveUtils.unarchive(archive, workspace, options);
            return workspace;
        }
        catch (MigrationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new MigrationException((Throwable)ex);
        }
    }

    private File fetchAndUnarchive(String handle, UnarchiveProfile profile) {
        File download = null;
        try {
            if (handle == null || !this.storageManager.exists(handle)) {
                throw new MigrationException(MESSAGE_ARCHIVE_NOT_FOUND);
            }
            download = Files.createTempFile("archive_load_", ".hussar", new FileAttribute[0]).toFile();
            this.storageManager.download(handle, download);
            File file = this.unarchive(download, profile);
            return file;
        }
        catch (MigrationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new MigrationException((Throwable)ex);
        }
        finally {
            if (download != null && download.exists()) {
                try {
                    FileUtils.forceDelete((File)download);
                }
                catch (IOException ex) {
                    logger.warn("failed to delete temporary download archive", (Throwable)ex);
                }
            }
        }
    }

    private MigrationArchiveManifest loadManifest(File workspace) {
        try {
            byte[] data = FileUtils.readFileToByteArray((File)new File(workspace, "manifest.json"));
            MigrationArchiveManifest manifest = (MigrationArchiveManifest)IdempotentJsonUtils.parse((byte[])data, MigrationArchiveManifest.class);
            if (manifest == null) {
                throw new MigrationException(MESSAGE_ARCHIVE_MANIFEST_PARSE_FAILED);
            }
            return manifest;
        }
        catch (MigrationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new MigrationException((Throwable)ex);
        }
    }

    private <T> List<ArchiveItemExecution<T>> buildExecutions(List<MigrationArchiveItem> items, Map<String, Map<String, T>> paramsCache) {
        if (items == null) {
            items = Collections.emptyList();
        }
        ArrayList<ArchiveItemExecution<T>> executions = new ArrayList<ArchiveItemExecution<T>>();
        for (MigrationArchiveItem item : items) {
            String uuid = item.getUuid();
            String type = item.getType();
            if (uuid == null) {
                throw new MigrationException(MESSAGE_ITEM_MISSING_UUID);
            }
            if (type == null) {
                throw new MigrationException(MESSAGE_ITEM_MISSING_TYPE);
            }
            ArchiveItemExecution<T> execution = new ArchiveItemExecution<T>();
            execution.setItem(item);
            MigrationPlugin service = MigrationPluginHolder.lookup(type);
            execution.setService(service);
            if (paramsCache != null) {
                execution.setParameters(paramsCache.get(uuid));
                if (!paramsCache.containsKey(uuid)) {
                    logger.warn("archive item {} of type {} load parameter is missing", (Object)uuid, (Object)type);
                }
            }
            executions.add(execution);
        }
        return executions;
    }

    private boolean platformCompatible(String dumpPlatform, String loadPlatform) {
        return true;
    }

    private final class LoadItemContext
    extends AbstractMigrationReadonlyContext
    implements MigrationLoadContext {
        private final Long loadId;
        private volatile boolean preloadDataCached;
        private volatile Object preloadData;

        public LoadItemContext(Long loadId, MigrationArchiveManifest manifest, MigrationArchiveItem item, File workspace) {
            super(manifest, item, workspace);
            this.preloadDataCached = false;
            this.preloadData = null;
            this.loadId = loadId;
        }

        public Long getLoadId() {
            return this.loadId;
        }

        public MigrationLoadRecordVo getLoadRecord() {
            return HussarBaseMigrationLoadServiceImpl.this.loadRecordManager.query(this.loadId);
        }

        public Object getPreloadData() {
            if (!this.preloadDataCached) {
                this.preloadData = this.getPreloadDataWithoutCache();
                this.preloadDataCached = true;
            }
            return this.preloadData;
        }

        private Object getPreloadDataWithoutCache() {
            MigrationLoadModel record = (MigrationLoadModel)((Object)HussarBaseMigrationLoadServiceImpl.this.loadRecordManager.getById(this.loadId));
            String rawPreloadResult = Optional.ofNullable(record).map(MigrationLoadModel::getPreloadResult).orElse(null);
            MigrationPreloadReportVo preloadResult = HussarBaseMigrationLoadServiceImpl.this.logManager.decode(rawPreloadResult, MigrationPreloadReportVo.class);
            String expectUuid = this.getUuid();
            if (expectUuid == null) {
                return null;
            }
            for (MigrationPreloadItemVo item : Optional.ofNullable(preloadResult.getItems()).orElse(Collections.emptyList())) {
                String itemUuid = Optional.ofNullable(item).map(MigrationPreloadItemVo::getUuid).orElse(null);
                Object itemData = Optional.ofNullable(item).map(MigrationPreloadItemVo::getData).orElse(null);
                if (!Objects.equals(itemUuid, expectUuid)) continue;
                return itemData;
            }
            return null;
        }
    }

    private final class PreloadItemContext
    extends AbstractMigrationReadonlyContext
    implements MigrationPreloadContext {
        private final Long loadId;

        public PreloadItemContext(Long loadId, MigrationArchiveManifest manifest, MigrationArchiveItem item, File workspace) {
            super(manifest, item, workspace);
            this.loadId = loadId;
        }

        public Long getLoadId() {
            return this.loadId;
        }

        public MigrationLoadRecordVo getLoadRecord() {
            return HussarBaseMigrationLoadServiceImpl.this.loadRecordManager.query(this.loadId);
        }
    }

    private final class UnarchiveProfile {
        private boolean skipStrictVersionCheck = true;
        private boolean skipChecksumVerify = true;
        private boolean skipSignatureVerify = true;
        private boolean requireChecksum = false;
        private boolean requireSignature = false;
        Map<String, Set<String>> signaturePublicKeys;
        Map<String, String> decryptionKeys;

        public UnarchiveProfile() {
            this.initialize();
        }

        public UnarchiveProfile(MigrationPreloadDto migrationPreloadDto) {
            this();
            this.skipStrictVersionCheck = Optional.ofNullable(migrationPreloadDto).map(MigrationPreloadDto::getSkipStrictVersionCheck).orElse(false);
            this.skipChecksumVerify = Optional.ofNullable(migrationPreloadDto).map(MigrationPreloadDto::getSkipChecksumVerify).orElse(false);
            this.skipSignatureVerify = Optional.ofNullable(migrationPreloadDto).map(MigrationPreloadDto::getSkipSignatureVerify).orElse(false);
            this.requireChecksum = hussarBaseMigrationLoadServiceImpl.properties.isRequireChecksum();
            this.requireSignature = hussarBaseMigrationLoadServiceImpl.properties.isRequireSignature();
        }

        public UnarchiveProfile(MigrationLoadDto migrationLoadDto) {
            this();
        }

        private void initialize() {
            this.signaturePublicKeys = HussarBaseMigrationLoadServiceImpl.this.properties.getSignaturePublicKeys();
            this.decryptionKeys = HussarBaseMigrationLoadServiceImpl.this.properties.getDecryptionKeys();
        }

        public MigrationUnarchiveOptions buildOptions() {
            MigrationUnarchiveOptions options = new MigrationUnarchiveOptions();
            options.setVerifyVersion(!this.skipStrictVersionCheck);
            options.setVerifyChecksum(!this.skipChecksumVerify);
            options.setVerifySignature(!this.skipSignatureVerify);
            options.setRequireChecksum(this.requireChecksum);
            options.setRequireSignature(this.requireSignature);
            options.setSignaturePublicKeys(this.signaturePublicKeys);
            options.setDecryptionKeys(this.decryptionKeys);
            return options;
        }

        public boolean isSkipStrictVersionCheck() {
            return this.skipStrictVersionCheck;
        }

        public void setSkipStrictVersionCheck(boolean skipStrictVersionCheck) {
            this.skipStrictVersionCheck = skipStrictVersionCheck;
        }

        public boolean isSkipChecksumVerify() {
            return this.skipChecksumVerify;
        }

        public void setSkipChecksumVerify(boolean skipChecksumVerify) {
            this.skipChecksumVerify = skipChecksumVerify;
        }

        public boolean isSkipSignatureVerify() {
            return this.skipSignatureVerify;
        }

        public void setSkipSignatureVerify(boolean skipSignatureVerify) {
            this.skipSignatureVerify = skipSignatureVerify;
        }

        public boolean isRequireChecksum() {
            return this.requireChecksum;
        }

        public void setRequireChecksum(boolean requireChecksum) {
            this.requireChecksum = requireChecksum;
        }

        public boolean isRequireSignature() {
            return this.requireSignature;
        }

        public void setRequireSignature(boolean requireSignature) {
            this.requireSignature = requireSignature;
        }

        public Map<String, Set<String>> getSignaturePublicKeys() {
            return this.signaturePublicKeys;
        }

        public void setSignaturePublicKeys(Map<String, Set<String>> signaturePublicKeys) {
            this.signaturePublicKeys = signaturePublicKeys;
        }

        public Map<String, String> getDecryptionKeys() {
            return this.decryptionKeys;
        }

        public void setDecryptionKeys(Map<String, String> decryptionKeys) {
            this.decryptionKeys = decryptionKeys;
        }
    }

    private static final class ArchiveItemExecution<T> {
        private MigrationArchiveItem item;
        private MigrationPlugin service;
        private Map<String, T> parameters;

        private ArchiveItemExecution() {
        }

        public MigrationArchiveItem getItem() {
            return this.item;
        }

        public void setItem(MigrationArchiveItem item) {
            this.item = item;
        }

        public MigrationPlugin getService() {
            return this.service;
        }

        public void setService(MigrationPlugin service) {
            this.service = service;
        }

        public Map<String, T> getParameters() {
            return this.parameters;
        }

        public void setParameters(Map<String, T> parameters) {
            this.parameters = parameters;
        }
    }
}

