/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.migration.manager.impl;

import com.fasterxml.jackson.core.type.TypeReference;
import com.jxdinfo.hussar.common.utils.IdempotentJsonUtils;
import com.jxdinfo.hussar.migration.exceptions.MigrationException;
import com.jxdinfo.hussar.migration.manager.HussarBaseMigrationLogManager;
import com.jxdinfo.hussar.migration.manager.HussarBaseMigrationStorageManager;
import com.jxdinfo.hussar.migration.properties.HussarBaseMigrationProperties;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@HussarTokenDs
@Repository(value="com.jxdinfo.hussar.migration.manager.impl.hussarBaseMigrationLogManagerImpl")
public class HussarBaseMigrationLogManagerImpl
implements HussarBaseMigrationLogManager {
    private static final Logger logger = LoggerFactory.getLogger(HussarBaseMigrationLogManagerImpl.class);
    private static final String MESSAGE_BAD_FORMAT = "\u65e5\u5fd7\u5b57\u6bb5\u4e0d\u7b26\u5408\u7f16\u7801\u683c\u5f0f";
    @Autowired
    private HussarBaseMigrationProperties properties;
    @Autowired
    private HussarBaseMigrationStorageManager storageManager;

    @Override
    public String encode(String prefix, Object data) {
        if (data == null) {
            return null;
        }
        byte[] logData = IdempotentJsonUtils.toByteArray((Object)data);
        if (logData.length + "EMBED:".length() < this.properties.getSmallLogThreshold()) {
            logger.info("migration log encode: embed {}", (Object)prefix);
            return "EMBED:" + new String(logData, StandardCharsets.UTF_8);
        }
        String filename = prefix + new SimpleDateFormat("yyyyMMddHHmmssSSS").format(new Date()) + (this.properties.isLogCompress() ? ".mig-gz-log" : ".mig-log");
        logger.info("migration log encode: upload file {}", (Object)filename);
        if (this.properties.isLogCompress()) {
            logData = this.compressLog(logData);
        }
        String handle = this.storageManager.upload(filename, logData);
        return "EXTERNAL:" + handle;
    }

    @Override
    public <T> T decode(String value, Class<T> clazz) {
        byte[] data = this.decode(value);
        if (data == null) {
            return null;
        }
        return (T)IdempotentJsonUtils.parse((byte[])data, clazz);
    }

    @Override
    public <T> T decode(String value, TypeReference<T> typeReference) {
        byte[] data = this.decode(value);
        if (data == null) {
            return null;
        }
        return (T)IdempotentJsonUtils.parse((byte[])data, typeReference);
    }

    private byte[] decode(String value) {
        if (value == null) {
            return null;
        }
        if (value.startsWith("EMBED:")) {
            logger.info("migration log decode: embed");
            String json = StringUtils.removeStart((String)value, (String)"EMBED:");
            return json.getBytes(StandardCharsets.UTF_8);
        }
        if (value.startsWith("EXTERNAL:")) {
            String handle = StringUtils.removeStart((String)value, (String)"EXTERNAL:");
            logger.info("migration log decode: download file {}", (Object)handle);
            byte[] logData = this.storageManager.download(handle);
            logData = this.decompressLogIfGzipDetected(logData);
            return logData;
        }
        logger.warn("migration dump load log decode: bad format: {}", (Object)value);
        throw new MigrationException("\u65e5\u5fd7\u5b57\u6bb5\u4e0d\u7b26\u5408\u7f16\u7801\u683c\u5f0f: " + value);
    }

    @Override
    public boolean free(String value) {
        if (value != null && value.startsWith("EXTERNAL:")) {
            String handle = StringUtils.removeStart((String)value, (String)"EXTERNAL:");
            return this.storageManager.remove(handle);
        }
        return true;
    }

    private byte[] compressLog(byte[] logData) {
        ByteArrayOutputStream compressed = new ByteArrayOutputStream();
        try (GzipCompressorOutputStream destination = new GzipCompressorOutputStream((OutputStream)compressed);){
            IOUtils.write((byte[])logData, (OutputStream)destination);
        }
        catch (IOException ex) {
            throw new MigrationException((Throwable)ex);
        }
        return compressed.toByteArray();
    }

    private byte[] decompressLogIfGzipDetected(byte[] logData) {
        if (logData != null && logData.length >= 2 && logData[0] == 31 && logData[1] == -117) {
            ByteArrayOutputStream decompressed = new ByteArrayOutputStream();
            try (GzipCompressorInputStream source = new GzipCompressorInputStream((InputStream)new ByteArrayInputStream(logData));){
                IOUtils.copy((InputStream)source, (OutputStream)decompressed);
            }
            catch (IOException ex) {
                throw new MigrationException((Throwable)ex);
            }
            return decompressed.toByteArray();
        }
        return logData;
    }
}

